/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CAN_PostalRangeInfo {
    protected short PRE_DIRECTIONAL = 1;
    protected short POST_DIRECTIONAL = (short)2;
    protected short PRE_TYPE = (short)4;
    protected short POST_TYPE = (short)8;
    protected short ALT_PRE_DIRECTIONAL = (short)16;
    protected short ALT_POST_DIRECTIONAL = (short)32;
    protected short ALT_PRE_TYPE = (short)64;
    protected short ALT_POST_TYPE = (short)128;
    protected short ALT_MAIN = (short)256;
    protected short FROM_UNIT = (short)512;
    protected short TO_UNIT = (short)1024;
    protected String mainAddr;
    protected int fromHouse;
    protected int toHouse;
    protected byte parity;
    protected String preDirectional;
    protected String postDirectional;
    protected String preType;
    protected String postType;
    protected String fromUnit;
    protected String toUnit;
    protected String altPreDirectional;
    protected String altPostDirectional;
    protected String altPreType;
    protected String altPostType;
    protected String altName;

    public String getMainAddr() {
        return this.mainAddr;
    }

    public void setMainAddr(String mainAddr) {
        this.mainAddr = mainAddr;
    }

    public int getFromHouse() {
        return this.fromHouse;
    }

    public void setFromHouse(int fromHouse) {
        this.fromHouse = fromHouse;
    }

    public int getToHouse() {
        return this.toHouse;
    }

    public void setToHouse(int toHouse) {
        this.toHouse = toHouse;
    }

    public String getPreDirectional() {
        return this.preDirectional;
    }

    public void setPreDirectional(String preDirectional) {
        this.preDirectional = preDirectional;
    }

    public String getPostDirectional() {
        return this.postDirectional;
    }

    public void setPostDirectional(String postDirectional) {
        this.postDirectional = postDirectional;
    }

    public String getPreType() {
        return this.preType;
    }

    public void setPreType(String preType) {
        this.preType = preType;
    }

    public String getPostType() {
        return this.postType;
    }

    public void setPostType(String postType) {
        this.postType = postType;
    }

    public String getFormattedRange(boolean bIsQC) {
        StringBuffer sb = new StringBuffer();
        if (this.fromHouse != 0 && this.toHouse != 0) {
            sb.append(this.fromHouse);
            if (this.fromHouse != this.toHouse) {
                sb.append(" - ");
                sb.append(this.toHouse);
            }
        }
        String tmp = this.getPreType();
        if (bIsQC) {
            tmp = this.getPostType();
        }
        if (tmp != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(tmp);
        }
        if ((tmp = this.getPreDirectional()) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(tmp);
        }
        if ((tmp = this.getMainAddr()) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(tmp);
        }
        tmp = this.getPostType();
        if (bIsQC) {
            tmp = null;
        }
        if (tmp != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(tmp);
        }
        if ((tmp = this.getPostDirectional()) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(tmp);
        }
        if ((tmp = this.getAltName()) != null) {
            sb.append(' ');
            sb.append('(');
            String t2 = this.getAltPreDirectional();
            if (t2 != null) {
                sb.append(t2);
                sb.append(' ');
            }
            if ((t2 = this.getAltPreType()) != null) {
                sb.append(t2);
                sb.append(' ');
            }
            sb.append(tmp);
            t2 = this.getAltPostType();
            if (t2 != null) {
                sb.append(' ');
                sb.append(t2);
            }
            if ((t2 = this.getAltPostDirectional()) != null) {
                sb.append(t2);
            }
            sb.append(')');
        }
        if ((tmp = this.getFromUnit()) != null) {
            if (sb.length() > 0) {
                sb.append(" : SUITE ");
            }
            sb.append(tmp);
            String tmp2 = this.getToUnit();
            if (tmp2 != null && !tmp2.equals(tmp)) {
                if (sb.length() > 0) {
                    sb.append('-');
                }
                sb.append(tmp2);
            }
        }
        return sb.toString();
    }

    public void read(DataInput file) throws IOException {
        this.setMainAddr(file.readUTF());
        this.setFromHouse(file.readInt());
        this.setToHouse(file.readInt());
        this.setParity(file.readByte());
        short mask = file.readShort();
        if ((mask & this.PRE_DIRECTIONAL) != 0) {
            this.setPreDirectional(file.readUTF());
        }
        if ((mask & this.POST_DIRECTIONAL) != 0) {
            this.setPostDirectional(file.readUTF());
        }
        if ((mask & this.PRE_TYPE) != 0) {
            this.setPreType(file.readUTF());
        }
        if ((mask & this.POST_TYPE) != 0) {
            this.setPostType(file.readUTF());
        }
        if ((mask & this.ALT_MAIN) != 0) {
            this.setAltName(file.readUTF());
        }
        if ((mask & this.ALT_PRE_DIRECTIONAL) != 0) {
            this.setAltPreDirectional(file.readUTF());
        }
        if ((mask & this.ALT_POST_DIRECTIONAL) != 0) {
            this.setAltPostDirectional(file.readUTF());
        }
        if ((mask & this.ALT_PRE_TYPE) != 0) {
            this.setAltPreType(file.readUTF());
        }
        if ((mask & this.ALT_POST_TYPE) != 0) {
            this.setAltPostType(file.readUTF());
        }
        if ((mask & this.FROM_UNIT) != 0) {
            this.setFromUnit(file.readUTF());
        }
        if ((mask & this.TO_UNIT) != 0) {
            this.setToUnit(file.readUTF());
        }
    }

    public void write(DataOutput file) throws IOException {
        String toUnit;
        String fromUnit;
        String apostT;
        String apreT;
        String apostD;
        String apreD;
        String altMain;
        String postT;
        String preT;
        String postD;
        file.writeUTF(this.getMainAddr());
        file.writeInt(this.getFromHouse());
        file.writeInt(this.getToHouse());
        file.writeByte(this.getParity());
        short mask = 0;
        boolean bWritePreD = false;
        boolean bWritePostD = false;
        boolean bWritePreT = false;
        boolean bWritePostT = false;
        boolean bWriteAltName = false;
        boolean bWriteAltPreD = false;
        boolean bWriteAltPostD = false;
        boolean bWriteAltPreT = false;
        boolean bWriteAltPostT = false;
        boolean bWriteFromUnit = false;
        boolean bWriteToUnit = false;
        String preD = this.getPreDirectional();
        if (preD != null && preD.length() != 0) {
            bWritePreD = true;
            mask = (short)(mask | this.PRE_DIRECTIONAL);
        }
        if ((postD = this.getPostDirectional()) != null && postD.length() != 0) {
            bWritePostD = true;
            mask = (short)(mask | this.POST_DIRECTIONAL);
        }
        if ((preT = this.getPreType()) != null && preT.length() != 0) {
            bWritePreT = true;
            mask = (short)(mask | this.PRE_TYPE);
        }
        if ((postT = this.getPostType()) != null && postT.length() != 0) {
            bWritePostT = true;
            mask = (short)(mask | this.POST_TYPE);
        }
        if ((altMain = this.getAltName()) != null && altMain.length() != 0) {
            bWriteAltName = true;
            mask = (short)(mask | this.ALT_MAIN);
        }
        if ((apreD = this.getAltPreDirectional()) != null && apreD.length() != 0) {
            bWriteAltPreD = true;
            mask = (short)(mask | this.ALT_PRE_DIRECTIONAL);
        }
        if ((apostD = this.getAltPostDirectional()) != null && apostD.length() != 0) {
            bWriteAltPostD = true;
            mask = (short)(mask | this.ALT_POST_DIRECTIONAL);
        }
        if ((apreT = this.getAltPreType()) != null && apreT.length() != 0) {
            bWriteAltPreT = true;
            mask = (short)(mask | this.ALT_PRE_TYPE);
        }
        if ((apostT = this.getAltPostType()) != null && apostT.length() != 0) {
            bWriteAltPostT = true;
            mask = (short)(mask | this.ALT_POST_TYPE);
        }
        if ((fromUnit = this.getFromUnit()) != null && fromUnit.length() != 0) {
            bWriteFromUnit = true;
            mask = (short)(mask | this.FROM_UNIT);
        }
        if ((toUnit = this.getToUnit()) != null && toUnit.length() != 0) {
            bWriteToUnit = true;
            mask = (short)(mask | this.TO_UNIT);
        }
        file.writeShort(mask);
        if (bWritePreD) {
            file.writeUTF(preD);
        }
        if (bWritePostD) {
            file.writeUTF(postD);
        }
        if (bWritePreT) {
            file.writeUTF(preT);
        }
        if (bWritePostT) {
            file.writeUTF(postT);
        }
        if (bWriteAltName) {
            file.writeUTF(altMain);
        }
        if (bWriteAltPreD) {
            file.writeUTF(apreD);
        }
        if (bWriteAltPostD) {
            file.writeUTF(apostD);
        }
        if (bWriteAltPreT) {
            file.writeUTF(apreT);
        }
        if (bWriteAltPostT) {
            file.writeUTF(apostT);
        }
        if (bWriteFromUnit) {
            file.writeUTF(fromUnit);
        }
        if (bWriteToUnit) {
            file.writeUTF(toUnit);
        }
    }

    public byte getParity() {
        return this.parity;
    }

    public void setParity(byte parity) {
        this.parity = parity;
    }

    public String getFromUnit() {
        return this.fromUnit;
    }

    public void setFromUnit(String fromUnit) {
        this.fromUnit = fromUnit;
    }

    public String getToUnit() {
        return this.toUnit;
    }

    public void setToUnit(String toUnit) {
        this.toUnit = toUnit;
    }

    public String getAltPreDirectional() {
        return this.altPreDirectional;
    }

    public void setAltPreDirectional(String altPreDirectional) {
        this.altPreDirectional = altPreDirectional;
    }

    public String getAltPostDirectional() {
        return this.altPostDirectional;
    }

    public void setAltPostDirectional(String altPostDirectional) {
        this.altPostDirectional = altPostDirectional;
    }

    public String getAltPreType() {
        return this.altPreType;
    }

    public void setAltPreType(String altPreType) {
        this.altPreType = altPreType;
    }

    public String getAltPostType() {
        return this.altPostType;
    }

    public void setAltPostType(String altPostType) {
        this.altPostType = altPostType;
    }

    public String getAltName() {
        return this.altName;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }
}

