/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.ICAN_StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_Geo2SacRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GeoBase;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJStreetRecord;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardGeoBase;
import com.mapinfo.mapmarker.core.parser.IParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class CAN_StreetDataSourceRecordConvertorImpl
extends StreetDataSourceRecordConvertorImpl {
    private static final Soundex soundex = new CAN_EnglishSoundex();
    protected int recno = 0;
    protected int altStreetsNumber = 0;

    public CAN_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        Address parsed = this.parseStreet(inputStreetAddress);
        if (parsed != null) {
            if (!"100".equals(parsed.getAddressNumber()) || parsed.getMainAddress() == null || parsed.getUnitValue() != null || parsed.getUnitType() != null) {
                DataCreationLogger.getLogger().logInternalError("CAN_StreetDataSourceConvertorImpl::getParsedStreet(): retry parsing with Apt 1 for: " + inputStreetAddress.getMainAddress());
                AddressImpl withAptInput = new AddressImpl(inputStreetAddress);
                withAptInput.setMainAddress(withAptInput.getMainAddress() + " APT 1");
                parsed = this.parseStreet((Address)withAptInput);
                if (!("100".equals(parsed.getAddressNumber()) && parsed.getMainAddress() != null && "1".equals(parsed.getUnitValue()) && "APT".equals(parsed.getUnitType()))) {
                    DataCreationLogger.getLogger().logInternalError("CAN_StreetDataSourceConvertorImpl::getParsedStreet(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
                    return null;
                }
                parsed.setUnitType(null);
                parsed.setUnitValue(null);
            }
        } else {
            DataCreationLogger.getLogger().logInternalError("CAN_StreetDataSourceConvertorImpl::getParsedStreet(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        return parsed;
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        ParsedNumber from = new ParsedNumber(input.getFrom());
        ParsedNumber to = new ParsedNumber(input.getTo());
        int oddEvenBoth = 0;
        if (input.hasStatus()) {
            if (input.getStatus().equals("0")) {
                oddEvenBoth = 2;
            } else if (input.getStatus().equals("1")) {
                oddEvenBoth = 1;
            }
        }
        if (this.isRangeStatusValid(from, to, oddEvenBoth)) {
            return oddEvenBoth;
        }
        if (from.compareTo((Object)to) == 0) {
            return from.isRangeOddEvenBoth();
        }
        return 0;
    }

    private boolean isRangeStatusValid(ParsedNumber from, ParsedNumber to, int oddEvenBoth) {
        if (oddEvenBoth == 0) {
            return false;
        }
        int fromOddEvenBoth = from.isRangeOddEvenBoth();
        return fromOddEvenBoth == to.isRangeOddEvenBoth() && fromOddEvenBoth == oddEvenBoth;
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new CAN_Geo2SacRecord(sac, (CAN_GeoBase)base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new CAN_Geo2SacRecord();
    }

    protected IGeoBase makeGeoBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String areaName3;
        String areaName1;
        if (left && input.hasLeftAreaName3() && input.hasLeftAreaName1()) {
            areaName1 = input.getLeftAreaName1();
            areaName3 = input.getLeftAreaName3();
        } else if (!left && input.hasRightAreaName3() && input.hasRightAreaName1()) {
            areaName1 = input.getRightAreaName1();
            areaName3 = input.getRightAreaName3();
        } else {
            return null;
        }
        MiSoundexKey sndx = (MiSoundexKey)soundex.getSoundex(areaName3);
        if (sndx == null) {
            return null;
        }
        CAN_GeoSoundexKey sndxKey = new CAN_GeoSoundexKey(areaName1, sndx);
        CAN_GeoBase base = new CAN_GeoBase(sndxKey);
        String geoBaseString = base.toString();
        if (geoBaseString.length() > 0) {
            return new StandardGeoBase(geoBaseString);
        }
        return null;
    }

    protected MMJStreetRecord createAlternateStreetRecord(MMJStreetRecord standardRecord, IStreetDataSourceRecord input, Address parsed) throws DataCreationException, DataSourceException {
        HashMap fields;
        Object obj;
        MMJStreetRecord record = super.createAlternateStreetRecord(standardRecord, input, parsed);
        Address addr = record.getAddress();
        if (addr.hasAdditionalFields() && (obj = (fields = addr.getAdditionalFields()).get("CAN_REAL_MAIN_ADDRESS")) != null) {
            addr.setMainAddress((String)obj);
            fields.remove("CAN_REAL_MAIN_ADDRESS");
            record.setBrowseKeys(null);
        }
        return record;
    }

    private void addCleansedAddress(Address pa, List list) {
        Address cleansedAddr = AddressUtils.cleanseAddress(pa);
        if (cleansedAddr != null) {
            list.add(cleansedAddr);
        }
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        ArrayList<Address> list = new ArrayList<Address>();
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address addr = this.getParsedStreet(input, preParsed);
        if (addr != null) {
            ICAN_StreetDataSourceRecord can;
            String altMain;
            boolean bQC = false;
            if ("QC".equalsIgnoreCase(input.getSegment().getLeftAreaName1()) || "QC".equalsIgnoreCase(input.getSegment().getRightAreaName1())) {
                bQC = true;
            }
            list.add(addr);
            this.addCleansedAddress(addr, list);
            if (input.hasAlternateMainAddress() && (altMain = input.getAlternateMainAddress()) != null && altMain.length() != 0) {
                preParsed.setMainAddress(this.makeMainAddressString(altMain, "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    this.adjustQCAltName(bQC, addr);
                    list.add(addr);
                    this.addCleansedAddress(addr, list);
                }
            }
            if ((can = (ICAN_StreetDataSourceRecord)input).hasAdditionalAlternate1() && (altMain = can.getAdditionalAlternate1()).length() > 0) {
                preParsed.setMainAddress(this.makeMainAddressString(altMain, "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    this.adjustQCAltName(bQC, addr);
                    list.add(addr);
                    this.addCleansedAddress(addr, list);
                }
            }
            if (can.hasAdditionalAlternate2() && (altMain = can.getAdditionalAlternate2()).length() > 0) {
                preParsed.setMainAddress(this.makeMainAddressString(altMain, "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    this.adjustQCAltName(bQC, addr);
                    list.add(addr);
                    this.addCleansedAddress(addr, list);
                }
            }
            if (can.hasAdditionalAlternate3() && (altMain = can.getAdditionalAlternate3()).length() > 0) {
                preParsed.setMainAddress(this.makeMainAddressString(altMain, "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    this.adjustQCAltName(bQC, addr);
                    list.add(addr);
                    this.addCleansedAddress(addr, list);
                }
            }
            if (can.hasAdditionalAlternate4() && (altMain = can.getAdditionalAlternate4()).length() > 0) {
                preParsed.setMainAddress(this.makeMainAddressString(altMain, "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    this.adjustQCAltName(bQC, addr);
                    list.add(addr);
                    this.addCleansedAddress(addr, list);
                }
            }
        }
        return list;
    }

    protected MMJStreetRecord makeStreetRecordType() {
        return new CAN_MMJStreetRecord();
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new CAN_MMJSegmentRecord();
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord segmentSource, int sac, boolean bLeft, boolean bRight) throws DataSourceException {
        CAN_MMJSegmentRecord segment = (CAN_MMJSegmentRecord)super.convertSegmentRecord(segmentSource, sac, bLeft, bRight);
        ICAN_SegmentDataSourceRecord canSegmentSource = (ICAN_SegmentDataSourceRecord)segmentSource;
        if (bLeft) {
            if (canSegmentSource.hasLeftCMA()) {
                segment.setLeftCMA(canSegmentSource.getLeftCMA());
            }
            if (canSegmentSource.hasLeftCSD()) {
                segment.setLeftCSD(canSegmentSource.getLeftCSD());
            }
            if (canSegmentSource.hasLeftCT()) {
                segment.setLeftCT(canSegmentSource.getLeftCT());
            }
            if (canSegmentSource.hasLeftDA()) {
                segment.setLeftDA(canSegmentSource.getLeftDA());
            }
            if (canSegmentSource.hasLeftCD()) {
                segment.setLeftCD(canSegmentSource.getLeftCD());
            }
        }
        if (bRight) {
            if (canSegmentSource.hasRightCMA()) {
                segment.setRightCMA(canSegmentSource.getRightCMA());
            }
            if (canSegmentSource.hasRightCSD()) {
                segment.setRightCSD(canSegmentSource.getRightCSD());
            }
            if (canSegmentSource.hasRightCT()) {
                segment.setRightCT(canSegmentSource.getRightCT());
            }
            if (canSegmentSource.hasRightDA()) {
                segment.setRightDA(canSegmentSource.getRightDA());
            }
            if (canSegmentSource.hasRightCD()) {
                segment.setRightCD(canSegmentSource.getRightCD());
            }
        }
        return segment;
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new CAN_MMJRangeRecord();
    }

    private void adjustQCAltName(boolean bQC, Address addr) {
        String post;
        if (!bQC) {
            return;
        }
        CAN_ParsedAddress can = (CAN_ParsedAddress)addr;
        if (!can.isNumericStreetName() && !can.isNumberedRoad() && (post = addr.getPostThoroughfareType()) != null && post.length() != 0) {
            addr.setPreThoroughfareType(post);
            addr.setPostThoroughfareType(null);
        }
    }

    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        boolean bQC = false;
        CAN_MMJStreetRecord record = (CAN_MMJStreetRecord)((Object)super.convert(inputData));
        if (inputData != null && record != null) {
            try {
                String post;
                CAN_ParsedAddress can;
                if ("QC".equals(((IStreetDataSourceRecord)inputData).getSegment().getLeftAreaName1()) && !(can = (CAN_ParsedAddress)record.getAddress()).isNumericStreetName() && !can.isNumberedRoad() && (post = can.getPostThoroughfareType()) != null && post.length() != 0) {
                    can.setPreThoroughfareType(post);
                    can.setPostThoroughfareType(null);
                }
            }
            catch (DataSourceException dataSourceException) {
                // empty catch block
            }
        }
        return record;
    }
}

