/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp;

import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.CAN_PostalRangeInfo;
import com.mapinfo.mapmarker.CAN.dp.CAN_TabPostalRangeDataHandler;
import com.mapinfo.mapmarker.CAN.dp.CAN_TabStreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MultiSegmentStreet;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataHandler;
import com.mapinfo.mapmarker.utils.IntegerSequenceDivider;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CAN_TabStreetDataHandler
extends TabStreetDataHandler {
    protected CAN_TabPostalRangeDataHandler m_rangeHandler;
    protected TreeMap m_provToPostalIdxMap;
    protected Address m_recordAddress = null;
    private String fileBase = null;
    private String outputPath = null;
    private RandomAccessFile file = null;
    private MMJRangeRecordComparator rangeComparator;
    private static String DELIMITERS;
    private static final StringScorer m_scorer;
    private static final Set articleSet;
    private static final Set saintSet;
    private static final int CANPOST_BOTH = 3;

    public CAN_TabStreetDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, MMJStreetRecordComparator streetComparator, MMJSegmentComparer segmentComparer, ITempDataRecordHandler tempHandler, CAN_TabPostalRangeDataHandler rangeHandler) {
        super(dataSourceAccess, dataConvertor, intermediateHandler, streetComparator, segmentComparer, tempHandler);
        this.m_rangeHandler = rangeHandler;
        this.m_provToPostalIdxMap = new TreeMap();
        this.rangeComparator = new MMJRangeRecordComparator();
    }

    public void open(Properties dataProperties) throws DataSourceException {
        super.open(dataProperties);
        this.fileBase = this.getDataProperties().getProperty("street_range_index_file_name");
        this.outputPath = this.getDataProperties().getProperty("street_outputFilePath");
        StringBuffer buf = new StringBuffer();
        buf.append(this.fileBase);
        buf.append(".mmj");
        try {
            this.file = new RandomAccessFile(StringUtilities.appendToPath((String)this.outputPath, (String)buf.toString()), "r");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected IDataSourceRecord makeDataSourceRecord(IDataSourceRecordObjects objects) {
        return new CAN_TabStreetDataSourceRecord((TabDataSourceRecordObjects)objects);
    }

    public Object getNextDataRecord() throws DataCreationException {
        CAN_MultiSegmentStreet street = (CAN_MultiSegmentStreet)((Object)super.getNextDataRecord());
        if (street != null) {
            this.m_recordAddress = street.getAddress();
            this.addCanPostToStreet(street);
        }
        return street;
    }

    protected MultiSegmentStreet makeMultiSegmentStreet(MMJStreetRecord street) {
        return new CAN_MultiSegmentStreet(street, this.getSegmentComparer());
    }

    protected ArrayList getNextDataRecords() throws DataSourceException {
        ArrayList streetRecords = super.getNextDataRecords();
        if (streetRecords != null) {
            CAN_MMJStreetRecord[] streets = streetRecords.toArray(new CAN_MMJStreetRecord[0]);
            for (int i = 0; i < streets.length; ++i) {
                CAN_MMJSegmentRecord segment = (CAN_MMJSegmentRecord)streets[i].getSegment();
                List ranges = segment.getRanges();
                boolean allDesc = true;
                boolean someDesc = false;
                if (ranges != null && ranges.size() > 0) {
                    for (CAN_MMJRangeRecord range : ranges) {
                        if (!range.isAscending()) {
                            someDesc = true;
                            continue;
                        }
                        allDesc = false;
                    }
                } else {
                    allDesc = false;
                }
                if (allDesc) {
                    segment.reverse();
                    for (CAN_MMJRangeRecord range : ranges) {
                        range.reverse();
                    }
                    continue;
                }
                if (!someDesc) continue;
                CAN_MMJStreetRecord street = new CAN_MMJStreetRecord(streets[i]);
                CAN_MMJSegmentRecord segmentCopy = new CAN_MMJSegmentRecord(segment);
                segmentCopy.reverse();
                if (segmentCopy.getRanges() != null) {
                    segmentCopy.getRanges().clear();
                }
                street.setSegment(segmentCopy);
                Iterator iterator = ranges.iterator();
                while (iterator.hasNext()) {
                    CAN_MMJRangeRecord range = (CAN_MMJRangeRecord)((Object)iterator.next());
                    if (range.isAscending()) continue;
                    iterator.remove();
                    range.reverse();
                    street.getSegment().addRange((MMJRangeRecord)range);
                }
                streetRecords.add(street);
            }
        }
        return streetRecords;
    }

    private void addCanPostToStreet(CAN_MultiSegmentStreet street) {
        List segs = street.getSegments();
        if (segs == null) {
            return;
        }
        for (MMJSegmentRecord seg : segs) {
            List ranges = seg.getRanges();
            if (ranges == null) continue;
            Object[] origRanges = ranges.toArray();
            for (int i = origRanges.length - 1; i >= 0; --i) {
                MMJRangeRecord range = (MMJRangeRecord)origRanges[i];
                ArrayList combinedRanges = this.combineWithPostalRanges(seg, range);
                ranges.remove(i);
                for (int j = 0; j < combinedRanges.size(); ++j) {
                    seg.addRange((MMJRangeRecord)combinedRanges.get(j));
                }
            }
        }
    }

    protected ArrayList combineWithPostalRanges(MMJSegmentRecord segment, MMJRangeRecord originalRange) {
        int rangeHigh;
        ArrayList<MMJRangeRecord> listOfRanges = new ArrayList<MMJRangeRecord>();
        int rangeLow = (int)originalRange.getFromHouse().getAddressNumber();
        if (rangeLow > (rangeHigh = (int)originalRange.getToHouse().getAddressNumber())) {
            int tmp = rangeLow;
            rangeLow = rangeHigh;
            rangeHigh = tmp;
        }
        boolean leftSide = originalRange.isLeft();
        int rangeOddEven = originalRange.getOddEven();
        String prov = segment.getLeftAreaName1();
        if (prov == null && (prov = segment.getRightAreaName1()) == null) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        TreeMap fsaTree = (TreeMap)this.m_provToPostalIdxMap.get(prov);
        if (fsaTree == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.fileBase);
            buf.append(".tdx");
            try {
                fsaTree = this.m_rangeHandler.readIndexFile(buf.toString(), this.outputPath);
                this.m_provToPostalIdxMap.put(prov, fsaTree);
            }
            catch (DataCreationException dataCreationException) {
                // empty catch block
            }
        }
        if (fsaTree == null) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        String fsa = leftSide ? segment.getLeftPostalCode1() : segment.getRightPostalCode1();
        if (fsa == null) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        TreeMap lduTree = (TreeMap)fsaTree.get(fsa);
        if (lduTree == null) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        String mainAddress = this.m_recordAddress.getMainAddress();
        if (mainAddress == null || mainAddress.length() == 0) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        try {
            int i;
            IntegerSequenceDivider origRangeSpan = new IntegerSequenceDivider(rangeLow, rangeHigh, rangeOddEven);
            Iterator it = lduTree.keySet().iterator();
            boolean bAdded = false;
            while (it.hasNext()) {
                String treeLduKey = (String)it.next();
                Integer intPtr = (Integer)lduTree.get(treeLduKey);
                ArrayList infoArray = this.m_rangeHandler.readRangeEntries(this.file, intPtr);
                int count = infoArray.size();
                for (i = 0; i < count; ++i) {
                    CAN_PostalRangeInfo info = (CAN_PostalRangeInfo)infoArray.get(i);
                    if (!this.rangeMatches(info, rangeOddEven, rangeLow, rangeHigh)) continue;
                    int fromHouse = info.getFromHouse();
                    int toHouse = info.getToHouse();
                    origRangeSpan.removeRange(fromHouse, toHouse);
                    if (fromHouse < rangeLow) {
                        fromHouse = rangeLow;
                    }
                    if (toHouse > rangeHigh) {
                        toHouse = rangeHigh;
                    }
                    listOfRanges.add(this.makeRangeRecord(treeLduKey, fromHouse, toHouse, rangeOddEven, leftSide));
                    bAdded = true;
                }
            }
            ArrayList originalPieces = origRangeSpan.getRemainingRanges();
            for (i = 0; i < originalPieces.size(); ++i) {
                IntegerSequenceDivider.IntegerSegment originalPiece = (IntegerSequenceDivider.IntegerSegment)originalPieces.get(i);
                listOfRanges.add(this.makeRangeRecord(null, originalPiece.getStart(), originalPiece.getEnd(), rangeOddEven, leftSide));
            }
            if (bAdded) {
                Collections.sort(listOfRanges, this.rangeComparator);
            }
        }
        catch (FileNotFoundException ex) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        catch (IOException ex) {
            listOfRanges.add(originalRange);
            return listOfRanges;
        }
        return listOfRanges;
    }

    private boolean rangeMatches(CAN_PostalRangeInfo info, int rangeOddEven, int rangeLow, int rangeHigh) {
        int fromHouse = info.getFromHouse();
        int toHouse = info.getToHouse();
        byte parity = info.getParity();
        if (parity == 3) {
            if (rangeOddEven == 1) {
                if (fromHouse % 2 == 0) {
                    fromHouse = fromHouse <= toHouse ? ++fromHouse : --fromHouse;
                    info.setFromHouse(fromHouse);
                }
                if (toHouse % 2 == 0) {
                    toHouse = toHouse >= fromHouse ? --toHouse : ++toHouse;
                    info.setToHouse(toHouse);
                }
            } else if (rangeOddEven == 2) {
                if (fromHouse % 2 != 0) {
                    fromHouse = fromHouse <= toHouse ? ++fromHouse : --fromHouse;
                    info.setFromHouse(fromHouse);
                }
                if (toHouse % 2 != 0) {
                    toHouse = toHouse >= fromHouse ? --toHouse : ++toHouse;
                    info.setToHouse(toHouse);
                }
            }
        } else if (rangeOddEven == 1 ? fromHouse % 2 == 0 || toHouse % 2 == 0 : rangeOddEven == 2 && (fromHouse % 2 != 0 || toHouse % 2 != 0)) {
            return false;
        }
        if (fromHouse < rangeLow && toHouse < rangeLow) {
            return false;
        }
        if (fromHouse > rangeHigh && toHouse > rangeHigh) {
            return false;
        }
        if (!CAN_TabStreetDataHandler.directionalsMatch(info.getPreDirectional(), this.m_recordAddress.getPreDirectional(), info.getPostDirectional(), this.m_recordAddress.getPostDirectional())) {
            return false;
        }
        if (!CAN_TabStreetDataHandler.typesMatch(info.getPreType(), this.m_recordAddress.getPreThoroughfareType(), info.getPostType(), this.m_recordAddress.getPostThoroughfareType())) {
            return false;
        }
        return CAN_TabStreetDataHandler.namesMatch(this.m_recordAddress.getMainAddress(), info.getMainAddr());
    }

    private MMJRangeRecord makeRangeRecord(String ldu, int lowhHouseNr, int highHouseNr, int oddEven, boolean leftSide) {
        CAN_MMJRangeRecord range = new CAN_MMJRangeRecord();
        range.setFromHouse(String.valueOf(lowhHouseNr));
        range.setToHouse(String.valueOf(highHouseNr));
        range.setOddEven(oddEven);
        if (ldu != null) {
            range.setLDU(ldu);
        }
        if (leftSide) {
            range.setLeft();
        } else {
            range.setRight();
        }
        return range;
    }

    private static boolean namesMatch(String main, String other) {
        int tokCount;
        if (main.equals(other)) {
            return true;
        }
        if (CAN_TabStreetDataHandler.differByOrdinal(main, other)) {
            return true;
        }
        StringTokenizer mainTokens = new StringTokenizer(main, DELIMITERS);
        StringTokenizer otherTokens = new StringTokenizer(other, DELIMITERS);
        if (mainTokens.countTokens() > 1) {
            mainTokens = CAN_TabStreetDataHandler.adjustTokens(mainTokens);
        }
        if (otherTokens.countTokens() > 1) {
            otherTokens = CAN_TabStreetDataHandler.adjustTokens(otherTokens);
        }
        if ((tokCount = mainTokens.countTokens()) != otherTokens.countTokens()) {
            return false;
        }
        while (mainTokens.hasMoreTokens()) {
            String otherTok;
            String mainTok = mainTokens.nextToken();
            if (m_scorer.scoreString(mainTok, otherTok = otherTokens.nextToken(), "'") == 1.0) continue;
            boolean bAllowDiff = false;
            if (mainTok.endsWith("S") && m_scorer.scoreString(mainTok, otherTok + 'S', "'") == 1.0) {
                bAllowDiff = true;
            }
            if (otherTok.endsWith("S") && m_scorer.scoreString(mainTok + 'S', otherTok, "'") == 1.0) {
                bAllowDiff = true;
            }
            if (bAllowDiff) continue;
            return false;
        }
        return true;
    }

    private static boolean differByOrdinal(String main, String other) {
        int mainLen = main.length();
        int otherLen = other.length();
        if (Character.isDigit(main.charAt(0))) {
            if (mainLen == otherLen + 2) {
                char last = main.charAt(mainLen - 1);
                char next = main.charAt(mainLen - 2);
                if ((next == 'S' && last == 'T' || next == 'N' && last == 'D' || next == 'R' && last == 'D' || next == 'T' && last == 'H') && main.startsWith(other)) {
                    return true;
                }
            } else if (otherLen == mainLen + 2) {
                char last = other.charAt(otherLen - 1);
                char next = other.charAt(otherLen - 2);
                if ((next == 'S' && last == 'T' || next == 'N' && last == 'D' || next == 'R' && last == 'D' || next == 'T' && last == 'H') && other.startsWith(main)) {
                    return true;
                }
            } else {
                if (mainLen == otherLen + 1 && main.startsWith(other) && main.endsWith("E")) {
                    return true;
                }
                if (otherLen == mainLen + 1 && other.startsWith(main) && other.endsWith("E")) {
                    return true;
                }
                if (mainLen == otherLen + 4 && main.startsWith(other) && main.endsWith("I\u00c8RE")) {
                    return true;
                }
                if (otherLen == mainLen + 4 && other.startsWith(main) && other.endsWith("I\u00c8RE")) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 4) {
            System.out.println("usage: CAN_TAbStreetDataHandler main1 main2");
            System.out.println("usage: CAN_TAbStreetDataHandler predir1 predir2 postdir1 postdir2");
            System.exit(1);
        }
        String main = args[0];
        String other = args[1];
        if (args.length == 2) {
            System.out.println("comparing " + main + " to " + other + ".");
            System.out.println("returns " + CAN_TabStreetDataHandler.namesMatch(main, other));
            return;
        }
        String main2 = args[2];
        String other2 = args[3];
        System.out.println("comparing " + main + ", " + other + ", " + main2 + "," + other2 + ".");
        System.out.println("returns " + CAN_TabStreetDataHandler.directionalsMatch(main, other, main2, other2));
    }

    private static StringTokenizer adjustTokens(StringTokenizer tokens) {
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (articleSet.contains(token)) continue;
            if (saintSet.contains(token)) {
                token = "ST";
            }
            buf.append(token);
            buf.append(' ');
        }
        return new StringTokenizer(buf.toString());
    }

    private static boolean directionalsMatch(String preMain, String preOther, String postMain, String postOther) {
        return !(preMain != null && preOther != null && preMain.length() != 0 && preOther.length() != 0 ? !CAN_TabStreetDataHandler.directionalsEquivalent(preMain, preOther) : (postMain != null && postOther != null && postMain.length() != 0 && postOther.length() != 0 ? !CAN_TabStreetDataHandler.directionalsEquivalent(postMain, postOther) : (postMain != null && preOther != null && postMain.length() != 0 && preOther.length() != 0 ? !CAN_TabStreetDataHandler.directionalsEquivalent(postMain, preOther) : preMain != null && postOther != null && preMain.length() != 0 && postOther.length() != 0 && !CAN_TabStreetDataHandler.directionalsEquivalent(preMain, postOther))));
    }

    private static boolean directionalsEquivalent(String main, String other) {
        if (main.length() != other.length()) {
            return false;
        }
        if (main.equals(other)) {
            return true;
        }
        char m = main.charAt(0);
        char o = other.charAt(0);
        if (main.length() == 1 && (m == 'O' && o == 'W' || m == 'W' && o == 'O')) {
            return true;
        }
        if (main.length() == 2 && m == o) {
            m = main.charAt(1);
            o = other.charAt(1);
            if (m == 'O' && o == 'W' || m == 'W' && o == 'O') {
                return true;
            }
        }
        return false;
    }

    private static boolean typesMatch(String preMain, String preOther, String postMain, String postOther) {
        return !(preMain != null && preOther != null && preMain.length() != 0 && preOther.length() != 0 ? !preMain.equals(preOther) : (postMain != null && postOther != null && postMain.length() != 0 && postOther.length() != 0 ? !postMain.equals(postOther) : (postMain != null && preOther != null && postMain.length() != 0 && preOther.length() != 0 ? !postMain.equals(preOther) : preMain != null && postOther != null && preMain.length() != 0 && postOther.length() != 0 && !preMain.equals(postOther))));
    }

    static {
        int i;
        DELIMITERS = ",- .\t\n\r\f";
        String[] FRENCH_ARTICLES = new String[]{"DE", "DES", "DU", "LA", "LE", "LES"};
        String[] SAINTS = new String[]{"ST", "STE", "SAINT", "SAINTE", "SAINTS", "SAINTES", "STS", "STES"};
        StringBuffer buf = new StringBuffer();
        buf.append("& c ; \u00e7 , \u00c7 ");
        buf.append("& n ; \u00f1 , \u00d1 ");
        buf.append("& a ; \u00e0 , \u00c0 , \u00e1 , \u00c1 , \u00e4 , \u00c4 ,  \u00e2 , \u00c2 , \u00e3 , \u00c3 ");
        buf.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea , \u00c8 , \u00c9, \u00ca , \u00cb ");
        buf.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef , \u00cd , \u00cc , \u00cf , \u00ce");
        buf.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f5 , \u00d2 , \u00d3 , \u00d4, \u00d5 , \u00f3 ");
        buf.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc , \u00da , \u00d9 , \u00db , \u00dc ");
        m_scorer = new StringScorer(true, new Locale("ca", "CA"), buf.toString());
        HashSet<String> articles = new HashSet<String>(FRENCH_ARTICLES.length);
        for (i = 0; i < FRENCH_ARTICLES.length; ++i) {
            articles.add(FRENCH_ARTICLES[i]);
        }
        articleSet = Collections.unmodifiableSet(articles);
        HashSet saints = new HashSet(SAINTS.length);
        for (i = 0; i < SAINTS.length; ++i) {
            articles.add(SAINTS[i]);
        }
        saintSet = Collections.unmodifiableSet(saints);
    }
}

