/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IMunicipalityCrossReferenceRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.MunicipalityLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.binary.MMJAlternateItem;
import com.mapinfo.mapmarker.CAN.dp.binary.MMJMunicipalityRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractMunicipalityProcessor {
    private String m_outputPath;
    private IDataSource m_addressLookupSource;
    private IDataSource m_textLookupSource;
    private AccentsLookup m_accentsLookup;
    private MunicipalityLookup m_municipalityLookup;
    private RandomAccessDataStream m_dataStream;
    private DataOutputStream m_indexStream;
    private int m_recordCount;
    private int m_recordsWithAlternatesCount;

    protected AbstractMunicipalityProcessor(String outputPath, IDataSource addressLookupSource, IDataSource textLookupSource, AccentsLookup accentsLookup, MunicipalityLookup municipalityLookup) {
        this.m_outputPath = outputPath;
        this.m_addressLookupSource = addressLookupSource;
        this.m_textLookupSource = textLookupSource;
        this.m_accentsLookup = accentsLookup;
        this.m_municipalityLookup = municipalityLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws DataCreationException {
        HashSet<MMJMunicipalityRecord> municipalities = new HashSet<MMJMunicipalityRecord>();
        try {
            IDataSourceRecordObjects addressObjects;
            DataCreationLogger.getLogger().logStatus("Processing " + this.m_addressLookupSource.getRecordCount() + " address records");
            while ((addressObjects = this.m_addressLookupSource.getNextDataSourceRecordObjects()) != null) {
                IStandardElements elements = this.getStandardElements(addressObjects);
                MMJMunicipalityRecord record = this.buildMunicipalityRecord(elements);
                municipalities.add(record);
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(2000, "Unable to access address lookup", (Throwable)DSEx);
        }
        try {
            IDataSourceRecordObjects textObjects;
            DataCreationLogger.getLogger().logStatus("Processing " + this.m_textLookupSource.getRecordCount() + " text lookup records");
            while ((textObjects = this.m_textLookupSource.getNextDataSourceRecordObjects()) != null) {
                IStandardElements elements = this.getStandardElements(textObjects);
                MMJMunicipalityRecord record = this.buildMunicipalityRecord(elements);
                municipalities.add(record);
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(2000, "Unable to access text lookup", (Throwable)DSEx);
        }
        try {
            try {
                DataCreationLogger.getLogger().logStatus("creating output files");
                this.createOutputFiles();
            }
            catch (IOException IOEx) {
                throw new DataCreationException(2000, "Unable to create output municipalities files", (Throwable)IOEx);
            }
            DataCreationLogger.getLogger().logStatus("process records");
            for (MMJMunicipalityRecord record : municipalities) {
                ++this.m_recordCount;
                this.addAlternates(record);
                this.output(record);
            }
            DataCreationLogger.getLogger().logStatus(this.m_recordCount + " records processed");
            DataCreationLogger.getLogger().logStatus(this.m_recordsWithAlternatesCount + " had alternates");
        }
        finally {
            if (this.m_dataStream != null) {
                try {
                    this.m_dataStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.m_indexStream != null) {
                try {
                    this.m_indexStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.index();
    }

    protected abstract IStandardElements getStandardElements(IDataSourceRecordObjects var1);

    private MMJMunicipalityRecord buildMunicipalityRecord(IStandardElements elements) {
        String accentedMunicipality = elements.getMunicipalityNameAccentIndicator() ? this.m_accentsLookup.get(elements.getMunicipalityName()) : null;
        return new MMJMunicipalityRecord(elements.getProvinceCode(), elements.getMunicipalityName(), accentedMunicipality);
    }

    private void addAlternates(MMJMunicipalityRecord record) {
        Collection alternates = this.m_municipalityLookup.getAlternates(record.getProvince(), record.getMunicipality());
        if (alternates != null) {
            ++this.m_recordsWithAlternatesCount;
            Iterator iterator = alternates.iterator();
            while (iterator.hasNext()) {
                record.addAlternate(new MMJAlternateItem((IMunicipalityCrossReferenceRecord)iterator.next()));
            }
        }
    }

    private void createOutputFiles() throws IOException {
        this.m_dataStream = new RandomAccessDataStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)"municip", (String)"jdr")));
        this.m_indexStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)"municip", (String)"tdx")))));
    }

    private void output(MMJMunicipalityRecord record) throws DataCreationException {
        try {
            long offset = this.m_dataStream.getFilePointer();
            MapMarkerIndexKey key = this.makeKey(record);
            key.write((DataOutput)this.m_indexStream);
            this.m_indexStream.writeLong(offset);
            this.write(record);
        }
        catch (IOException IOEx) {
            throw new DataCreationException(2000, "Unable to write output", (Throwable)IOEx);
        }
    }

    private MapMarkerIndexKey makeKey(MMJMunicipalityRecord record) {
        String keyString = record.getMunicipalityWithAccents() != null ? record.getMunicipalityWithAccents() : record.getMunicipality();
        return new MiStringIndexKey(record.getProvince() + keyString);
    }

    private void write(MMJMunicipalityRecord record) throws IOException {
        record.write((DataOutput)this.m_dataStream, null);
    }

    private void index() throws DataCreationException {
        MiStringIndexFileConvertor convertor = new MiStringIndexFileConvertor(StringUtilities.appendToPath((String)this.m_outputPath, (String)"municip", (String)"tdx"), StringUtilities.appendToPath((String)this.m_outputPath, (String)"municip", (String)"jdx"));
        convertor.convert();
        DataCreationLogger.getLogger().logStatus("Index file converted");
    }
}

