/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.CAN_Constraints;
import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.dp.CAN_DataConstructionParser;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MergedStreetBuilder;
import com.mapinfo.mapmarker.CAN.dp.binary.index.AlternatePostalInputIndexFileHelper;
import com.mapinfo.mapmarker.CAN.dp.binary.index.AlternatePostalNIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.CAN.dp.binary.index.CAN_GeoInfoMiSoundexIndexFileConvertor;
import com.mapinfo.mapmarker.CAN.dp.binary.index.CAN_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedPostInfoIndexFileConvertor;
import com.mapinfo.mapmarker.CAN.dp.merge.text.CAN_PointDataFileMasksProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.CAN_StandardDataFileMasksProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergedStreetDataHandler;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.IInputIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MultiLevelNIOInnerIndexConvertor;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.Properties;

public abstract class CAN_AbstractDataProvider
extends AbstractDataProvider {
    private static MiVersion m_version = new MiVersion(4, 0, 0);
    private MMJComplexDataFileMetadata m_streetMetadata;
    private MMJComplexDataFileMetadata m_geoInfoMetadata;
    private MMJComplexDataFileMetadata m_postInfoMetadata;
    private static final String PARCEL_DATA_KEY = "street_parcelData";
    private boolean m_bIsPointData;

    protected CAN_AbstractDataProvider() {
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_bIsPointData = "YES".equals(processingProperties.getProperty(PARCEL_DATA_KEY));
        this.m_dataBuilder = new CAN_MergedStreetBuilder();
        CAN_MergedStreetDataSourceRecordConvertor convertor = new CAN_MergedStreetDataSourceRecordConvertor(new CAN_EnglishSoundex(), processingProperties, new CollationKeyGenerator(new Locale("CA", "CAN")), CAN_AbstractDataProvider.getParser(), CAN_AbstractDataProvider.getParserConstraints());
        CAN_MergedIntermediateStreetDataFileFormatHandler intermediateHandler = new CAN_MergedIntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp"));
        this.m_streetDataHandler = new MergedStreetDataHandler(convertor, intermediateHandler);
    }

    public boolean supportsReverseGeocode() {
        return true;
    }

    protected static IParser getParser() {
        return new CAN_DataConstructionParser();
    }

    protected static Constraints getParserConstraints() {
        return new CAN_Constraints();
    }

    private MiStringIndexFile getGeoInfoIndexFile() throws DataCreationException {
        String path = this.m_processProperties.getProperty("street_geoInfo_path");
        MiStringIndexFile index = new MiStringIndexFile();
        try {
            index.open(StringUtilities.appendToPath((String)path, (String)"geoinfo.jdx"));
            return index;
        }
        catch (IOException IOEx) {
            throw new DataCreationException(2000, "Unable to open geoinfo.jdx at: " + path, (Throwable)IOEx);
        }
    }

    private MiStringIndexFile getMunicipIndexFile() throws DataCreationException {
        String path = this.m_processProperties.getProperty("street_geoInfo_path");
        MiStringIndexFile index = new MiStringIndexFile();
        try {
            index.open(StringUtilities.appendToPath((String)path, (String)"municip.jdx"));
            return index;
        }
        catch (IOException IOEx) {
            throw new DataCreationException(2000, "Unable to open municip.jdx at: " + path, (Throwable)IOEx);
        }
    }

    public void preProcessStreetDataSet() throws DataCreationException {
        ((CAN_MergedStreetBuilder)this.m_dataBuilder).setGeoInfoIndex(this.getGeoInfoIndexFile());
        ((CAN_MergedStreetBuilder)this.m_dataBuilder).setMunicipalityIndex(this.getMunicipIndexFile());
        super.preProcessStreetDataSet();
    }

    private DataFileMasks getStreetMasks() {
        if (this.m_bIsPointData) {
            return CAN_PointDataFileMasksProvider.buildStreetDataFileMasks();
        }
        return CAN_StandardDataFileMasksProvider.buildStreetDataFileMasks();
    }

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = new MMJComplexDataFileMetadata();
            this.m_streetMetadata.setCountry("CAN");
            this.m_streetMetadata.setVersion(new MiVersion(4, 0, 0));
            this.m_streetMetadata.setXPow10((byte)5);
            this.m_streetMetadata.setYPow10((byte)5);
            this.m_streetMetadata.setDataFileMasks(this.getStreetMasks());
            this.m_streetMetadata.setFrequentStrings(this.m_streetFrequentStrings);
            this.m_streetMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_streetMetadata;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (this.m_postInfoMetadata == null) {
            this.m_postInfoMetadata = new MMJComplexDataFileMetadata();
            this.m_postInfoMetadata.setCountry("CAN");
            this.m_postInfoMetadata.setXPow10((byte)5);
            this.m_postInfoMetadata.setYPow10((byte)5);
            this.m_postInfoMetadata.setVersion(m_version);
            this.m_postInfoMetadata.setDataFileMasks(this.getPostInfoDataFileMasks());
            this.m_postInfoMetadata.setFrequentStrings(this.m_postinfoFrequentStrings);
            this.m_postInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_postInfoMetadata;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.m_geoInfoMetadata == null) {
            this.m_geoInfoMetadata = new MMJComplexDataFileMetadata();
            this.m_geoInfoMetadata.setCountry("CAN");
            this.m_geoInfoMetadata.setXPow10((byte)5);
            this.m_geoInfoMetadata.setYPow10((byte)5);
            this.m_geoInfoMetadata.setVersion(m_version);
            this.m_geoInfoMetadata.setDataFileMasks(this.getGeoInfoDataFileMasks());
            this.m_geoInfoMetadata.setFrequentStrings(this.m_geoinfoFrequentStrings);
            this.m_geoInfoMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_geoInfoMetadata;
    }

    public byte[] getAlternateStreetSearchSupportedTypes() {
        if ("YES".equals(this.m_processProperties.getProperty("REVERSE_POSTAL_INDEX"))) {
            return new byte[]{0, 1, 2};
        }
        return new byte[]{0, 2};
    }

    public String getAlternateSearchTypeTempIndexExtension(byte alternateType) {
        if (alternateType == 1) {
            return ".tpx";
        }
        if (alternateType == 2) {
            return ".tkx";
        }
        return super.getAlternateSearchTypeTempIndexExtension(alternateType);
    }

    public String getAlternateSearchTypeFinalIndexExtension(byte alternateType) {
        if (alternateType == 1) {
            return ".pcx";
        }
        return super.getAlternateSearchTypeFinalIndexExtension(alternateType);
    }

    public RandomAccessFile getAlternateSearchIndexFile(byte alternateSearchIndexType) throws DataCreationException {
        if (alternateSearchIndexType == 1 || alternateSearchIndexType == 2) {
            String streetBaseName = this.m_processProperties.getProperty("street_outputFile");
            String extension = this.getAlternateSearchTypeTempIndexExtension(alternateSearchIndexType);
            if (extension == null) {
                return null;
            }
            String fileName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)streetBaseName, (String)extension);
            return this.getAlternateIndexFileForName(fileName);
        }
        return super.getAlternateSearchIndexFile(alternateSearchIndexType);
    }

    public IFileInnerIndexConvertor getStreetAlternateSearchTypeIndexFileConvertor(byte alternateType) {
        if (alternateType == 1) {
            return new MultiLevelNIOInnerIndexConvertor((IInputIndexFileHelper)new AlternatePostalInputIndexFileHelper(), (INIOMultiLevelInnerIndexHelper)new AlternatePostalNIOMultiLevelInnerIndexHelper(), (MapMarkerIndexFileMetadata)new MapMarkerMultiLevelIndexFileMetadata(2));
        }
        return super.getStreetAlternateSearchTypeIndexFileConvertor(alternateType);
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        return new CAN_GeoInfoSoundexIndexer();
    }

    public IndexFileConvertor getPostInfoIndexFileConvertor(String tempIndex, String newIndex) {
        return new EncodedPostInfoIndexFileConvertor(tempIndex, newIndex);
    }

    public IndexFileConvertor getSoundexGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new CAN_GeoInfoMiSoundexIndexFileConvertor(tempIndex, newIndex);
    }

    private DataFileMasks getPostInfoDataFileMasks() {
        if (this.m_bIsPointData) {
            return CAN_PointDataFileMasksProvider.buildPostInfoDataFileMasks();
        }
        return CAN_StandardDataFileMasksProvider.buildPostInfoDataFileMasks();
    }

    private DataFileMasks getGeoInfoDataFileMasks() {
        if (this.m_bIsPointData) {
            return CAN_PointDataFileMasksProvider.buildGeoInfoDataFileMasks();
        }
        return CAN_StandardDataFileMasksProvider.buildGeoInfoDataFileMasks();
    }
}

