/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.CAN_CensusInfo;
import com.mapinfo.mapmarker.CAN.CAN_InternalCandidateAddress;
import com.mapinfo.mapmarker.CAN.CAN_Range;
import com.mapinfo.mapmarker.CAN.CAN_RangeUnit;
import com.mapinfo.mapmarker.CAN.CAN_Segment;
import com.mapinfo.mapmarker.CAN.CAN_StreetCandidateAddress;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.CAN.dp.binary.DataEncoder;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import java.io.IOException;
import java.util.Properties;

public class CAN_AddressFetcher
extends GenericAddressFetcher {
    private final CAN_DataDictionary.DICTIONARY_TYPE m_dictionaryType;

    public CAN_AddressFetcher(CAN_DataDictionary.DICTIONARY_TYPE dictionaryType, Properties localSettings, Properties localStrings) {
        super(localSettings, localStrings);
        this.m_dictionaryType = dictionaryType;
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        super.populateCandidateFromData(cand, street, streetOffset, metadata);
        cand.setCountry("CAN");
        CAN_StreetCandidateAddress streetCand = (CAN_StreetCandidateAddress)cand;
        GenericStreet genericStreet = (GenericStreet)street;
        FrequentDataFileStrings strings = ((MMJComplexDataFileMetadata)metadata).getFrequentStrings();
        try {
            if (genericStreet.hasByte(62)) {
                streetCand.setPreDirectional(strings.getFrequentString(2, FrequentDataFileStrings.convertByteToIndex((byte)GenericDataItemAccessor.getDataByte((int)62, (GenericDataItem)genericStreet))));
            }
            if (genericStreet.hasByte(61)) {
                streetCand.setPostDirectional(strings.getFrequentString(2, FrequentDataFileStrings.convertByteToIndex((byte)GenericDataItemAccessor.getDataByte((int)61, (GenericDataItem)genericStreet))));
            }
            if (genericStreet.hasString(62)) {
                streetCand.setOriginalName(genericStreet.getString(62));
            }
            if (genericStreet.hasByte(60)) {
                streetCand.setDeliveryInstallationInfo(strings.getFrequentString(3, FrequentDataFileStrings.convertByteToIndex((byte)GenericDataItemAccessor.getDataByte((int)60, (GenericDataItem)genericStreet))));
            } else if (genericStreet.hasString(61)) {
                streetCand.setDeliveryInstallationInfo(genericStreet.getString(61));
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            throw new LocalizationException((Throwable)MMJETASEEx);
        }
    }

    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        super.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
        CAN_Segment can = (CAN_Segment)segment;
        CAN_GeoInfoFetcherImpl geoFetcher = (CAN_GeoInfoFetcherImpl)dict.getGeoInfoFetcher();
        if (genericSegment.hasShort(50)) {
            String FSA = DataEncoder.decodeFSA(GenericDataItemAccessor.getDataShort((int)50, (GenericDataItem)genericSegment));
            segment.setLeftPostCode1(FSA);
            segment.setRightPostCode1(FSA);
        }
        if (genericSegment.hasLong(0)) {
            long geoOffset = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericSegment);
            GeoInfoRecord record = geoFetcher.getGeoInfoRecord(geoOffset);
            can.setLeftGeoInfoRecord(record);
            can.setRightGeoInfoRecord(record);
        } else {
            if (genericSegment.hasLong(62)) {
                long geoOffset = GenericDataItemAccessor.getDataLong((int)62, (GenericDataItem)genericSegment);
                can.setLeftGeoInfoRecord(geoFetcher.getGeoInfoRecord(geoOffset));
            }
            if (genericSegment.hasLong(61)) {
                long geoOffset = GenericDataItemAccessor.getDataLong((int)61, (GenericDataItem)genericSegment);
                can.setRightGeoInfoRecord(geoFetcher.getGeoInfoRecord(geoOffset));
            }
        }
        try {
            CAN_CensusInfo left = null;
            CAN_CensusInfo right = null;
            short value = this.getShort((GenericDataItem)genericSegment, 61);
            if (value >= 0) {
                left = new CAN_CensusInfo();
                right = new CAN_CensusInfo();
                left.setCD(value);
                right.setCD(value);
                value = this.getShort((GenericDataItem)genericSegment, 62);
                if (value >= 0) {
                    left.setDA(value);
                    right.setDA(value);
                } else {
                    value = this.getShort((GenericDataItem)genericSegment, 58);
                    if (value >= 0) {
                        left.setDA(value);
                    }
                    if ((value = this.getShort((GenericDataItem)genericSegment, 54)) >= 0) {
                        right.setDA(value);
                    }
                }
                value = this.getShort((GenericDataItem)genericSegment, 59);
                if (value >= 0) {
                    left.setCSD(value);
                    right.setCSD(value);
                } else {
                    value = this.getShort((GenericDataItem)genericSegment, 55);
                    if (value >= 0) {
                        left.setCSD(value);
                    }
                    if ((value = this.getShort((GenericDataItem)genericSegment, 51)) >= 0) {
                        right.setCSD(value);
                    }
                }
            } else {
                value = this.getShort((GenericDataItem)genericSegment, 57);
                if (value >= 0) {
                    left = new CAN_CensusInfo();
                    left.setCD(value);
                    value = this.getShort((GenericDataItem)genericSegment, 58);
                    if (value >= 0) {
                        left.setDA(value);
                    }
                    if ((value = this.getShort((GenericDataItem)genericSegment, 55)) >= 0) {
                        left.setCSD(value);
                    }
                }
                if ((value = this.getShort((GenericDataItem)genericSegment, 53)) >= 0) {
                    right = new CAN_CensusInfo();
                    right.setCD(value);
                    value = this.getShort((GenericDataItem)genericSegment, 54);
                    if (value >= 0) {
                        right.setDA(value);
                    }
                    if ((value = this.getShort((GenericDataItem)genericSegment, 51)) >= 0) {
                        right.setCSD(value);
                    }
                }
            }
            value = this.getShort((GenericDataItem)genericSegment, 60);
            if (value >= 0) {
                if (left == null) {
                    left = new CAN_CensusInfo();
                }
                if (right == null) {
                    right = new CAN_CensusInfo();
                }
                left.setCMA(value);
                right.setCMA(value);
                int intValue = this.getInt((GenericDataItem)genericSegment, 62);
                if (intValue >= 0) {
                    left.setCT(intValue);
                    right.setCT(intValue);
                } else {
                    left.setCT(this.getInt((GenericDataItem)genericSegment, 61));
                    right.setCT(this.getInt((GenericDataItem)genericSegment, 60));
                }
            } else {
                value = this.getShort((GenericDataItem)genericSegment, 56);
                if (value >= 0) {
                    if (left == null) {
                        left = new CAN_CensusInfo();
                    }
                    left.setCMA(value);
                    left.setCT(this.getInt((GenericDataItem)genericSegment, 61));
                }
                if ((value = this.getShort((GenericDataItem)genericSegment, 52)) >= 0) {
                    if (right == null) {
                        right = new CAN_CensusInfo();
                    }
                    right.setCMA(value);
                    right.setCT(this.getInt((GenericDataItem)genericSegment, 60));
                }
            }
            if (left != null && right != null && left.equals(right)) {
                can.setLeftCensusInfo(left);
                can.setRightCensusInfo(left);
            } else {
                can.setLeftCensusInfo(left);
                can.setRightCensusInfo(right);
            }
        }
        catch (MMJETypeArraySizeExceededException ex) {
            throw new LocalizationException((Throwable)ex);
        }
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        DataEncoder.RouteService routeService;
        super.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
        CAN_Range CANRange = (CAN_Range)range;
        if (genericRange.hasShort(61)) {
            CANRange.setLDU(DataEncoder.decodeLDU(GenericDataItemAccessor.getDataShort((int)61, (GenericDataItem)genericRange)));
        } else if (genericRange.hasString(62)) {
            CANRange.setLDU(GenericDataItemAccessor.getDataString((int)62, (GenericDataItem)genericRange));
        }
        if (genericRange.hasShort(60)) {
            routeService = DataEncoder.decodeRouteService(GenericDataItemAccessor.getDataShort((int)60, (GenericDataItem)genericRange));
            CANRange.setRouteServiceType(routeService.getType());
            CANRange.setRouteServiceNumber(routeService.getNumber());
        } else if (genericRange.hasUnsignedShort(58)) {
            routeService = DataEncoder.decodeRouteService(GenericDataItemAccessor.getDataUnsignedShort((int)60, (GenericDataItem)genericRange));
            CANRange.setRouteServiceType(routeService.getType());
            CANRange.setRouteServiceNumber(routeService.getNumber());
        } else {
            if (genericRange.hasString(61)) {
                CANRange.setRouteServiceType(GenericDataItemAccessor.getDataString((int)61, (GenericDataItem)genericRange));
            }
            if (genericRange.hasShort(62)) {
                CANRange.setRouteServiceNumber(GenericDataItemAccessor.getDataShort((int)62, (GenericDataItem)genericRange));
            }
        }
        long municipOffset = -1L;
        if (genericRange.hasUnsignedShort(62)) {
            municipOffset = GenericDataItemAccessor.getDataUnsignedShort((int)62, (GenericDataItem)genericRange);
        } else if (genericRange.hasUnsignedShort(61)) {
            municipOffset = 65535 + GenericDataItemAccessor.getDataUnsignedShort((int)61, (GenericDataItem)genericRange);
        } else if (genericRange.hasUnsignedShort(60)) {
            municipOffset = 131070 + GenericDataItemAccessor.getDataUnsignedShort((int)60, (GenericDataItem)genericRange);
        } else if (genericRange.hasUnsignedShort(59)) {
            municipOffset = 196605 + GenericDataItemAccessor.getDataUnsignedShort((int)59, (GenericDataItem)genericRange);
        } else if (genericRange.hasInteger(62)) {
            municipOffset = GenericDataItemAccessor.getDataInt((int)62, (GenericDataItem)genericRange);
        }
        if (municipOffset >= 0L) {
            try {
                CANRange.setMunicipalityRecord(((CAN_DataDictionary)dict).getMunicipalityRecord(municipOffset));
            }
            catch (DataAccessException DAEx) {
                throw new LocalizationException((Throwable)DAEx);
            }
        }
        if (genericRange.hasString(58)) {
            CANRange.setPbkey(GenericDataItemAccessor.getDataString((int)58, (GenericDataItem)genericRange));
        }
    }

    protected void populateRangeUnitFromData(RangeUnit unit, GenericUnit genericUnit, MMJDataFileMetadata metadata, IDataDictionary dict, RangeUnit lastUnit) throws LocalizationException, IOException {
        CharSequence number;
        if (genericUnit.hasByte(60)) {
            number = new StringBuffer(1);
            ((StringBuffer)number).append((char)GenericDataItemAccessor.getDataByte((int)60, (GenericDataItem)genericUnit));
            String numberStr = ((StringBuffer)number).toString();
            unit.setLowUnit(numberStr);
            unit.setHighUnit(numberStr);
        } else if (genericUnit.hasUnsignedByte(60)) {
            short number2 = GenericDataItemAccessor.getDataUnsignedByte((int)60, (GenericDataItem)genericUnit);
            unit.setLowUnit((int)number2);
            unit.setHighUnit((int)number2);
        } else if (genericUnit.hasUnsignedShort(60)) {
            int number3 = GenericDataItemAccessor.getDataUnsignedShort((int)60, (GenericDataItem)genericUnit);
            unit.setLowUnit(number3);
            unit.setHighUnit(number3);
        } else if (genericUnit.hasString(62)) {
            number = GenericDataItemAccessor.getDataString((int)62, (GenericDataItem)genericUnit);
            unit.setLowUnit((String)number);
            unit.setHighUnit((String)number);
        } else {
            if (genericUnit.hasByte(62)) {
                number = new StringBuffer(1);
                ((StringBuffer)number).append((char)GenericDataItemAccessor.getDataByte((int)62, (GenericDataItem)genericUnit));
                unit.setLowUnit(((StringBuffer)number).toString());
            } else if (genericUnit.hasUnsignedByte(62)) {
                unit.setLowUnit((int)GenericDataItemAccessor.getDataUnsignedByte((int)62, (GenericDataItem)genericUnit));
            } else if (genericUnit.hasUnsignedShort(62)) {
                unit.setLowUnit(GenericDataItemAccessor.getDataUnsignedShort((int)62, (GenericDataItem)genericUnit));
            } else if (genericUnit.hasString(0)) {
                unit.setLowUnit(GenericDataItemAccessor.getDataString((int)0, (GenericDataItem)genericUnit));
            }
            if (genericUnit.hasByte(61)) {
                number = new StringBuffer(1);
                ((StringBuffer)number).append((char)GenericDataItemAccessor.getDataByte((int)61, (GenericDataItem)genericUnit));
                unit.setHighUnit(((StringBuffer)number).toString());
            } else if (genericUnit.hasUnsignedByte(61)) {
                unit.setHighUnit((int)GenericDataItemAccessor.getDataUnsignedByte((int)61, (GenericDataItem)genericUnit));
            } else if (genericUnit.hasUnsignedShort(61)) {
                unit.setHighUnit(GenericDataItemAccessor.getDataUnsignedShort((int)61, (GenericDataItem)genericUnit));
            } else if (genericUnit.hasString(1)) {
                unit.setHighUnit(GenericDataItemAccessor.getDataString((int)1, (GenericDataItem)genericUnit));
            }
        }
        if (genericUnit.hasString(3)) {
            unit.setPlaceName(GenericDataItemAccessor.getDataString((int)3, (GenericDataItem)genericUnit));
        }
        if (genericUnit.hasShort(62)) {
            ((CAN_RangeUnit)unit).setLDU(DataEncoder.decodeLDU(GenericDataItemAccessor.getDataShort((int)62, (GenericDataItem)genericUnit)));
        } else if (genericUnit.hasString(33)) {
            ((CAN_RangeUnit)unit).setLDU(GenericDataItemAccessor.getDataString((int)33, (GenericDataItem)genericUnit));
        }
        if (genericUnit.hasString(58)) {
            CAN_RangeUnit canUnit = (CAN_RangeUnit)unit;
            canUnit.setPbkey(GenericDataItemAccessor.getDataString((int)58, (GenericDataItem)genericUnit));
        }
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new CAN_InternalCandidateAddress((CAN_StreetCandidateAddress)street);
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new CAN_StreetCandidateAddress(this.m_dictionaryType);
    }

    protected Range makeRange() {
        return new CAN_Range();
    }

    protected Segment makeSegment() {
        return new CAN_Segment();
    }

    protected RangeUnit makeRangeUnit() {
        return new CAN_RangeUnit();
    }

    private short getShort(GenericDataItem gs, int key) throws MMJETypeArraySizeExceededException {
        if (gs.hasShort(key)) {
            return gs.getShort(key);
        }
        return -1;
    }

    private int getInt(GenericDataItem gs, int key) throws MMJETypeArraySizeExceededException {
        if (gs.hasInteger(key)) {
            return gs.getInt(key);
        }
        return -1;
    }
}

