/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.CAN_StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.CAN.dp.binary.index.AlternatePostalIndexKey;
import com.mapinfo.mapmarker.CAN.licensing.CANLicenseFilter;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StreetDataIndexValue;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.MappedSeekableDataInputStream;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class CAN_DataManager
extends AbstractDataManager {
    public static final String KEY_CAN_ALTERNATE_SOUNDEX_CODES = "KEY_CAN_ALTERNATE_SOUNDEX_CODES";
    private static Throwable m_SetupException;
    private static Properties m_DataResources;
    private static IDataDictionary[] m_dataDicts;
    private static int m_numDicts;
    private static LicenseFilter m_licenseFilter;
    private CAN_StreetCandidateAddressFilter m_streetFilter;

    private static void start() {
        m_SetupException = null;
        try {
            m_DataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("CAN");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage());
            m_SetupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_DataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new CAN_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    CAN_DataManager.m_dataDicts[i] = new CAN_DataDictionary(i, m_DataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_SetupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        try {
            m_licenseFilter = new CANLicenseFilter();
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
    }

    public CAN_DataManager() throws MMJEDataManagerInitializationException {
        if (m_SetupException != null) {
            throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
        }
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    public static void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                CAN_DataManager.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            CAN_DataManager.start();
            if (m_SetupException != null) {
                throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
            }
        }
    }

    private static void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            if (dict != null) {
                dict.close();
            }
            CAN_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
        MappedSeekableDataInputStream.releaseAllStreams();
    }

    protected LicenseFilter getLicenseFilter() {
        return m_licenseFilter;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("CAN");
    }

    protected StreetCandidateAddressFilter getStreetFilter() {
        if (this.m_streetFilter == null) {
            this.m_streetFilter = new CAN_StreetCandidateAddressFilter();
        }
        return this.m_streetFilter;
    }

    public void addPostInfoTo(CandidateAddress addr, IConstraints constraints, int dictNumber) throws DataAccessException {
        IDataDictionary dict = this.getDictionary(dictNumber);
        if (dict.getPostInfoFetcher() != null) {
            ((CAN_PostInfoFetcherImpl)dict.getPostInfoFetcher()).addPostInfoTo(addr, constraints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapMarkerIndexValue getAlternateSearchLocation(IDataDictionary dict, int sac, AlternateSearchTypeKey key, String streetFileName) throws IOException {
        boolean bNotMapped;
        MapMarkerIndexKey searchKey = key.getSearchKey();
        if (searchKey instanceof MapMarkerStreetMultiLevelIndexKey) {
            ((MapMarkerStreetMultiLevelIndexKey)searchKey).replaceSac(sac);
        } else if (searchKey instanceof AlternatePostalIndexKey) {
            ((AlternatePostalIndexKey)searchKey).replaceSAC(sac);
        } else {
            return null;
        }
        String fullPath = StringUtilities.appendToPath((String)dict.getDictionaryPath(), (String)streetFileName, (String)((CAN_DataDictionary)dict).getAlternateStreetSearchIndexExtension(key.getSearchType()));
        MappedSeekableDataInputStream indexFile = MappedSeekableDataInputStream.getInstance((File)new File(fullPath));
        boolean bl = bNotMapped = indexFile == null;
        if (bNotMapped) {
            indexFile = FileProviderFactory.getFileProvider().get(fullPath);
        }
        try {
            MapMarkerMultiLevelReadOnlyIndexFile index = (MapMarkerMultiLevelReadOnlyIndexFile)dict.getAlternateStreetSearchIndexFile(key.getSearchType(), streetFileName);
            MapMarkerIndexValue mapMarkerIndexValue = index.search(searchKey, (SeekableDataInput)indexFile);
            return mapMarkerIndexValue;
        }
        finally {
            if (bNotMapped) {
                FileProviderFactory.getFileProvider().release((SeekableDataInput)indexFile);
            }
        }
    }

    protected MapMarkerIndexValue getAlternateBrowseLocation(IDataDictionary dict, int sac, AlternateSearchTypeKey key, String streetFileName) throws IOException {
        IMapMarkerReadOnlyIndexFile indexFile = dict.getAlternateStreetBrowseIndexFile(key.getSearchType(), streetFileName);
        MapMarkerIndexKey searchKey = key.getSearchKey();
        if (searchKey instanceof MapMarkerBrowseMultiLevelIndexKey) {
            ((MapMarkerBrowseMultiLevelIndexKey)searchKey).replaceSac(sac);
        } else if (searchKey instanceof AlternatePostalIndexKey) {
            ((AlternatePostalIndexKey)searchKey).replaceSAC(sac);
        } else {
            return null;
        }
        return indexFile.search(searchKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getStreetDataLocation(IDataDictionary dict, int sac, ISoundexKey base, String streetFileName, String path) throws IOException {
        boolean bNotMapped;
        String fullPath = StringUtilities.appendToPath((String)path, (String)streetFileName, (String)"jdx");
        MapMarkerIndexKey key = dict.makeStreetIndexKey(base, sac);
        MappedSeekableDataInputStream indexFile = MappedSeekableDataInputStream.getInstance((File)new File(fullPath));
        boolean bl = bNotMapped = indexFile == null;
        if (bNotMapped) {
            indexFile = FileProviderFactory.getFileProvider().get(fullPath);
        }
        try {
            MapMarkerMultiLevelReadOnlyIndexFile index = (MapMarkerMultiLevelReadOnlyIndexFile)dict.getStreetIndexFile(streetFileName);
            StreetDataIndexValue indexValue = (StreetDataIndexValue)index.search(key, (SeekableDataInput)indexFile);
            if (indexValue != null) {
                long l = indexValue.getStreetOffset();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            if (bNotMapped) {
                FileProviderFactory.getFileProvider().release((SeekableDataInput)indexFile);
            }
        }
    }

    static {
        try {
            Properties settings = DataManagerSettingsProvider.getInstance().getSettingsForCountry("CAN");
            if (settings.getProperty("DO_NOT_PRE_INIT") == null) {
                CAN_DataManager.start();
            }
        }
        catch (IOException IOEx) {
            CAN_DataManager.start();
        }
    }
}

