/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import java.util.Collections;

public class CAN_MMJStreetRecordComparator
extends MMJStreetRecordComparator {
    protected MMJRangeRecordComparator rangeComparator = new MMJRangeRecordComparator();

    public int compare(Object o1, Object o2) {
        MMJStreetRecord record1 = (MMJStreetRecord)o1;
        MMJStreetRecord record2 = (MMJStreetRecord)o2;
        if (record1.getSegment().getRanges() != null && !record1.getSegment().rangesSorted()) {
            Collections.sort(record1.getSegment().getRanges(), this.rangeComparator);
            record1.getSegment().setRangesSorted();
        }
        if (record2.getSegment().getRanges() != null && !record2.getSegment().rangesSorted()) {
            Collections.sort(record2.getSegment().getRanges(), this.rangeComparator);
            record2.getSegment().setRangesSorted();
        }
        if (record1.getSac() == record2.getSac()) {
            if (record1.getKey().equals(record2.getKey())) {
                return this.compareStreetInfo(record1, record2);
            }
            return record1.getKey().compareTo((Object)record2.getKey());
        }
        if (record1.getSac() < record2.getSac()) {
            return -1;
        }
        return 1;
    }

    protected int compareStreetInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        String addressString2;
        String addressString1 = this.buildStreetString(record1.getAddress());
        if (addressString1.equals(addressString2 = this.buildStreetString(record2.getAddress()))) {
            return this.comparePostalInfo(record1, record2);
        }
        return addressString1.compareTo(addressString2);
    }

    protected String buildStreetString(Address address) {
        if (address == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        String temp = address.getPreDirectional();
        buff.append(temp == null ? "" : temp);
        temp = address.getPreThoroughfareType();
        buff.append(temp == null ? "" : temp);
        temp = address.getMainAddress();
        buff.append(temp == null ? "" : temp);
        temp = address.getPostThoroughfareType();
        buff.append(temp == null ? "" : temp);
        temp = address.getPostDirectional();
        buff.append(temp == null ? "" : temp);
        return buff.toString();
    }

    protected int comparePostalInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getLeftPostalCode1() != null && record1.getSegment().getRightPostalCode1() != null && record1.getSegment().getLeftPostalCode1().equals(record1.getSegment().getRightPostalCode1())) {
            if (record2.getSegment().getLeftPostalCode1() != null && record2.getSegment().getRightPostalCode1() != null && record2.getSegment().getLeftPostalCode1().equals(record2.getSegment().getRightPostalCode1())) {
                if (record1.getSegment().getLeftPostalCode1().equals(record2.getSegment().getLeftPostalCode1())) {
                    return this.compareGeoInfo(record1, record2);
                }
                return record1.getSegment().getLeftPostalCode1().compareTo(record2.getSegment().getLeftPostalCode1());
            }
            return 1;
        }
        if (record2.getSegment().getLeftPostalCode1() != null && record2.getSegment().getRightPostalCode1() != null && record2.getSegment().getLeftPostalCode1().equals(record2.getSegment().getRightPostalCode1())) {
            return -1;
        }
        return this.compareGeoInfo(record1, record2);
    }

    protected int compareGeoInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getLeftAreaName3() != null && record1.getSegment().getRightAreaName3() != null && record1.getSegment().getLeftAreaName3().equals(record1.getSegment().getRightAreaName3())) {
            if (record2.getSegment().getLeftAreaName3() != null && record2.getSegment().getRightAreaName3() != null && record2.getSegment().getLeftAreaName3().equals(record2.getSegment().getRightAreaName3())) {
                if (record1.getSegment().getLeftAreaName3().equals(record2.getSegment().getLeftAreaName3())) {
                    return this.compareRangeInfo(record1, record2);
                }
                return record1.getSegment().getLeftAreaName3().compareTo(record2.getSegment().getLeftAreaName3());
            }
            return 1;
        }
        if (record2.getSegment().getLeftAreaName3() != null && record2.getSegment().getRightAreaName3() != null && record2.getSegment().getLeftAreaName3().equals(record2.getSegment().getRightAreaName3())) {
            return -1;
        }
        return this.compareRangeInfo(record1, record2);
    }

    protected int compareRangeInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getRanges() != null) {
            if (record2.getSegment().getRanges() != null) {
                ParsedNumber lowestHouse1 = record1.getSegment().getLowestHouse();
                ParsedNumber lowestHouse2 = record2.getSegment().getLowestHouse();
                return lowestHouse1.compareTo((Object)lowestHouse2);
            }
            return 1;
        }
        if (record2.getSegment().getRanges() != null) {
            return -1;
        }
        return 0;
    }
}

