/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.CAN.dp.CAN_MergedRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GenericStreetBuilder;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MergedMultiSegmentStreet;
import com.mapinfo.mapmarker.CAN.dp.binary.DataEncoder;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import java.io.IOException;

public class CAN_MergedStreetBuilder
extends CAN_GenericStreetBuilder {
    private MiStringIndexFile m_municipIndex;

    public void setMunicipalityIndex(MiStringIndexFile municipIndex) {
        this.m_municipIndex = municipIndex;
    }

    protected void populateLocalStreetInfo(MultiSegmentStreet streetRecord, IDataFileDataItem streetItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericStreet street = (GenericStreet)streetItem;
        CAN_MergedMultiSegmentStreet can = (CAN_MergedMultiSegmentStreet)streetRecord;
        try {
            int index;
            if (street.hasString(5)) {
                String preDir = street.getString(5);
                index = metadata.getFrequentStrings().getStringNumber(2, preDir);
                if (index != -1) {
                    street.removeString(5);
                    street.putByte(62, FrequentDataFileStrings.convertIndexToByte((int)index));
                }
            }
            if (street.hasString(9)) {
                String postDir = street.getString(9);
                index = metadata.getFrequentStrings().getStringNumber(2, postDir);
                if (index != -1) {
                    street.removeString(9);
                    street.putByte(61, FrequentDataFileStrings.convertIndexToByte((int)index));
                }
            }
            if (can.getOriginalName() != null) {
                street.putString(62, can.getOriginalName());
            }
            if (can.getDeliveryInstallationInfo() != null) {
                int index2 = metadata.getFrequentStrings().getStringNumber(3, can.getDeliveryInstallationInfo());
                if (index2 != -1) {
                    street.putByte(60, FrequentDataFileStrings.convertIndexToByte((int)index2));
                } else {
                    street.putString(61, can.getDeliveryInstallationInfo());
                }
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(101, (Throwable)MMJETASEEx);
        }
    }

    @Override
    protected void populateLocalSegmentInfo(MMJSegmentRecord record, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        super.populateLocalSegmentInfo(record, segmentItem, metadata);
        GenericSegment segment = (GenericSegment)segmentItem;
        try {
            if (segment.hasString(12)) {
                String FSA = segment.getString(12);
                segment.removeString(12);
                segment.putShort(50, DataEncoder.encodeFSA(FSA));
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(106, (Throwable)MMJETASEEx);
        }
    }

    @Override
    protected void populateLocalRangeInfo(MMJRangeRecord record, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        super.populateLocalRangeInfo(record, rangeItem, metadata);
        GenericRange range = (GenericRange)rangeItem;
        CAN_MergedRangeRecord can = (CAN_MergedRangeRecord)record;
        try {
            int offset;
            if (range.hasString(62)) {
                String LDU = range.getString(62);
                range.removeString(62);
                range.putShort(61, DataEncoder.encodeLDU(LDU));
            }
            String province = can.getProvince();
            String municipality = can.getMunicipality();
            if (province != null && municipality != null && (offset = this.getMunicipOffset(province, municipality)) >= 0) {
                if (offset < 65535) {
                    range.putUnsignedShort(62, offset);
                } else if (offset - 65535 <= 65535) {
                    range.putUnsignedShort(61, offset - 65535);
                } else if (offset - 131070 <= 65535) {
                    range.putUnsignedShort(60, offset - 131070);
                } else if (offset - 196605 <= 65535) {
                    range.putUnsignedShort(59, offset - 196605);
                } else {
                    range.putInt(62, offset);
                }
            }
            if (can.getRouteServiceType() != null) {
                DataEncoder.RouteService routeService = new DataEncoder.RouteService(can.getRouteServiceType(), can.getRouteServiceNumber());
                int encodedRouteService = DataEncoder.encodeRouteService(routeService);
                if (encodedRouteService <= Short.MAX_VALUE) {
                    range.putShort(60, (short)encodedRouteService);
                } else {
                    range.putUnsignedShort(58, encodedRouteService);
                }
            }
            if (can.hasPbkey()) {
                range.putString(58, can.getPbkey());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(107, (Throwable)e);
        }
    }

    protected void populateLocalRangeUnitInfo(MMJRangeUnitRecord record, IDataFileDataItem unitItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        CAN_MMJRangeUnitRecord canUnit = (CAN_MMJRangeUnitRecord)record;
        GenericUnit unit = (GenericUnit)unitItem;
        try {
            ParsedNumber highUnit;
            ParsedNumber lowUnit;
            if (canUnit.getLDU() != null) {
                unit.putShort(62, DataEncoder.encodeLDU(canUnit.getLDU()));
            }
            if (unit.hasString(0) && unit.hasString(1) && (lowUnit = new ParsedNumber(unit.getString(0))).equals((Object)(highUnit = new ParsedNumber(unit.getString(1))))) {
                if (lowUnit.isPureNumeric()) {
                    if (lowUnit.getAddressNumber() <= 255L) {
                        unit.putUnsignedByte(60, (short)lowUnit.getAddressNumber());
                        unit.removeString(0);
                        unit.removeString(1);
                    } else if (lowUnit.getAddressNumber() <= 65535L) {
                        unit.putUnsignedShort(60, (int)lowUnit.getAddressNumber());
                        unit.removeString(0);
                        unit.removeString(1);
                    }
                } else if (lowUnit.getCombinedAddressNumber().length() == 1) {
                    unit.putByte(60, (byte)lowUnit.getCombinedAddressNumber().charAt(0));
                    unit.removeString(0);
                    unit.removeString(1);
                } else {
                    unit.putString(62, lowUnit.getCombinedAddressNumber());
                    unit.removeString(0);
                    unit.removeString(1);
                }
            }
            if (unit.hasString(0)) {
                lowUnit = new ParsedNumber(unit.getString(0));
                if (lowUnit.isPureNumeric()) {
                    if (lowUnit.getAddressNumber() <= 255L) {
                        unit.putUnsignedByte(62, (short)lowUnit.getAddressNumber());
                        unit.removeString(0);
                    } else if (lowUnit.getAddressNumber() <= 65535L) {
                        unit.putUnsignedShort(62, (int)lowUnit.getAddressNumber());
                        unit.removeString(0);
                    }
                } else if (lowUnit.getCombinedAddressNumber().length() == 1) {
                    unit.putByte(62, (byte)lowUnit.getCombinedAddressNumber().charAt(0));
                    unit.removeString(0);
                }
            }
            if (unit.hasString(1)) {
                ParsedNumber highUnit2 = new ParsedNumber(unit.getString(1));
                if (highUnit2.isPureNumeric()) {
                    if (highUnit2.getAddressNumber() <= 255L) {
                        unit.putUnsignedByte(61, (short)highUnit2.getAddressNumber());
                        unit.removeString(1);
                    } else if (highUnit2.getAddressNumber() <= 65535L) {
                        unit.putUnsignedShort(61, (int)highUnit2.getAddressNumber());
                        unit.removeString(1);
                    }
                } else if (highUnit2.getCombinedAddressNumber().length() == 1) {
                    unit.putByte(61, (byte)highUnit2.getCombinedAddressNumber().charAt(0));
                    unit.removeString(1);
                }
            }
            if (canUnit.hasPbkey()) {
                unit.putString(58, canUnit.getPbkey());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate local unit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(108, (Throwable)e);
        }
    }

    private int getMunicipOffset(String province, String municipality) throws DataCreationException {
        MiStringIndexKey key = new MiStringIndexKey(province + municipality);
        try {
            MapMarkerIndexSingleValue value = (MapMarkerIndexSingleValue)this.m_municipIndex.search((MapMarkerIndexKey)key);
            if (value != null) {
                return (int)value.getOffset();
            }
            DataCreationLogger.getLogger().logInternalError("Unable to lookup " + province + " " + municipality);
            return -1;
        }
        catch (IOException IOEx) {
            throw new DataCreationException(2000, "Unable to access municip index", (Throwable)IOEx);
        }
    }
}

