/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedLoadablePostInfoIndexFile;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedPostInfoIndexFileHelper;
import com.mapinfo.mapmarker.CAN.dp.binary.index.EncodedPostInfoIndexKey;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexValue;
import java.io.IOException;

public class CAN_UDPostInfoFetcher
extends PostInfoFetcherImpl {
    public CAN_UDPostInfoFetcher(String dataPath) throws DataDictionaryIntializationException {
        super(dataPath, null, null);
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new CAN_UDPostInfoDataAccessHelper();
    }

    protected IDataAccess getDataAccessType() {
        return new OnDemandDataAccess(this.getDataAccessHelperType());
    }

    protected IMapMarkerIndex getPostInfoIndexType() {
        return new EncodedLoadablePostInfoIndexFile(new EncodedPostInfoIndexFileHelper());
    }

    private MapMarkerIndexKey makeFSAKey(String FSA) {
        return new EncodedPostInfoIndexKey(FSA, null);
    }

    public PostInfoRecord getRecordForFSA(String FSA) throws DataSourceException {
        StandardPostInfoIndexValue value;
        if (FSA == null) {
            return null;
        }
        try {
            value = (StandardPostInfoIndexValue)this.getPostInfoIndex().search(this.makeFSAKey(FSA));
        }
        catch (IOException IOEx) {
            throw new DataSourceException("Unable to search index for FSA key: " + FSA, (Throwable)IOEx);
        }
        PostInfoRecord record = null;
        if (value != null) {
            try {
                record = (PostInfoRecord)this.getPostInfoDataAccess().getRecord(value.getPostalOffset());
            }
            catch (DataAccessException DAEx) {
                throw new DataSourceException("Unable to get postinfo record at: " + value.getPostalOffset(), (Throwable)DAEx);
            }
        } else {
            DataCreationLogger.getLogger().logInternalError("Unable to find postinfo FSA: " + FSA);
        }
        return record;
    }

    private class CAN_UDPostInfoDataAccessHelper
    implements IDataAccessHelper {
        private CAN_UDPostInfoDataAccessHelper() {
        }

        public MMJDataFileMetadata getMetadataType() {
            return new MMJComplexDataFileMetadata();
        }

        public IDataFileDataItem getDataItemType() {
            return new PostInfoDataItem();
        }

        public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
            PostInfoRecord record = new PostInfoRecord();
            PostInfoDataItem dataItem = (PostInfoDataItem)item;
            if (dataItem.hasString(2)) {
                record.setAreaName1(GenericDataItemAccessor.getDataString((int)2, (GenericDataItem)dataItem));
            }
            if (!dataItem.hasByte(62)) {
                return null;
            }
            record.setAreaName1(AddressUtils.getProvinceForCode(GenericDataItemAccessor.getDataByte((int)62, (GenericDataItem)dataItem)));
            if (dataItem.hasString(4)) {
                record.setAreaName3(GenericDataItemAccessor.getDataString((int)4, (GenericDataItem)dataItem));
            } else if (dataItem.hasByte(61)) {
                record.setAreaName3(((MMJComplexDataFileMetadata)CAN_UDPostInfoFetcher.this.getMetaData()).getFrequentStrings().getFrequentString(0, FrequentDataFileStrings.convertByteToIndex((byte)GenericDataItemAccessor.getDataByte((int)61, (GenericDataItem)dataItem))));
            } else {
                return null;
            }
            return record;
        }
    }
}

