/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary;

import com.mapinfo.mapmarker.CAN.dp.binary.MMJAlternateItem;
import com.mapinfo.mapmarker.CAN.dp.binary.MunicipalityRecordDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class MMJMunicipalityRecord
extends MunicipalityRecordDataItem {
    public MMJMunicipalityRecord(String province, String municipality, String withAccents) {
        super(province, municipality, withAccents);
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException {
        int count;
        int mask = this.getMunicipalityWithAccents() != null ? 128 : 0;
        out.writeByte(mask += this.getAlternates() != null ? this.getAlternates().size() : 0);
        out.writeUTF(this.getProvince());
        out.writeUTF(this.getMunicipality());
        if ((mask & 0x80) != 0) {
            out.writeUTF(this.getMunicipalityWithAccents());
        }
        if ((count = mask & 0x7F) > 0) {
            Iterator iterator = this.getAlternates().iterator();
            for (int i = 0; i < (mask & 0x7F); ++i) {
                ((MMJAlternateItem)iterator.next()).write(out, metadata);
            }
        }
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return (this.getProvince() + this.getMunicipality()).hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof MMJMunicipalityRecord) {
            MMJMunicipalityRecord thatRecord = (MMJMunicipalityRecord)that;
            return this.equalStrings(this.getProvince(), thatRecord.getProvince()) && this.equalStrings(this.getMunicipality(), thatRecord.getMunicipality()) && this.equalStrings(this.getMunicipalityWithAccents(), thatRecord.getMunicipalityWithAccents());
        }
        throw new IllegalArgumentException("Wrong class.");
    }

    private boolean equalStrings(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }
}

