/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary.index;

import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;

public class CAN_GeoInfoSoundexIndexer
extends GeoInfoSoundexIndexer {
    public CAN_GeoInfoSoundexIndexer() {
        this.sndx = new CAN_EnglishSoundex();
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        ArrayList<CAN_GeoSoundexKey> list = new ArrayList<CAN_GeoSoundexKey>();
        if (item == null) {
            return list;
        }
        int precision = -1;
        String prov = null;
        String city = null;
        String altCity = null;
        StringWithTokens altCityTokens = null;
        try {
            if (item.hasByte(0)) {
                precision = GenericDataItemAccessor.getDataByte((int)0, (GenericDataItem)item);
            }
            if (precision != 0) {
                if (item.hasByte(1)) {
                    prov = metadata.getFrequentStrings().getFrequentString(0, (int)GenericDataItemAccessor.getDataByte((int)1, (GenericDataItem)item));
                } else if (item.hasString(0)) {
                    prov = item.getString(0);
                }
                if (item.hasString(2)) {
                    city = item.getString(2);
                }
                if (item.hasString(6)) {
                    altCity = item.getString(6);
                    altCityTokens = new StringWithTokens(altCity, ";");
                }
                if (prov != null && city != null) {
                    CAN_GeoSoundexKey key = new CAN_GeoSoundexKey(prov, (MiSoundexKey)this.sndx.getSoundex(city));
                    if (!list.contains(key)) {
                        list.add(key);
                    }
                    if (altCity != null) {
                        for (int i = 0; i < altCityTokens.size(); ++i) {
                            key = new CAN_GeoSoundexKey(prov, (MiSoundexKey)this.sndx.getSoundex(altCityTokens.getToken(i)));
                            if (list.contains(key)) continue;
                            list.add(key);
                        }
                    }
                } else if (prov != null) {
                    MiSoundexKey dummyKey = new MiSoundexKey();
                    dummyKey.setFirstChar('\u0000');
                    dummyKey.setNumericValue(0);
                    CAN_GeoSoundexKey provKey = new CAN_GeoSoundexKey(prov, dummyKey);
                    if (!list.contains(provKey)) {
                        list.add(provKey);
                    }
                }
            }
        }
        catch (LocalizationException ex) {
            throw new DataCreationException((Throwable)ex);
        }
        catch (MMJETypeArraySizeExceededException ex) {
            throw new DataCreationException((Throwable)ex);
        }
        return list;
    }
}

