/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.binary.index;

import com.mapinfo.mapmarker.CAN.dp.binary.index.CAN_PBKeyIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StreetDataIndexValue;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CAN_PBKeyIndexFileCombiner {
    public static final String PBKEY_COMBINED_TEMP_INDEX = "can.tdx";
    private String m_outputPath;
    private String[] m_tempIndexes;
    private Map<MiStringIndexKey, CAN_PBKeyIndexValue> m_entries;

    public CAN_PBKeyIndexFileCombiner(String outputPath, String[] tempIndexes) {
        this.m_outputPath = outputPath;
        this.m_tempIndexes = tempIndexes;
    }

    private void combine() {
        this.m_entries = new HashMap<MiStringIndexKey, CAN_PBKeyIndexValue>();
        NIOOutputStream output = null;
        try {
            output = this.makeOutputFile();
            for (int i = 0; i < this.m_tempIndexes.length; ++i) {
                this.process(this.m_tempIndexes[i]);
            }
            this.writeCombinedIndex(output);
        }
        catch (IOException IOEx) {
            System.err.println("Error processing.");
            IOEx.printStackTrace(System.err);
            System.exit(-1);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeCombinedIndex(NIOOutputStream out) throws IOException {
        for (Map.Entry<MiStringIndexKey, CAN_PBKeyIndexValue> e : this.m_entries.entrySet()) {
            e.getKey().write((DataOutput)out);
            e.getValue().write((DataOutput)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String tempIndex) throws IOException {
        DataInputStream input = null;
        System.out.println("processing: " + tempIndex);
        File tempIndexFile = new File(tempIndex);
        String baseName = CAN_PBKeyIndexFileCombiner.stripExtension(tempIndexFile.getName());
        try {
            try {
                input = this.openTempIndex(tempIndex);
                while (true) {
                    MiStringIndexKey key = new MiStringIndexKey();
                    StreetDataIndexValue value = new StreetDataIndexValue(-1L);
                    key.read((DataInput)input);
                    value.read((DataInput)input);
                    CAN_PBKeyIndexValue v = this.m_entries.get(key);
                    if (v == null) {
                        v = new CAN_PBKeyIndexValue(baseName, (int)value.getStreetOffset());
                        this.m_entries.put(key, v);
                        continue;
                    }
                    v.addOffset(value.getStreetOffset());
                }
            }
            catch (EOFException EOFEx) {
                System.out.println("finished processing: " + tempIndex);
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                input.close();
            }
            throw throwable;
        }
    }

    private NIOOutputStream makeOutputFile() throws IOException {
        return new NIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)PBKEY_COMBINED_TEMP_INDEX)));
    }

    private static String stripExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    private DataInputStream openTempIndex(String tempIndex) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(new File(tempIndex))));
    }

    private static void usage() {
        System.out.println("CAN_PBKeyIndexFileCombiner <output path> <input index files>N");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("arg #" + i + ":\t" + args[i]);
            }
            CAN_PBKeyIndexFileCombiner.usage();
            System.exit(-1);
        }
        String[] tempIndexes = new String[args.length - 1];
        System.arraycopy(args, 1, tempIndexes, 0, tempIndexes.length);
        CAN_PBKeyIndexFileCombiner combiner = new CAN_PBKeyIndexFileCombiner(args[0], tempIndexes);
        combiner.combine();
        System.out.println("finished creating combined temporary index");
    }
}

