/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IUniqueIDElement;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.ReferenceValue;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.UniqueIDIndexKey;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.ParitySequenceDivider;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractMergeRecorder
implements IMergeRecorder {
    protected abstract Collection<ReferenceValue> getPreviousEntries(IUniqueIDElement var1);

    protected abstract ICombinedRecord makeSubRecord(ICombinedRecord var1, IStreetElements var2);

    protected abstract IStreetElements makeStreetElement(IStreetElements var1, int var2, int var3, int var4);

    protected abstract void put(UniqueIDIndexKey var1, ReferenceValue var2);

    @Override
    public void record(int from, int to, byte oddEven, ICombinedRecord record) {
        this.put(new UniqueIDIndexKey(record.getUniqueIDElement().getUniqueID()), new ReferenceValue(from, to, oddEven));
    }

    @Override
    public Collection<ICombinedRecord> getAvailable(ICombinedRecord record) {
        Collection<ReferenceValue> previousEntries = this.getPreviousEntries(record.getUniqueIDElement());
        if (previousEntries == null) {
            LinkedList<ICombinedRecord> returns = new LinkedList<ICombinedRecord>();
            returns.add(record);
            return returns;
        }
        int recordOddEven = this.getOddEven(record.getStreetElements());
        ParitySequenceDivider divider = new ParitySequenceDivider(Integer.parseInt(record.getStreetElements().getStreetAddressFromNumber()), Integer.parseInt(record.getStreetElements().getStreetAddressToNumber()), recordOddEven);
        for (ReferenceValue value : previousEntries) {
            divider.removeRange(value.getStart(), value.getEnd(), value.getOddEven());
        }
        Collection<ParitySequenceDivider.IntegerSegment> leftOvers = divider.getRemainingRanges();
        if (leftOvers != null && leftOvers.size() > 0) {
            LinkedList<ICombinedRecord> returns = new LinkedList<ICombinedRecord>();
            for (ParitySequenceDivider.IntegerSegment segment : leftOvers) {
                returns.add(this.makeSubRecord(record, this.makeStreetElement(record.getStreetElements(), segment.getStart(), segment.getEnd(), segment.getOddEvenBoth())));
            }
            return returns;
        }
        return null;
    }

    private int getOddEven(IStreetElements elements) {
        switch (elements.getStreetAddressSequenceCode()) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
        }
        return 0;
    }
}

