/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.merge.AbstractInputRecordMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.RangeMergeOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CANPostNameInputRecordMerger
extends AbstractInputRecordMerger {
    private IRangeMergeHandler m_merger;
    private StreetComparator m_streetComparator;

    public CANPostNameInputRecordMerger(String province, IMergeSource mergeSource, IRangeMergeHandler merger, IPostalRecordFilter filter) {
        super(province, mergeSource, filter);
        this.m_merger = merger;
        this.m_streetComparator = new StreetComparator();
    }

    @Override
    protected boolean processSegment(String streetName, String FSA, int SAC, Collection mergedRecords, Collection unMergedRecords, Collection noMatchRecords, Collection postalRecords, SegmentDataSourceRecord segment, Iterator rangeIterator) {
        LinkedList<StreetDataSourceRecord> localMerges = new LinkedList<StreetDataSourceRecord>();
        LinkedList<RangeDataSourceRecord> unMergedRanges = new LinkedList<RangeDataSourceRecord>();
        boolean bLocalMerges = false;
        while (rangeIterator.hasNext()) {
            RangeDataSourceRecord range = (RangeDataSourceRecord)rangeIterator.next();
            Collection<RangeMergeHandler.Overlap> valids = this.m_merger.getValidPostalData(range, postalRecords);
            if (valids != null) {
                Collection subSet = this.getFilter().filter(valids, segment, range.isLeft());
                if (subSet == null) {
                    subSet = this.getFilter().filter(valids, segment, !range.isLeft());
                }
                if (subSet == null) {
                    MergeLogger.getLogger().logNoFilteredRecords(SourceRecordDataIDProvider.getProvider().getCurrentID());
                    unMergedRanges.add(range);
                    continue;
                }
                RangeMergeOutput output = this.m_merger.makeOutput(streetName, range, subSet, segment);
                if (output != null) {
                    bLocalMerges = true;
                    SegmentDataSourceRecord temp = new SegmentDataSourceRecord(segment);
                    Iterator outputIterator = output.getRanges().iterator();
                    while (outputIterator.hasNext()) {
                        temp.addRange((RangeDataSourceRecord)outputIterator.next());
                    }
                    localMerges.add(new StreetDataSourceRecord(output.getStreetName(), SAC, temp, output.getOriginalName(), output.getDeliveryInstallationInfo()));
                    continue;
                }
                unMergedRanges.add(range);
                continue;
            }
            unMergedRanges.add(range);
        }
        if (bLocalMerges) {
            Collection subMerges = this.combineLocalMerges(localMerges);
            if (!unMergedRanges.isEmpty() && !this.combineUnMergedRangesWithMerged(subMerges, streetName, unMergedRanges)) {
                Iterator unMergedIterator = unMergedRanges.iterator();
                while (unMergedIterator.hasNext()) {
                    segment.addRange((RangeDataSourceRecord)unMergedIterator.next());
                }
                noMatchRecords.add(new StreetDataSourceRecord(streetName, SAC, segment));
            }
            mergedRecords.addAll(subMerges);
        } else {
            Iterator unMergedIterator = unMergedRanges.iterator();
            while (unMergedIterator.hasNext()) {
                segment.addRange((RangeDataSourceRecord)unMergedIterator.next());
            }
            unMergedRecords.add(new StreetDataSourceRecord(streetName, SAC, segment));
        }
        return bLocalMerges;
    }

    private Collection combineLocalMerges(List localMerges) {
        if (localMerges.size() == 1) {
            return localMerges;
        }
        LinkedList<StreetDataSourceRecord> combinedMerges = new LinkedList<StreetDataSourceRecord>();
        Collections.sort(localMerges, this.m_streetComparator);
        StreetDataSourceRecord currentStreet = null;
        for (StreetDataSourceRecord street : localMerges) {
            if (currentStreet == null) {
                currentStreet = street;
                continue;
            }
            if (currentStreet.getMainAddress().equals(street.getMainAddress())) {
                Iterator ranges = ((SegmentDataSourceRecord)street.getSegment()).getRanges().iterator();
                while (ranges.hasNext()) {
                    ((SegmentDataSourceRecord)currentStreet.getSegment()).addRange((RangeDataSourceRecord)ranges.next());
                }
                continue;
            }
            combinedMerges.add(currentStreet);
            currentStreet = street;
        }
        combinedMerges.add(currentStreet);
        return combinedMerges;
    }

    private boolean combineUnMergedRangesWithMerged(Collection mergedRecords, String streetName, Collection unMergedRanges) {
        StreetDataSourceRecord match = this.findMatch(mergedRecords, streetName);
        if (match != null) {
            SegmentDataSourceRecord segment = (SegmentDataSourceRecord)match.getSegment();
            Iterator iterator = unMergedRanges.iterator();
            while (iterator.hasNext()) {
                segment.addRange((RangeDataSourceRecord)iterator.next());
            }
            return true;
        }
        return false;
    }

    private StreetDataSourceRecord findMatch(Collection mergedRecords, String streetName) {
        for (StreetDataSourceRecord street : mergedRecords) {
            if (MergeUtilities.score(streetName, street.getMainAddress()) != 1.0) continue;
            return street;
        }
        return null;
    }

    private class StreetComparator
    implements Comparator {
        private StreetComparator() {
        }

        public int compare(Object o1, Object o2) {
            StreetDataSourceRecord street1 = (StreetDataSourceRecord)o1;
            StreetDataSourceRecord street2 = (StreetDataSourceRecord)o2;
            return street1.getMainAddress().compareTo(street2.getMainAddress());
        }
    }
}

