/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.merge.AbstractInputRecordMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import java.util.Collection;
import java.util.Iterator;

public class InputRecordMerger
extends AbstractInputRecordMerger {
    private IRangeMerger m_rangeMerger;

    public InputRecordMerger(String province, IMergeSource mergeSource, IRangeMerger rangeMerger, IPostalRecordFilter filter) {
        super(province, mergeSource, filter);
        this.m_rangeMerger = rangeMerger;
    }

    @Override
    protected boolean processSegment(String streetName, String FSA, int SAC, Collection mergedRecords, Collection unMergedRecords, Collection noMatchRecords, Collection postalRecords, SegmentDataSourceRecord segment, Iterator rangeIterator) {
        boolean bLocalMerges = false;
        while (rangeIterator.hasNext()) {
            RangeDataSourceRecord range = (RangeDataSourceRecord)rangeIterator.next();
            Collection subSet = this.getFilter().filter(postalRecords, segment, range.isLeft());
            if (subSet != null) {
                Collection rangeMerges = this.m_rangeMerger.merge(range, subSet);
                if (rangeMerges == null) {
                    segment.addRange(range);
                    continue;
                }
                bLocalMerges = true;
                Iterator mergeIterator = rangeMerges.iterator();
                while (mergeIterator.hasNext()) {
                    segment.addRange((RangeDataSourceRecord)mergeIterator.next());
                }
                continue;
            }
            segment.addRange(range);
        }
        if (bLocalMerges) {
            mergedRecords.add(new StreetDataSourceRecord(streetName, SAC, segment));
        } else {
            unMergedRecords.add(new StreetDataSourceRecord(streetName, SAC, segment));
        }
        return bLocalMerges;
    }
}

