/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.IMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import java.util.Collection;

public class MergeHandler {
    private IDataSource m_dataSource;
    private IMerger m_merger;
    private IMergeOutputer m_mergeOutputer;

    public MergeHandler(IDataSource dataSource, IMerger merger, IMergeOutputer mergeOutputer) {
        this.m_dataSource = dataSource;
        this.m_merger = merger;
        this.m_mergeOutputer = mergeOutputer;
    }

    public void merge() throws DataSourceException {
        IDataSourceRecordObjects objects;
        while ((objects = this.m_dataSource.getNextDataSourceRecordObjects()) != null) {
            SourceRecordDataIDProvider.getProvider().setCurrentID(null);
            Collection outputs = this.m_merger.merge(objects);
            if (outputs == null) continue;
            this.m_mergeOutputer.output(outputs);
        }
        DataCreationLogger.getLogger().logStatus("Finished merging.");
    }
}

