/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.merge.IMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.Merger;
import com.mapinfo.mapmarker.CAN.dp.merge.text.OutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetNameReplacementProvider;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.MergeSource;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class MergeProcessor {
    private IDataSource m_source;
    private MergeSource m_mergeSource;
    private IMerger m_merger;
    private MergeRecorder m_recorder;
    private MergeOutputer m_outputer;

    private MergeProcessor(Properties properties, String province, String tabPath, String CANPostPath, String outputPath, String streetReplacementFile) throws DataSourceException, IOException, IndexAccessException {
        MergeLogger.getLogger().setUp(outputPath, province);
        this.m_source = new TabFileDataSource(properties);
        String[] tabArgs = new String[]{tabPath, properties.getProperty("startRow"), properties.getProperty("endRow")};
        this.m_source.open(tabArgs);
        this.m_mergeSource = new MergeSource();
        this.m_mergeSource.open(CANPostPath, province);
        this.m_recorder = new MergeRecorder();
        this.m_recorder.open(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"idx"));
        this.m_merger = new Merger(province, new OutputSegmentBuilder(province), new StreetNameReplacementProvider(streetReplacementFile), this.m_mergeSource, new RangeMerger(this.m_recorder));
        this.m_outputer = new MergeOutputer();
        this.m_outputer.open(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"tdr"));
    }

    private static void setUpLoggers(String outputPath, String province) {
        String base = StringUtilities.appendToPath((String)outputPath, (String)province, null);
        DataCreationLogger.getLogger().setStatusLog(base + ".log", false);
        DataCreationLogger.getLogger().setErrorLog(base + ".err", false);
        DataCreationLogger.getLogger().setInternalErrorLog(base + ".irr", false);
    }

    private static Properties loadProperties(String propertyFile) {
        FileInputStream propertiesFileInputStream = null;
        Properties props = new Properties();
        try {
            propertiesFileInputStream = new FileInputStream(propertyFile);
        }
        catch (FileNotFoundException FNFEx) {
            System.err.println("Unable to find properties file: " + propertyFile);
            System.err.println(FNFEx.getMessage());
            System.exit(1);
        }
        try {
            props.load(propertiesFileInputStream);
        }
        catch (IOException IOEx) {
            System.err.println("Unable to load properties from properties file: " + propertyFile);
            System.err.println(IOEx.getMessage());
            System.exit(1);
        }
        try {
            propertiesFileInputStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("IOException occurred on closing properties file. ");
            System.err.println(IOEx.getMessage());
        }
        return props;
    }

    private void process() throws DataSourceException {
        MergeHandler handler = new MergeHandler(this.m_source, this.m_merger, this.m_outputer);
        try {
            handler.merge();
        }
        finally {
            MergeLogger.getLogger().close();
            try {
                this.m_recorder.close();
            }
            catch (IOException iOException) {}
            try {
                this.m_outputer.close();
            }
            catch (IOException iOException) {}
            try {
                this.m_source.close();
            }
            catch (DataSourceException dataSourceException) {}
            try {
                this.m_mergeSource.close();
            }
            catch (DataSourceException dataSourceException) {}
        }
    }

    public static void main(String[] args) {
        String province = args[0];
        String propertyFile = args[1];
        String inputTabFile = args[2];
        String CANPostPath = args[3];
        String outputPath = args[4];
        String replacementFile = args.length == 6 ? args[5] : null;
        MergeProcessor.setUpLoggers(outputPath, province);
        if (replacementFile == null) {
            DataCreationLogger.getLogger().logStatus("No replacement street file given.");
        }
        try {
            MergeProcessor processor = new MergeProcessor(MergeProcessor.loadProperties(propertyFile), province, inputTabFile, CANPostPath, outputPath, replacementFile);
            processor.process();
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
        }
        catch (Throwable T) {
            DataCreationLogger.getLogger().logStackTrace(T);
            System.exit(1);
        }
        System.exit(0);
    }
}

