/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IBuildingElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IGovernmentElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ILVRElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ISuiteElements;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;

public class OutputRangeBuilder {
    private static final boolean m_bEmptyRangeUnitRangeLDUs = false;
    private AccentsLookup m_accents;

    public OutputRangeBuilder(AccentsLookup accents) {
        this.m_accents = accents;
    }

    public RangeDataSourceRecord buildRange(boolean bLeft, ParsedNumber from, ParsedNumber to, int oddEven, ICombinedRecord record) {
        UnitDataSourceRecord unit = this.buildUnit(record);
        return new RangeDataSourceRecord(from.getCombinedAddressNumber(), to.getCombinedAddressNumber(), this.convertStatus(oddEven), bLeft, unit == null ? this.getLDU(record.getStandardElements()) : null, null, unit == null ? this.getPlaceName(record) : null, record.getStandardElements().getProvinceCode(), this.getMunicipalityName(record.getStandardElements()), unit, record.getRouteServiceElements());
    }

    private UnitDataSourceRecord buildUnit(ICombinedRecord record) {
        ISuiteElements suite = record.getSuiteElements();
        if (suite == null) {
            return null;
        }
        String lowUnit = suite.getSuiteFromNumber();
        String highUnit = suite.getSuiteToNumber();
        if (lowUnit != null && highUnit != null) {
            ParsedNumber low = new ParsedNumber(lowUnit);
            ParsedNumber high = new ParsedNumber(highUnit);
            if (!this.areCompatibleNumbers(low, high)) {
                if (low.getNumFields() == high.getNumFields()) {
                    DataCreationLogger.getLogger().logInternalError("Unit values have same number of fields, but they are not the same fields, SKIPPING...  Low: " + lowUnit + "\thigh: " + highUnit);
                    return null;
                }
                if (Math.abs(low.getNumFields() - high.getNumFields()) > 1) {
                    DataCreationLogger.getLogger().logInternalError("Unit values to dissimilar, SKIPPING...  Low: " + lowUnit + "\thigh: " + highUnit);
                    return null;
                }
                Unit u = new Unit(lowUnit, highUnit);
                this.fixUnit(u, low, high);
                low = new ParsedNumber(u.getLowUnit());
                high = new ParsedNumber(u.getHighUnit());
                if (!this.areCompatibleNumbers(low, high)) {
                    DataCreationLogger.getLogger().logInternalError("Attempted to fix but failed\tlow: " + u.getLowUnit() + "\thigh: " + u.getHighUnit() + "\tSKIPPING...");
                    return null;
                }
                return new UnitDataSourceRecord(u.getLowUnit(), u.getHighUnit(), this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
            }
            return new UnitDataSourceRecord(lowUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        if (highUnit != null) {
            return new UnitDataSourceRecord(highUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        if (lowUnit != null) {
            return new UnitDataSourceRecord(lowUnit, lowUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        return null;
    }

    private String convertStatus(int oddEvenBoth) {
        switch (oddEvenBoth) {
            case 1: {
                return "1";
            }
            case 2: {
                return "0";
            }
        }
        return "2";
    }

    private String getMunicipalityName(IStandardElements elements) {
        if (elements.getMunicipalityNameAccentIndicator()) {
            return this.m_accents.get(elements.getMunicipalityName());
        }
        return elements.getMunicipalityName();
    }

    private String getPlaceName(ICombinedRecord record) {
        IBuildingElements building = record.getBuildingElements();
        if (building != null && building.getBuildingName() != null) {
            return building.getBuildingName();
        }
        ILVRElements LVR = record.getLVRElements();
        if (LVR != null && LVR.getLVRName() != null) {
            return LVR.getLVRName();
        }
        IGovernmentElements government = record.getGovernmentElements();
        if (government != null && government.getDepartmentName() != null) {
            return government.getDepartmentName();
        }
        return null;
    }

    private String getLDU(IStandardElements elements) {
        return elements.getPostalCode().substring(3);
    }

    private boolean areCompatibleNumbers(ParsedNumber number1, ParsedNumber number2) {
        if (number1.isPureNumeric() && number2.isPureNumeric()) {
            return true;
        }
        if (number1.getNumFields() != number2.getNumFields()) {
            return false;
        }
        if (number1.hasAddressPrefix() != number2.hasAddressPrefix()) {
            return false;
        }
        if (number1.hasAddressSuffix() != number2.hasAddressSuffix()) {
            return false;
        }
        if (number1.hasAddressTrailer() != number2.hasAddressTrailer()) {
            return false;
        }
        if (number1.hasNumberSeparator() != number2.hasNumberSeparator()) {
            return false;
        }
        if (number1.hasPrefixSeparator() != number2.hasPrefixSeparator()) {
            return false;
        }
        if (number1.hasSeparator() != number2.hasSeparator()) {
            return false;
        }
        if (number1.hasSuffixSeparator() != number2.hasSuffixSeparator()) {
            return false;
        }
        if (number1.hasTrailerSeparator() != number2.hasTrailerSeparator()) {
            return false;
        }
        if (number1.getAddressNumberExists() != number2.getAddressNumberExists()) {
            return false;
        }
        if (number1.getSuffixNumberExists() != number2.getSuffixNumberExists()) {
            return false;
        }
        if (number1.isHyphenatedNumber() != number2.isHyphenatedNumber()) {
            return false;
        }
        int diffs = 0;
        if (number1.getAddressNumber() != number2.getAddressNumber()) {
            ++diffs;
        }
        if (!number1.getAddressPrefix().equals(number2.getAddressPrefix())) {
            ++diffs;
        }
        if (!number1.getAddressSuffix().equals(number2.getAddressSuffix())) {
            ++diffs;
        }
        if (!number1.getAddressTrailer().equals(number2.getAddressTrailer())) {
            ++diffs;
        }
        if (number1.getSuffixNumber() != number2.getSuffixNumber()) {
            ++diffs;
        }
        if (!number1.getNumberSeparator().equals(number2.getNumberSeparator())) {
            ++diffs;
        }
        if (!number1.getPrefixSeparator().equals(number2.getPrefixSeparator())) {
            ++diffs;
        }
        if (!number1.getSuffixSeparator().equals(number2.getSuffixSeparator())) {
            ++diffs;
        }
        if (!number1.getTrailerSeparator().equals(number2.getTrailerSeparator())) {
            ++diffs;
        }
        return diffs < 2;
    }

    private void fixUnit(Unit unit, ParsedNumber low, ParsedNumber high) {
        if (low.getNumFields() < high.getNumFields()) {
            if (high.hasAddressPrefix() && !low.hasAddressPrefix()) {
                unit.setLowUnit(high.getAddressPrefix() + unit.getLowUnit());
                return;
            }
            if (high.hasAddressSuffix() && !low.hasAddressSuffix()) {
                unit.setLowUnit(unit.getLowUnit() + high.getAddressSuffix());
            }
        } else {
            if (low.hasAddressPrefix() && !high.hasAddressPrefix()) {
                unit.setHighUnit(low.getAddressPrefix() + unit.getHighUnit());
                return;
            }
            if (low.hasAddressSuffix() && !high.hasAddressSuffix()) {
                unit.setHighUnit(unit.getHighUnit() + low.getAddressSuffix());
            }
        }
    }

    private static class InvalidUnitException
    extends Exception {
        private InvalidUnitException() {
        }
    }

    private static class Unit {
        private String m_lowUnit;
        private String m_highUnit;

        public Unit(String lowUnit, String highUnit) {
            this.m_lowUnit = lowUnit;
            this.m_highUnit = highUnit;
        }

        public void setLowUnit(String lowUnit) {
            this.m_lowUnit = lowUnit;
        }

        public String getLowUnit() {
            return this.m_lowUnit;
        }

        public void setHighUnit(String highUnit) {
            this.m_highUnit = highUnit;
        }

        public String getHighUnit() {
            return this.m_highUnit;
        }
    }
}

