/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.ICAN_StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IStreetNameReplacementProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetReplacementRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class StreetNameGenerator {
    private static final boolean m_bMainAddressAddedAsAlt = true;
    private static final Set<String> m_frenchTypes = new HashSet<String>();
    private static final Set<String> m_preTypesForNumberedRoads;
    private IStreetNameReplacementProvider m_streetNameReplacer;
    private boolean m_bIsQC;
    private boolean m_bFixPossibleFrenchNames;

    public StreetNameGenerator(IStreetNameReplacementProvider streetNameReplacer, boolean bIsQC) {
        this(streetNameReplacer, bIsQC, true);
    }

    public StreetNameGenerator(IStreetNameReplacementProvider streetNameReplacer, boolean bIsQC, boolean bFixPossibleFrenchNames) {
        this.m_streetNameReplacer = streetNameReplacer;
        this.m_bIsQC = bIsQC;
        this.m_bFixPossibleFrenchNames = bFixPossibleFrenchNames;
    }

    public Collection<String> generateStreetNames(IStreetDataSourceRecord street, String FSA) throws DataSourceException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (street.hasMainAddress() && this.stringExists(street.getMainAddress())) {
            String mainAddress = street.getMainAddress().trim();
            Collection replacements = this.m_streetNameReplacer.getReplacementStreets(mainAddress, FSA);
            if (replacements == null) {
                this.addAltName(mainAddress, names);
            } else {
                Iterator iterator = replacements.iterator();
                LinkedList<String> additions = new LinkedList<String>();
                boolean bReplaceAll = true;
                while (iterator.hasNext()) {
                    StreetReplacementRecord record = (StreetReplacementRecord)iterator.next();
                    additions.add(record.getStreetName());
                    DataCreationLogger.getLogger().logStatus("Added name: " + record.getStreetName() + " for: " + mainAddress + " in FSA: " + FSA);
                    if (!record.isAdditional()) continue;
                    bReplaceAll = false;
                }
                if (!bReplaceAll) {
                    this.addAltName(mainAddress, names);
                } else {
                    DataCreationLogger.getLogger().logStatus("All the replacements records were repace records, original mainAddress not added");
                }
                names.addAll(additions);
            }
        }
        if (street.hasAlternateMainAddress() && this.stringExists(street.getAlternateMainAddress())) {
            this.addAltName(street.getAlternateMainAddress(), names);
        }
        if (street instanceof ICAN_StreetDataSourceRecord) {
            ICAN_StreetDataSourceRecord canStreet = (ICAN_StreetDataSourceRecord)street;
            if (canStreet.hasAdditionalAlternate1() && this.stringExists(canStreet.getAdditionalAlternate1())) {
                this.addAltName(canStreet.getAdditionalAlternate1(), names);
            }
            if (canStreet.hasAdditionalAlternate2() && this.stringExists(canStreet.getAdditionalAlternate2())) {
                this.addAltName(canStreet.getAdditionalAlternate2(), names);
            }
            if (canStreet.hasAdditionalAlternate3() && this.stringExists(canStreet.getAdditionalAlternate3())) {
                this.addAltName(canStreet.getAdditionalAlternate3(), names);
            }
            if (canStreet.hasAdditionalAlternate4() && this.stringExists(canStreet.getAdditionalAlternate4())) {
                this.addAltName(canStreet.getAdditionalAlternate4(), names);
            }
        }
        if (names.isEmpty()) {
            return null;
        }
        return names;
    }

    private boolean isFrenchType(String type) {
        return m_frenchTypes.contains(type);
    }

    private boolean isPossibleFrenchType(String type, String originalName) {
        String upperOriginal = originalName.toUpperCase();
        if (!this.m_bFixPossibleFrenchNames) {
            return false;
        }
        if ("BD".equals(type) && (upperOriginal.endsWith(" BOUL") || upperOriginal.indexOf(" BOUL ") > 0)) {
            return true;
        }
        if ("ST".equals(type) && (upperOriginal.endsWith(" COTE") || upperOriginal.indexOf(" COTE ") > 0)) {
            return true;
        }
        return "AVE".equals(type) && (upperOriginal.endsWith(" AV") || upperOriginal.indexOf(" AV ") > 0);
    }

    private boolean isPreType(String type) {
        return m_preTypesForNumberedRoads.contains(type);
    }

    private CAN_ParsedAddress parseStreet(String name) {
        return MergeUtilities.parse(name);
    }

    private String fixQCStreetName(String name) {
        String testName = name;
        boolean bCont = true;
        while (bCont) {
            CAN_ParsedAddress parsed = this.parseStreet(testName);
            if (parsed == null) {
                DataCreationLogger.getLogger().logInternalError("\tUnable to parse street: " + name);
                return null;
            }
            if (parsed.getPostThoroughfareType() != null && !parsed.hasFrenchOrdinal()) {
                if (this.isFrenchType(parsed.getPostThoroughfareType()) || this.isPossibleFrenchType(parsed.getPostThoroughfareType(), name)) {
                    parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
                    parsed.setPostThoroughfareType(null);
                    String fixedName = MergeUtilities.makePostParseString((Address)parsed);
                    DataCreationLogger.getLogger().logInternalError("Replacing name: " + name + " with: " + fixedName);
                    return fixedName;
                }
                if (StringUtilities.hasNumeric((String)parsed.getMainAddress()) && this.isPreType(parsed.getPostThoroughfareType())) {
                    parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
                    parsed.setPostThoroughfareType(null);
                    String fixedName = MergeUtilities.makePostParseString((Address)parsed);
                    DataCreationLogger.getLogger().logInternalError("Replacing name: " + name + " with: " + fixedName);
                    return fixedName;
                }
                if (this.m_bIsQC && "RTE".equals(parsed.getPostThoroughfareType())) {
                    parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
                    parsed.setPostThoroughfareType(null);
                    String fixedName = MergeUtilities.makePostParseString((Address)parsed);
                    DataCreationLogger.getLogger().logInternalError("Replacing name: " + name + " with: " + fixedName);
                    return fixedName;
                }
                bCont = false;
                continue;
            }
            if (parsed.getPostThoroughfareType() == null && parsed.getPreThoroughfareType() == null) {
                testName = this.handleUnTypedStreets(name);
                if (testName != null) continue;
                bCont = false;
                continue;
            }
            bCont = false;
        }
        return name;
    }

    private void addAltName(String name, Collection<String> names) {
        String fixedName;
        String temp;
        if (name != null && (temp = name.trim()).length() > 0 && (fixedName = this.fixQCStreetName(StringUtilities.replaceWith((String)temp, (String)" - ", (String)"-"))) != null) {
            names.add(fixedName);
        }
    }

    private boolean stringExists(String str) {
        return str != null && str.trim().length() > 0;
    }

    private String handleUnTypedStreets(String streetName) {
        String upper = streetName.toUpperCase();
        if (upper.endsWith(" MONT\u00d5E") || upper.endsWith(" MONT E")) {
            StringBuffer newUpper = new StringBuffer(upper.substring(0, upper.length() - 6));
            newUpper.append("MONT\u00c9E");
            return newUpper.toString();
        }
        return null;
    }

    static {
        m_frenchTypes.add("RUE");
        m_frenchTypes.add("RANG");
        m_frenchTypes.add("CH");
        m_frenchTypes.add("COUR");
        m_frenchTypes.add("MTE");
        m_frenchTypes.add("PARC");
        m_frenchTypes.add("PTE");
        m_frenchTypes.add("TSSE");
        m_frenchTypes.add("IMP");
        m_preTypesForNumberedRoads = new HashSet<String>();
        m_preTypesForNumberedRoads.add("RTE");
        m_preTypesForNumberedRoads.add("HWY");
        m_preTypesForNumberedRoads.add("AUT");
        m_preTypesForNumberedRoads.add("FWY");
    }
}

