/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IMunicipalityCrossReferenceRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.MunicipalityLookup;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class StrictPostalRecordFilter
implements IPostalRecordFilter {
    private String m_province;
    private AccentsLookup m_accentLookup;
    private MunicipalityLookup m_municipalityLookup;
    private final boolean m_bAllowReverseAlternates = true;
    private boolean m_bUseCSDName;

    public StrictPostalRecordFilter(String province, AccentsLookup accentLookup, MunicipalityLookup municipalityLookup) {
        this.m_province = province;
        this.m_accentLookup = accentLookup;
        this.m_municipalityLookup = municipalityLookup;
        this.m_bUseCSDName = "QC".equals(this.m_province);
    }

    @Override
    public Collection filter(Collection postalRecords, SegmentDataSourceRecord segment, boolean bLeft) {
        return this.filter(postalRecords, segment, bLeft, true);
    }

    @Override
    public Collection filterNoAlternates(Collection postalRecords, SegmentDataSourceRecord segment, boolean bLeft) {
        return this.filter(postalRecords, segment, bLeft, false);
    }

    private Collection filter(Collection postalRecords, SegmentDataSourceRecord segment, boolean bLeft, boolean bAllowAlternates) {
        String city = null;
        String realCity = null;
        if (this.m_bUseCSDName) {
            String string = city = bLeft ? segment.getLeftAreaName2() : segment.getRightAreaName2();
            if (city != null) {
                String string2 = realCity = bLeft ? segment.getLeftAreaName3() : segment.getRightAreaName3();
            }
        }
        if (!this.m_bUseCSDName || city == null) {
            String string = city = bLeft ? segment.getLeftAreaName3() : segment.getRightAreaName3();
        }
        if (city == null) {
            return null;
        }
        String FSA = bLeft ? segment.getLeftPostCode1() : segment.getRightPostCode1();
        Collection passes = this.filter(postalRecords, city, FSA, bAllowAlternates);
        if (!postalRecords.isEmpty() && realCity != null) {
            passes.addAll(this.filter(postalRecords, realCity, FSA, bAllowAlternates));
        }
        if (passes.isEmpty()) {
            return null;
        }
        return passes;
    }

    private Collection filter(Collection postalRecords, String city, String FSA, boolean bAllowAlternates) {
        LinkedList passes = new LinkedList();
        Iterator iterator = postalRecords.iterator();
        block0: while (iterator.hasNext()) {
            boolean bPasses = false;
            Object next = iterator.next();
            ICombinedRecord record = next instanceof RangeMergeHandler.Overlap ? ((RangeMergeHandler.Overlap)next).getRecord() : (ICombinedRecord)next;
            if (MergeUtilities.scoreCity(city, record.getStandardElements().getMunicipalityName()) == 1.0) {
                passes.add(next);
                iterator.remove();
                bPasses = true;
            } else if (record.getStandardElements().getMunicipalityNameAccentIndicator() && MergeUtilities.scoreCity(city, this.m_accentLookup.get(record.getStandardElements().getMunicipalityName())) == 1.0) {
                passes.add(next);
                iterator.remove();
                bPasses = true;
            }
            if (bPasses || !bAllowAlternates) continue;
            Collection alternates = this.m_municipalityLookup.getAlternates(record.getStandardElements());
            if (alternates != null) {
                for (IMunicipalityCrossReferenceRecord muniRecord : alternates) {
                    if (muniRecord.getFSA() != null && !muniRecord.getFSA().equals(FSA) || MergeUtilities.scoreCity(city, muniRecord.getAlternateMunicipalityName()) != 1.0) continue;
                    passes.add(next);
                    iterator.remove();
                    bPasses = true;
                    break;
                }
            }
            if (bPasses || (alternates = this.m_municipalityLookup.getAlternates(this.m_province, city)) == null) continue;
            for (IMunicipalityCrossReferenceRecord muniRecord : alternates) {
                if (muniRecord.getFSA() != null && !muniRecord.getFSA().equals(FSA) || MergeUtilities.scoreCity(record.getStandardElements().getMunicipalityName(), muniRecord.getAlternateMunicipalityName()) != 1.0) continue;
                passes.add(next);
                iterator.remove();
                continue block0;
            }
        }
        return passes;
    }
}

