/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.close;

import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.RangeMergeOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.close.CloseMatchOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CloseMatchMerger {
    private String m_province;
    private ICloseMatchMergeSource m_source;
    private IRangeMergeHandler m_mergeHandler;
    private IPostalRecordFilter m_filter;
    private StreetComparator m_streetComparator;

    public CloseMatchMerger(String province, ICloseMatchMergeSource source, IRangeMergeHandler mergeHandler, IPostalRecordFilter filter) {
        this.m_province = province;
        this.m_source = source;
        this.m_mergeHandler = mergeHandler;
        this.m_filter = filter;
        this.m_streetComparator = new StreetComparator();
    }

    public ICloseMatchOutput merge(Collection names, SingleSACMergeInputRecord input) throws DataSourceException {
        LinkedList mergedRecords = new LinkedList();
        LinkedList<StreetDataSourceRecord> noMatchRecords = new LinkedList<StreetDataSourceRecord>();
        LinkedList<StreetDataSourceRecord> unMergedRecords = new LinkedList<StreetDataSourceRecord>();
        String mergedStreetName = null;
        for (SegmentDataSourceRecord segment : input.getSegments()) {
            boolean bFoundMerge = false;
            for (String streetName : names) {
                if (bFoundMerge) {
                    noMatchRecords.add(new StreetDataSourceRecord(streetName, input.getSAC(), new SegmentDataSourceRecord(segment)));
                    continue;
                }
                if (mergedStreetName != null && !mergedStreetName.equals(streetName)) {
                    noMatchRecords.add(new StreetDataSourceRecord(streetName, input.getSAC(), new SegmentDataSourceRecord(segment)));
                    continue;
                }
                Collection postalRecords = this.m_source.getMergeData(this.m_province, input.getFSA(), streetName, segment);
                if (postalRecords != null) {
                    if (!this.processSegment(streetName, input.getFSA(), input.getSAC(), mergedRecords, unMergedRecords, noMatchRecords, postalRecords, new SegmentDataSourceRecord(segment, false), segment.getRanges().iterator())) continue;
                    bFoundMerge = true;
                    mergedStreetName = streetName;
                    continue;
                }
                unMergedRecords.add(new StreetDataSourceRecord(streetName, input.getSAC(), new SegmentDataSourceRecord(segment)));
            }
        }
        if (mergedRecords.isEmpty()) {
            return null;
        }
        if (!unMergedRecords.isEmpty()) {
            noMatchRecords.addAll(unMergedRecords);
        }
        return new CloseMatchOutput(mergedRecords, noMatchRecords);
    }

    protected IPostalRecordFilter getFilter() {
        return this.m_filter;
    }

    protected boolean processSegment(String streetName, String FSA, int SAC, Collection mergedRecords, Collection unMergedRecords, Collection noMatchRecords, Collection postalRecords, SegmentDataSourceRecord segment, Iterator rangeIterator) {
        Iterator unMergedIterator;
        LinkedList<StreetDataSourceRecord> localMerges = new LinkedList<StreetDataSourceRecord>();
        LinkedList<RangeDataSourceRecord> unMergedRanges = new LinkedList<RangeDataSourceRecord>();
        boolean bLocalMerges = false;
        while (rangeIterator.hasNext()) {
            RangeDataSourceRecord range = (RangeDataSourceRecord)rangeIterator.next();
            Collection<RangeMergeHandler.Overlap> intersections = this.m_mergeHandler.getValidPostalData(range, postalRecords);
            if (intersections != null) {
                Collection valids = this.getFilter().filter(intersections, segment, range.isLeft());
                if (valids == null) {
                    valids = this.getFilter().filter(intersections, segment, !range.isLeft());
                }
                if (valids == null) {
                    unMergedRanges.add(range);
                    continue;
                }
                RangeMergeOutput output = this.m_mergeHandler.makeOutput(streetName, range, valids, segment);
                if (output != null) {
                    bLocalMerges = true;
                    SegmentDataSourceRecord temp = new SegmentDataSourceRecord(segment);
                    Iterator outputIterator = output.getRanges().iterator();
                    while (outputIterator.hasNext()) {
                        temp.addRange((RangeDataSourceRecord)outputIterator.next());
                    }
                    localMerges.add(new StreetDataSourceRecord(output.getStreetName(), SAC, temp, output.getOriginalName(), output.getDeliveryInstallationInfo()));
                    continue;
                }
                unMergedRanges.add(range);
                continue;
            }
            unMergedRanges.add(range);
        }
        if (bLocalMerges) {
            mergedRecords.addAll(this.combineLocalMerges(localMerges));
            if (!unMergedRanges.isEmpty()) {
                unMergedIterator = unMergedRanges.iterator();
                while (unMergedIterator.hasNext()) {
                    segment.addRange((RangeDataSourceRecord)unMergedIterator.next());
                }
                noMatchRecords.add(new StreetDataSourceRecord(streetName, SAC, segment));
            }
        } else {
            unMergedIterator = unMergedRanges.iterator();
            while (unMergedIterator.hasNext()) {
                segment.addRange((RangeDataSourceRecord)unMergedIterator.next());
            }
            unMergedRecords.add(new StreetDataSourceRecord(streetName, SAC, segment));
        }
        return bLocalMerges;
    }

    private Collection combineLocalMerges(List localMerges) {
        if (localMerges.size() == 1) {
            return localMerges;
        }
        LinkedList<StreetDataSourceRecord> combinedMerges = new LinkedList<StreetDataSourceRecord>();
        Collections.sort(localMerges, this.m_streetComparator);
        StreetDataSourceRecord currentStreet = null;
        for (StreetDataSourceRecord street : localMerges) {
            if (currentStreet == null) {
                currentStreet = street;
                continue;
            }
            if (currentStreet.getMainAddress().equals(street.getMainAddress())) {
                Iterator ranges = ((SegmentDataSourceRecord)street.getSegment()).getRanges().iterator();
                while (ranges.hasNext()) {
                    ((SegmentDataSourceRecord)currentStreet.getSegment()).addRange((RangeDataSourceRecord)ranges.next());
                }
                continue;
            }
            combinedMerges.add(currentStreet);
            currentStreet = street;
        }
        combinedMerges.add(currentStreet);
        return combinedMerges;
    }

    private class StreetComparator
    implements Comparator {
        private StreetComparator() {
        }

        public int compare(Object o1, Object o2) {
            StreetDataSourceRecord street1 = (StreetDataSourceRecord)o1;
            StreetDataSourceRecord street2 = (StreetDataSourceRecord)o2;
            return street1.getMainAddress().compareTo(street2.getMainAddress());
        }
    }
}

