/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.AbstractMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.ExpandedMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetNameGenerator;
import com.mapinfo.mapmarker.CAN.dp.merge.text.AbstractMergeProcessor;
import com.mapinfo.mapmarker.CAN.dp.merge.text.OutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetNameReplacementProvider;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ExpandedMergeProcessor
extends AbstractMergeProcessor {
    private IDataSource m_source;
    private ExpandedMergeHandler m_handler;

    private ExpandedMergeProcessor(Properties properties, String province, String tabPath, String CANPostPath, String outputPath, String streetReplacementFile, String canPostSourcePath) throws DataSourceException, IOException, IndexAccessException {
        super(province, CANPostPath, outputPath, canPostSourcePath);
        this.m_source = new TabFileDataSource(properties);
        String[] tabArgs = new String[]{tabPath, properties.getProperty("startRow"), properties.getProperty("endRow")};
        this.m_source.open(tabArgs);
        MergeInputRecordBuilder inputBuilder = new MergeInputRecordBuilder(new StreetNameGenerator(new StreetNameReplacementProvider(streetReplacementFile), "QC".equals(province)), new OutputSegmentBuilder(province));
        this.m_handler = new ExpandedMergeHandler(this.m_source, inputBuilder, this.getMerger(), this.getOutputer());
    }

    @Override
    protected AbstractMergeHandler getMergeHandler() {
        return this.m_handler;
    }

    @Override
    protected IDataSource getDataSource() {
        return this.m_source;
    }

    public static void main(String[] args) {
        String replacementFile;
        String province = args[0];
        String propertyFile = args[1];
        String inputTabFile = args[2];
        String CANPostPath = args[3];
        String outputPath = args[4];
        String accentFile = args[5];
        String string = replacementFile = args.length == 7 ? args[6] : null;
        if (replacementFile == null) {
            DataCreationLogger.getLogger().logStatus("No replacement street file given.");
        }
        try {
            ExpandedMergeProcessor processor = new ExpandedMergeProcessor(ExpandedMergeProcessor.loadProperties(propertyFile), province, inputTabFile, CANPostPath, outputPath, replacementFile, accentFile);
            processor.process();
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
        }
        catch (Throwable T) {
            DataCreationLogger.getLogger().logStackTrace(T);
            System.exit(1);
        }
        System.exit(0);
    }

    private static Properties loadProperties(String propertyFile) {
        FileInputStream propertiesFileInputStream = null;
        Properties props = new Properties();
        try {
            propertiesFileInputStream = new FileInputStream(propertyFile);
        }
        catch (FileNotFoundException FNFEx) {
            System.err.println("Unable to find properties file: " + propertyFile);
            System.err.println(FNFEx.getMessage());
            System.exit(1);
        }
        try {
            props.load(propertiesFileInputStream);
        }
        catch (IOException IOEx) {
            System.err.println("Unable to load properties from properties file: " + propertyFile);
            System.err.println(IOEx.getMessage());
            System.exit(1);
        }
        try {
            propertiesFileInputStream.close();
        }
        catch (IOException IOEx) {
            System.err.println("IOException occurred on closing properties file. ");
            System.err.println(IOEx.getMessage());
        }
        return props;
    }
}

