/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputRecordOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeOutputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;

public class MergeOutputRecordOutputer
implements IMergeOutputRecordOutputer {
    private File m_outputFile;
    private File m_unMergedFile;
    private NIOOutputStream m_outputStream;
    private NIOOutputStream m_unMergedStream;
    private int m_outputRecordCount;
    private int m_mergeCount;
    private int m_noMatchCount;
    private int m_unMergedCount;

    public void open(String path, String baseName) throws DataSourceException {
        this.m_outputFile = new File(StringUtilities.appendToPath((String)path, (String)baseName, (String)".tdr"));
        this.m_unMergedFile = new File(StringUtilities.appendToPath((String)path, (String)baseName, (String)".umr"));
        try {
            this.m_outputStream = new NIOOutputStream(this.m_outputFile);
            this.m_unMergedStream = new NIOOutputStream(this.m_unMergedFile);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        try {
            this.m_outputStream.writeInt(0);
            this.m_unMergedStream.writeInt(0);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
    }

    public void close() throws DataSourceException {
        try {
            RandomAccessFile temp;
            if (this.m_outputStream != null) {
                this.m_outputStream.close();
                this.m_outputStream = null;
                temp = new RandomAccessFile(this.m_outputFile, "rw");
                temp.writeInt(this.m_outputRecordCount);
                temp.close();
            }
            if (this.m_unMergedStream != null) {
                this.m_unMergedStream.close();
                this.m_unMergedStream = null;
                temp = new RandomAccessFile(this.m_unMergedFile, "rw");
                temp.writeInt(this.m_unMergedCount);
                temp.close();
            }
        }
        catch (IOException IOEx) {
            throw new DataSourceException(12, (Throwable)IOEx);
        }
        finally {
            DataCreationLogger.getLogger().logStatus("Number of merged results: " + this.m_mergeCount);
            DataCreationLogger.getLogger().logStatus("Number of no match results: " + this.m_noMatchCount);
            DataCreationLogger.getLogger().logStatus("Total output records written: " + this.m_outputRecordCount);
            DataCreationLogger.getLogger().logStatus("Total unMerged blocks written: " + this.m_unMergedCount);
        }
    }

    @Override
    public void output(MergeOutputRecord record) throws DataSourceException {
        if (record.getMergedRecords() != null && !record.getMergedRecords().isEmpty()) {
            ++this.m_mergeCount;
            this.m_outputRecordCount += record.getMergedRecords().size();
            this.write(record.getMergedRecords(), this.m_outputStream);
        }
        if (record.getNoMatchRecords() != null && !record.getNoMatchRecords().isEmpty()) {
            ++this.m_noMatchCount;
            this.m_outputRecordCount += record.getNoMatchRecords().size();
            this.write(record.getNoMatchRecords(), this.m_outputStream);
        }
        if (record.getUnMergedRecords() != null && !record.getUnMergedRecords().isEmpty()) {
            ++this.m_unMergedCount;
            this.writeUnMergedRecords(record.getUnMergedRecords());
        }
    }

    private void writeUnMergedRecords(Collection records) throws DataSourceException {
        int count = records.size();
        try {
            this.m_unMergedStream.writeByte(count);
            this.m_unMergedStream.writeUTF(SourceRecordDataIDProvider.getProvider().getCurrentID());
            this.write(records, this.m_unMergedStream);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }

    private void write(Collection records, NIOOutputStream stream) throws DataSourceException {
        try {
            for (StreetDataSourceRecord street : records) {
                street.write((DataOutput)stream);
            }
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }
}

