/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IUniqueIDElement;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.ComplexMultiIndexValue;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.ReferenceValue;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.UniqueIDIndex;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.UniqueIDIndexKey;
import com.mapinfo.mapmarker.CAN.dp.merge.AbstractMergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.Utilities;
import com.mapinfo.mapmarker.CAN.dp.text.CombinedRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class MergeRecorder
extends AbstractMergeRecorder {
    private RandomAccessDataStream m_indexStream;
    private UniqueIDIndex m_index;

    public void open(String path) throws IOException, IndexAccessException {
        File indexFile = new File(path);
        if (indexFile.exists()) {
            NIOInnerIndexLink link = new NIOInnerIndexLink();
            this.m_indexStream = new RandomAccessDataStream(indexFile);
            this.m_index = new UniqueIDIndex(this.m_indexStream);
            link.read((DataInput)this.m_indexStream);
            this.m_index.access(link);
        } else {
            NIOInnerIndexLink link = new NIOInnerIndexLink();
            this.m_indexStream = new RandomAccessDataStream(indexFile);
            this.m_index = new UniqueIDIndex(this.m_indexStream);
            link.write((DataOutput)this.m_indexStream);
            this.m_index.create(link);
        }
    }

    public void close() throws IOException {
        this.m_index = null;
        this.m_indexStream.close();
    }

    @Override
    protected Collection<ReferenceValue> getPreviousEntries(IUniqueIDElement element) {
        UniqueIDIndexKey key = new UniqueIDIndexKey(element.getUniqueID());
        try {
            ComplexMultiIndexValue value = (ComplexMultiIndexValue)this.m_index.search((MapMarkerIndexKey)key);
            if (value == null) {
                return null;
            }
            return value.getValues();
        }
        catch (IndexAccessException IAEx) {
            System.err.println("exception");
            return null;
        }
    }

    @Override
    protected ICombinedRecord makeSubRecord(ICombinedRecord combinedRecord, IStreetElements streetElements) {
        return new CombinedRecord(combinedRecord, streetElements);
    }

    @Override
    protected IStreetElements makeStreetElement(IStreetElements elements, int from, int to, int oddEvenBoth) {
        return new StreetElements(elements, from, to, oddEvenBoth);
    }

    @Override
    protected void put(UniqueIDIndexKey key, ReferenceValue value) {
        try {
            this.m_index.insert((MapMarkerIndexKey)key, value);
        }
        catch (IndexAccessException IAEx) {
            throw new RuntimeException(IAEx);
        }
    }

    private static class StreetElements
    implements IStreetElements {
        private String m_streetName;
        private String m_streetTypeCode;
        private String m_streetDirectionCode;
        private char m_streetAddressSequenceCode;
        private String m_streetAddressToNumber;
        private char m_streetAddressNumberSuffixToCode;
        private boolean m_streetNameAccentIndicator;
        private String m_streetAddressFromNumber;
        private char m_streetAddressNumberSuffixFromCode;

        private StreetElements(IStreetElements elements, int from, int to, int oddEven) {
            this.m_streetName = elements.getStreetName();
            this.m_streetTypeCode = elements.getStreetTypeCode();
            this.m_streetDirectionCode = elements.getStreetDirectionCode();
            this.m_streetAddressSequenceCode = this.convertToAddressSequenceCode(oddEven);
            this.m_streetAddressToNumber = String.valueOf(to);
            this.m_streetAddressNumberSuffixToCode = elements.getStreetAddressNumberSuffixToCode();
            this.m_streetNameAccentIndicator = elements.getStreetNameAccentIndicator();
            this.m_streetAddressFromNumber = String.valueOf(from);
            this.m_streetAddressNumberSuffixFromCode = elements.getStreetAddressNumberSuffixFromCode();
        }

        @Override
        public String getStreetName() {
            return this.m_streetName;
        }

        @Override
        public String getStreetTypeCode() {
            return this.m_streetTypeCode;
        }

        @Override
        public String getStreetDirectionCode() {
            return this.m_streetDirectionCode;
        }

        @Override
        public char getStreetAddressSequenceCode() {
            return this.m_streetAddressSequenceCode;
        }

        @Override
        public String getStreetAddressToNumber() {
            return this.m_streetAddressToNumber;
        }

        @Override
        public char getStreetAddressNumberSuffixToCode() {
            return this.m_streetAddressNumberSuffixToCode;
        }

        @Override
        public boolean getStreetNameAccentIndicator() {
            return this.m_streetNameAccentIndicator;
        }

        @Override
        public String getStreetAddressFromNumber() {
            return this.m_streetAddressFromNumber;
        }

        @Override
        public char getStreetAddressNumberSuffixFromCode() {
            return this.m_streetAddressNumberSuffixFromCode;
        }

        @Override
        public String getStreetAddressNumberSuffix(char code) {
            return Utilities.getStreetAddressNumberSuffix(code);
        }

        private char convertToAddressSequenceCode(int oddEven) {
            switch (oddEven) {
                case 1: {
                    return '1';
                }
                case 2: {
                    return '2';
                }
            }
            return '3';
        }
    }
}

