/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.FSAProvinceChecker;
import com.mapinfo.mapmarker.CAN.dp.merge.IOutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class OutputSegmentBuilder
implements IOutputSegmentBuilder {
    private String m_province;

    public OutputSegmentBuilder(String province) {
        this.m_province = province;
    }

    @Override
    public Collection<SegmentDataSourceRecord> buildOutputSegments(ICAN_SegmentDataSourceRecord segment) throws DataSourceException {
        boolean bValidLeft = this.checkSegment(segment, true);
        boolean bValidRight = this.checkSegment(segment, false);
        LinkedList<SegmentDataSourceRecord> outputs = null;
        if (bValidLeft && bValidRight) {
            if (this.splitSegment(segment)) {
                outputs = new LinkedList();
                outputs.add(new SegmentDataSourceRecord(segment, true, false));
                outputs.add(new SegmentDataSourceRecord(segment, false, true));
            } else {
                outputs = new LinkedList();
                outputs.add(new SegmentDataSourceRecord(segment, true, true));
            }
        } else if (bValidLeft) {
            outputs = new LinkedList<SegmentDataSourceRecord>();
            outputs.add(new SegmentDataSourceRecord(segment, true, false));
        } else if (bValidRight) {
            outputs = new LinkedList();
            outputs.add(new SegmentDataSourceRecord(segment, false, true));
        }
        return this.assureAscending(outputs);
    }

    private Collection<SegmentDataSourceRecord> assureAscending(Collection<SegmentDataSourceRecord> segments) throws DataSourceException {
        if (segments == null) {
            return null;
        }
        LinkedList<SegmentDataSourceRecord> outputSegments = new LinkedList<SegmentDataSourceRecord>();
        for (SegmentDataSourceRecord segment : segments) {
            ArrayList ranges = segment.getRanges();
            if (ranges != null) {
                boolean bHasLeft = false;
                boolean bHasRight = false;
                boolean bSomeLeft = false;
                boolean bSomeRight = false;
                boolean bAllLeft = true;
                boolean bAllRight = true;
                for (RangeDataSourceRecord range : ranges) {
                    if (range.isLeft()) {
                        bHasLeft = true;
                    } else {
                        bHasRight = true;
                    }
                    if (!range.isAscending()) {
                        if (range.isLeft()) {
                            bAllLeft = false;
                            continue;
                        }
                        bAllRight = false;
                        continue;
                    }
                    if (range.isLeft()) {
                        bSomeLeft = true;
                        continue;
                    }
                    bSomeRight = true;
                }
                if (bAllLeft && bAllRight) {
                    outputSegments.add(segment);
                    continue;
                }
                if (bHasLeft && bHasRight) {
                    if (bAllLeft && !bAllRight) {
                        if (bSomeRight) {
                            for (RangeDataSourceRecord range : ranges) {
                                if (range.isLeft() || range.isAscending()) continue;
                                range.makeAscending();
                            }
                            outputSegments.add(segment);
                            continue;
                        }
                        outputSegments.add(new SegmentDataSourceRecord(segment, true, false));
                        SegmentDataSourceRecord right = new SegmentDataSourceRecord(segment, false, true);
                        right.reverse();
                        outputSegments.add(right);
                        continue;
                    }
                    if (!bAllLeft && bAllRight) {
                        if (bSomeLeft) {
                            for (RangeDataSourceRecord range : ranges) {
                                if (!range.isLeft() || range.isAscending()) continue;
                                range.makeAscending();
                            }
                            outputSegments.add(segment);
                            continue;
                        }
                        outputSegments.add(new SegmentDataSourceRecord(segment, false, true));
                        SegmentDataSourceRecord left = new SegmentDataSourceRecord(segment, true, false);
                        left.reverse();
                        outputSegments.add(left);
                        continue;
                    }
                    segment.reverse();
                    outputSegments.add(segment);
                    continue;
                }
                if (bHasLeft) {
                    if (!bAllLeft) {
                        if (bSomeLeft) {
                            DataCreationLogger.getLogger().logError("WARNING: Some but not all ranges on the left are ascending for: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
                            for (RangeDataSourceRecord range : ranges) {
                                if (range.isAscending()) continue;
                                range.makeAscending();
                            }
                            outputSegments.add(segment);
                            continue;
                        }
                        segment.reverse();
                        outputSegments.add(segment);
                        continue;
                    }
                    outputSegments.add(segment);
                    continue;
                }
                if (!bHasRight) continue;
                if (!bAllRight) {
                    if (bSomeRight) {
                        DataCreationLogger.getLogger().logError("WARNING: Some but not all ranges on the right are ascending for:" + SourceRecordDataIDProvider.getProvider().getCurrentID());
                        for (RangeDataSourceRecord range : ranges) {
                            if (range.isAscending()) continue;
                            range.makeAscending();
                        }
                        outputSegments.add(segment);
                        continue;
                    }
                    segment.reverse();
                    outputSegments.add(segment);
                    continue;
                }
                outputSegments.add(segment);
                continue;
            }
            outputSegments.add(segment);
        }
        return outputSegments;
    }

    private boolean checkFSA(String FSA) {
        return FSAProvinceChecker.check(FSA, this.m_province);
    }

    private boolean checkSegment(ISegmentDataSourceRecord segment, boolean bLeft) throws DataSourceException {
        if (bLeft) {
            if (segment.hasLeftAreaName1()) {
                if (this.m_province.equals(segment.getLeftAreaName1())) {
                    if (segment.hasLeftPostCode1()) {
                        return this.checkFSA(segment.getLeftPostCode1());
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        if (segment.hasRightAreaName1()) {
            if (this.m_province.equals(segment.getRightAreaName1())) {
                if (segment.hasRightPostCode1()) {
                    return this.checkFSA(segment.getRightPostCode1());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean splitSegment(ISegmentDataSourceRecord segment) throws DataSourceException {
        return !segment.getLeftPostCode1().equals(segment.getRightPostCode1());
    }
}

