/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.CANPostStreet;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IBuildingElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IGovernmentElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ILVRElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ISuiteElements;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.ParitySequenceDivider;
import com.mapinfo.mapmarker.CAN.dp.merge.RangeDataConsolidator;
import com.mapinfo.mapmarker.CAN.dp.merge.RangeMergeOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class RangeMergeHandler
implements IRangeMergeHandler {
    private static final boolean m_bEmptyRangeUnitRangeLDUs = false;
    private IMergeRecorder m_recorder;
    private StreetNameBuilder m_streetNameBuilder;
    private AccentsLookup m_accents;
    private boolean m_bUniqueStreetOverlap;
    private boolean m_bUniqueCityOutput;
    private boolean m_bAllowUnitsToMerge;
    private IPostalRecordFilter m_postalFilter;

    public RangeMergeHandler(IMergeRecorder recorder, AccentsLookup accents, IPostalRecordFilter postalFilter) {
        this(recorder, accents, false, postalFilter);
    }

    public RangeMergeHandler(IMergeRecorder recorder, AccentsLookup accents, boolean bUniqueCityOutput, IPostalRecordFilter postalFilter) {
        this(recorder, accents, bUniqueCityOutput, false, postalFilter);
    }

    public RangeMergeHandler(IMergeRecorder recorder, AccentsLookup accents, boolean bUniqueCityOutput, boolean bAllowUnitsToMerge, IPostalRecordFilter postalFilter) {
        this.m_recorder = recorder;
        this.m_streetNameBuilder = new StreetNameBuilder(accents);
        this.m_accents = accents;
        this.m_bUniqueCityOutput = bUniqueCityOutput;
        this.m_bAllowUnitsToMerge = bAllowUnitsToMerge;
        this.m_postalFilter = postalFilter;
    }

    @Override
    public void requireUniqueStreetOverlap(boolean bFlag) {
        this.m_bUniqueStreetOverlap = bFlag;
    }

    @Override
    public Collection<Overlap> getValidPostalData(IRangeDataSourceRecord inputRange, Collection<ICombinedRecord> postalRecords) {
        RangeDataSourceRecord range = (RangeDataSourceRecord)inputRange;
        if (!range.hasFrom() && !range.hasTo()) {
            return null;
        }
        boolean bHasUnits = this.hasUnits(range);
        if (bHasUnits && !this.m_bAllowUnitsToMerge) {
            return null;
        }
        Range rng = new Range(new ParsedNumber(range.getFrom()), new ParsedNumber(range.getTo()), this.getOddEven(range));
        Iterator<ICombinedRecord> iterator = postalRecords.iterator();
        LinkedList<Overlap> valids = new LinkedList<Overlap>();
        boolean bFoundLeftOver = false;
        while (iterator.hasNext()) {
            ICombinedRecord record = iterator.next();
            Collection<ICombinedRecord> availables = bHasUnits ? Collections.singletonList(record) : this.m_recorder.getAvailable(record);
            if (availables == null) continue;
            bFoundLeftOver = true;
            for (ICombinedRecord availableRecord : availables) {
                IStreetElements availableElements = availableRecord.getStreetElements();
                Range postalRange = new Range(new ParsedNumber(availableElements.getStreetAddressFromNumber()), new ParsedNumber(availableElements.getStreetAddressToNumber()), this.getOddEvenBoth(availableElements));
                Range overlap = rng.getOverlap(postalRange);
                if (overlap == null) continue;
                valids.add(new Overlap(record, overlap));
            }
        }
        if (!bFoundLeftOver) {
            MergeLogger.getLogger().logNoLeftOvers(SourceRecordDataIDProvider.getProvider().getCurrentID(), range.isLeft());
        }
        if (valids.isEmpty()) {
            MergeLogger.getLogger().logNoMerge(SourceRecordDataIDProvider.getProvider().getCurrentID(), range.isLeft());
            return null;
        }
        return valids;
    }

    @Override
    public RangeMergeOutput makeOutput(String inputName, IRangeDataSourceRecord inputRange, Collection<Overlap> overlaps, SegmentDataSourceRecord segment) {
        LinkedList<TempMergeResult> tempResults = new LinkedList<TempMergeResult>();
        for (Overlap overlap : overlaps) {
            CANPostStreet street = this.m_streetNameBuilder.makeStreet(overlap.getRecord());
            if (street == null) continue;
            TempMergeResult result = new TempMergeResult(street, overlap);
            int previousIndex = tempResults.indexOf(result);
            if (previousIndex < 0) {
                tempResults.add(result);
                continue;
            }
            TempMergeResult previous = (TempMergeResult)tempResults.get(previousIndex);
            previous.addRecord(overlap);
        }
        if (this.m_bUniqueStreetOverlap && tempResults.size() > 1) {
            return null;
        }
        if (tempResults.size() > 1) {
            for (TempMergeResult result : tempResults) {
                DataCreationLogger.getLogger().logStatus("\tScoring input: " + inputName + " against: " + result.getStreet().getStreetName());
                double score = MergeUtilities.score(inputName, result.getStreet().getStreetName());
                if (score == 1.0 && inputName.equalsIgnoreCase(result.getStreet().getStreetName())) {
                    score = 1.1;
                }
                DataCreationLogger.getLogger().logStatus("\t\tscore: " + score);
                result.setScore(score);
            }
            Collections.sort(tempResults);
            TempMergeResult result1 = (TempMergeResult)tempResults.get(0);
            TempMergeResult result2 = (TempMergeResult)tempResults.get(1);
            if (result1.getScore() == result2.getScore()) {
                DataCreationLogger.getLogger().logStatus("Unable to choose between:");
                DataCreationLogger.getLogger().logStatus('\t' + result1.toString());
                DataCreationLogger.getLogger().logStatus('\t' + result2.toString());
                return null;
            }
            DataCreationLogger.getLogger().logStatus("\t\tbest name: " + tempResults.get(0));
        }
        TempMergeResult outputResult = (TempMergeResult)tempResults.get(0);
        if (this.m_bUniqueCityOutput && !this.hasUniqueMunicipality(outputResult)) {
            return null;
        }
        Collection ranges = this.applyOverlaps((RangeDataSourceRecord)inputRange, outputResult.getRecords(), segment);
        if (ranges.isEmpty()) {
            return null;
        }
        RangeMergeOutput output = new RangeMergeOutput(outputResult.getStreet().getStreetName(), outputResult.getStreet().getOriginalName(), outputResult.getStreet().getDeliveryInstallationInfo(), RangeDataConsolidator.consolidate(ranges));
        if (((RangeDataSourceRecord)inputRange).getPoint() != null && output.getRanges().size() > 1) {
            DataCreationLogger.getLogger().logInternalError("Had multiple overlaps in final consolidated range output");
            DataCreationLogger.getLogger().logInternalError("source ID: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
            DataCreationLogger.getLogger().logInternalError("note that some of the following overlaps may not have been applied, but at least two were");
            for (Overlap overlap : overlaps) {
                DataCreationLogger.getLogger().logInternalError('\t' + overlap.getRecord().getUniqueIDElement().getUniqueID());
            }
        }
        return output;
    }

    private boolean hasUniqueMunicipality(TempMergeResult mergeResult) {
        Collection<Overlap> records = mergeResult.getRecords();
        if (records.size() == 1) {
            return true;
        }
        return this.hasUniqueMunicipality(records);
    }

    private boolean hasUniqueMunicipality(Collection<Overlap> overlaps) {
        HashSet<String> municipalities = new HashSet<String>();
        for (Overlap overlap : overlaps) {
            municipalities.add(overlap.getRecord().getStandardElements().getMunicipalityName());
        }
        return municipalities.size() == 1;
    }

    private int getOddEvenBoth(IStreetElements elements) {
        switch (elements.getStreetAddressSequenceCode()) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
        }
        return 0;
    }

    private int getOddEven(RangeDataSourceRecord range) {
        if ("0".equals(range.getStatus())) {
            return 2;
        }
        if ("1".equals(range.getStatus())) {
            return 1;
        }
        if (range.getFrom().equals(range.getTo())) {
            return Integer.parseInt(range.getFrom()) % 2 == 0 ? 2 : 1;
        }
        return 0;
    }

    private Collection applyOverlaps(RangeDataSourceRecord range, Collection<Overlap> overlaps, SegmentDataSourceRecord segment) {
        LinkedList<RangeDataSourceRecord> outputRanges = new LinkedList<RangeDataSourceRecord>();
        ParsedNumber from = new ParsedNumber(range.getFrom());
        ParsedNumber to = new ParsedNumber(range.getTo());
        ParitySequenceDivider originalRangeSequence = new ParitySequenceDivider((int)from.getAddressNumber(), (int)to.getAddressNumber(), this.getOddEven(range));
        if (range.getPoint() != null && overlaps.size() > 1 && (overlaps = this.fixPointHouseOverlaps(range, overlaps, segment)).isEmpty()) {
            return outputRanges;
        }
        for (Overlap overlap : overlaps) {
            originalRangeSequence.removeRange((int)overlap.getOverlap().getFrom().getAddressNumber(), (int)overlap.getOverlap().getTo().getAddressNumber(), overlap.getOverlap().getOddEvenBoth());
        }
        Collection<ParitySequenceDivider.IntegerSegment> leftOvers = originalRangeSequence.getRemainingRanges();
        if (leftOvers != null) {
            for (ParitySequenceDivider.IntegerSegment intSegment : leftOvers) {
                outputRanges.add(new RangeDataSourceRecord(String.valueOf(intSegment.getStart()), String.valueOf(intSegment.getEnd()), this.convertStatus(intSegment.getOddEvenBoth()), range.isLeft()));
            }
        }
        for (Overlap overlap : overlaps) {
            RangeDataSourceRecord overlapRange = this.makeOverlapRange(overlap, range.isLeft());
            if (range.getPoint() != null) {
                overlapRange.setPoint(range.getPoint());
            }
            if (range.getPlaceName() != null) {
                if (overlapRange.getPlaceName() != null) {
                    DataCreationLogger.getLogger().logStatus("CANPost placeName of: " + overlapRange.getPlaceName() + " superceded by source placeName: " + range.getPlaceName());
                }
                overlapRange.setPlaceName(range.getPlaceName());
            }
            if (this.hasUnits(range)) {
                if (this.hasUnits(overlapRange)) {
                    DataCreationLogger.getLogger().logStatus("source record had units and overlap has units, not keeping source");
                    DataCreationLogger.getLogger().logStatus("source ID: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
                    DataCreationLogger.getLogger().logStatus("overlap ID: " + overlap.getRecord().getUniqueIDElement().getUniqueID());
                } else {
                    ArrayList units = range.getUnits();
                    for (UnitDataSourceRecord unit : units) {
                        overlapRange.addUnit(unit);
                    }
                }
            }
            if (range.getPbkey() != null) {
                overlapRange.setPbkey(range.getPbkey());
            }
            outputRanges.add(overlapRange);
            this.recordMerge(overlap);
        }
        return outputRanges;
    }

    private Collection<Overlap> fixPointHouseOverlaps(RangeDataSourceRecord range, Collection<Overlap> overlaps, SegmentDataSourceRecord segment) {
        Collection<Overlap> subResultOverlaps;
        Collection<Overlap> cityFilteredOverlaps = this.filterMatchingCityOnly(overlaps, segment, range.isLeft());
        if (!cityFilteredOverlaps.isEmpty()) {
            return cityFilteredOverlaps;
        }
        if (this.hasUniqueMunicipality(overlaps)) {
            return overlaps;
        }
        Collection<Overlap> resultOverlaps = this.getSingleHouseOverlaps(overlaps);
        if (resultOverlaps.isEmpty()) {
            resultOverlaps = this.getNonAlphaOverlaps(overlaps);
            if (resultOverlaps.isEmpty()) {
                DataCreationLogger.getLogger().logInternalError("Had multiple overlaps, none of which were 'non-alpha' matches, no overlaps will be applied");
                DataCreationLogger.getLogger().logInternalError("source ID: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
                for (Overlap overlap : overlaps) {
                    DataCreationLogger.getLogger().logInternalError('\t' + overlap.getRecord().getUniqueIDElement().getUniqueID());
                }
            } else if (resultOverlaps.size() > 1) {
                resultOverlaps = Collections.emptyList();
                DataCreationLogger.getLogger().logInternalError("Had multiple 'non-alpha' overlaps, no overlaps will be applied");
                DataCreationLogger.getLogger().logInternalError("source ID: " + SourceRecordDataIDProvider.getProvider().getCurrentID());
                for (Overlap overlap : overlaps) {
                    DataCreationLogger.getLogger().logInternalError('\t' + overlap.getRecord().getUniqueIDElement().getUniqueID());
                }
            }
        } else if (resultOverlaps.size() > 1 && !(subResultOverlaps = this.getNonAlphaOverlaps(resultOverlaps)).isEmpty()) {
            resultOverlaps = subResultOverlaps;
        }
        return resultOverlaps;
    }

    private Collection<Overlap> getSingleHouseOverlaps(Collection<Overlap> overlaps) {
        ArrayList<Overlap> resultOverlaps = new ArrayList<Overlap>();
        for (Overlap overlap : overlaps) {
            if (!overlap.getRecord().getStreetElements().getStreetAddressFromNumber().equals(overlap.getRecord().getStreetElements().getStreetAddressToNumber())) continue;
            resultOverlaps.add(overlap);
        }
        return resultOverlaps;
    }

    private Collection<Overlap> getNonAlphaOverlaps(Collection<Overlap> overlaps) {
        ArrayList<Overlap> resultOverlaps = new ArrayList<Overlap>();
        for (Overlap overlap : overlaps) {
            IStreetElements elements = overlap.getRecord().getStreetElements();
            if (elements.getStreetAddressNumberSuffix(elements.getStreetAddressNumberSuffixFromCode()) != null || elements.getStreetAddressNumberSuffix(elements.getStreetAddressNumberSuffixToCode()) != null) continue;
            resultOverlaps.add(overlap);
        }
        return resultOverlaps;
    }

    private Collection<Overlap> filterMatchingCityOnly(Collection<Overlap> overlaps, SegmentDataSourceRecord segment, boolean bLeft) {
        if (this.m_postalFilter == null) {
            return Collections.emptyList();
        }
        Collection resultOverlaps = this.m_postalFilter.filterNoAlternates(new ArrayList<Overlap>(overlaps), segment, bLeft);
        if (resultOverlaps != null) {
            return resultOverlaps;
        }
        return Collections.emptyList();
    }

    private void recordMerge(Overlap overlap) {
        this.m_recorder.record((int)overlap.getOverlap().getFrom().getAddressNumber(), (int)overlap.getOverlap().getTo().getAddressNumber(), (byte)overlap.getOverlap().getOddEvenBoth(), overlap.getRecord());
    }

    private RangeDataSourceRecord makeOverlapRange(Overlap overlap, boolean bLeft) {
        UnitDataSourceRecord unit = this.getUnit(overlap.getRecord());
        RangeDataSourceRecord outputRecord = new RangeDataSourceRecord(overlap.getOverlap().getFrom().getCombinedAddressNumber(), overlap.getOverlap().getTo().getCombinedAddressNumber(), this.convertStatus(overlap.getOverlap().getOddEvenBoth()), bLeft, this.getLDU(overlap.getRecord().getStandardElements()), null, unit == null ? this.getPlaceName(overlap.getRecord()) : null, overlap.getRecord().getStandardElements().getProvinceCode(), this.getMunicipalityName(overlap.getRecord().getStandardElements()), unit, overlap.getRecord().getRouteServiceElements());
        return outputRecord;
    }

    private String convertStatus(int oddEvenBoth) {
        switch (oddEvenBoth) {
            case 1: {
                return "1";
            }
            case 2: {
                return "0";
            }
        }
        return "2";
    }

    private String getPlaceName(ICombinedRecord record) {
        IBuildingElements building = record.getBuildingElements();
        if (building != null && building.getBuildingName() != null) {
            return building.getBuildingName();
        }
        ILVRElements LVR = record.getLVRElements();
        if (LVR != null && LVR.getLVRName() != null) {
            return LVR.getLVRName();
        }
        IGovernmentElements government = record.getGovernmentElements();
        if (government != null && government.getDepartmentName() != null) {
            return government.getDepartmentName();
        }
        return null;
    }

    private String getLDU(IStandardElements elements) {
        return elements.getPostalCode().substring(3);
    }

    private String getMunicipalityName(IStandardElements elements) {
        if (elements.getMunicipalityNameAccentIndicator()) {
            return this.m_accents.get(elements.getMunicipalityName());
        }
        return elements.getMunicipalityName();
    }

    private UnitDataSourceRecord getUnit(ICombinedRecord record) {
        ISuiteElements suite = record.getSuiteElements();
        if (suite == null) {
            return null;
        }
        String lowUnit = suite.getSuiteFromNumber();
        String highUnit = suite.getSuiteToNumber();
        if (lowUnit != null && highUnit != null) {
            return new UnitDataSourceRecord(lowUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        if (highUnit != null) {
            DataCreationLogger.getLogger().logInternalError("High unit only -- " + highUnit);
            return new UnitDataSourceRecord(highUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        if (lowUnit != null) {
            DataCreationLogger.getLogger().logInternalError("Low unit only -- " + lowUnit);
            return new UnitDataSourceRecord(lowUnit, lowUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        return null;
    }

    private boolean hasUnits(RangeDataSourceRecord range) {
        if (range.getUnits() != null && range.getUnits().size() > 0) {
            UnitDataSourceRecord unit = (UnitDataSourceRecord)range.getUnits().get(0);
            return unit.hasLowUnit() && !StringUtilities.isEmpty((String)unit.getLowUnit()) || unit.hasHighUnit() && !StringUtilities.isEmpty((String)unit.getHighUnit()) || unit.hasUnitType() && !StringUtilities.isEmpty((String)unit.getUnitType());
        }
        return false;
    }

    private static class TempMergeResult
    implements Comparable {
        private CANPostStreet m_street;
        private double m_score;
        private Collection<Overlap> m_records;

        public TempMergeResult(CANPostStreet street, Overlap record) {
            this.m_street = street;
            this.m_records = new LinkedList<Overlap>();
            this.m_records.add(record);
        }

        public CANPostStreet getStreet() {
            return this.m_street;
        }

        public void addRecord(Overlap record) {
            this.m_records.add(record);
        }

        public Collection<Overlap> getRecords() {
            return this.m_records;
        }

        public void setScore(double score) {
            this.m_score = score;
        }

        public double getScore() {
            return this.m_score;
        }

        public int compareTo(Object that) {
            return -1 * Double.compare(this.m_score, ((TempMergeResult)that).m_score);
        }

        public boolean equals(Object that) {
            return this.m_street.equals(((TempMergeResult)that).m_street);
        }

        public String toString() {
            return this.m_street.toString() + "\tscore: " + this.m_score;
        }
    }

    public static class Overlap {
        private ICombinedRecord m_record;
        private Range m_range;

        public Overlap(ICombinedRecord record, Range range) {
            this.m_record = record;
            this.m_range = range;
        }

        public ICombinedRecord getRecord() {
            return this.m_record;
        }

        public Range getOverlap() {
            return this.m_range;
        }
    }

    private static class Range {
        private ParsedNumber m_from;
        private ParsedNumber m_to;
        private int m_oddEvenBoth;

        public Range(ParsedNumber from, ParsedNumber to, int oddEvenBoth) {
            this.m_from = from;
            this.m_to = to;
            this.m_oddEvenBoth = oddEvenBoth;
        }

        public ParsedNumber getFrom() {
            return this.m_from;
        }

        public ParsedNumber getTo() {
            return this.m_to;
        }

        public int getOddEvenBoth() {
            return this.m_oddEvenBoth;
        }

        public Range getOverlap(Range that) {
            boolean alphaNumericThis;
            Range thatRange;
            Range thisRange;
            if (this.m_oddEvenBoth == that.m_oddEvenBoth) {
                thisRange = this;
                thatRange = that;
            } else if (this.m_oddEvenBoth == 0) {
                thatRange = that;
                thisRange = that.m_oddEvenBoth == 2 ? this.makeEvenRange(this) : this.makeOddRange(this);
            } else if (that.m_oddEvenBoth == 0) {
                thisRange = this;
                thatRange = this.m_oddEvenBoth == 2 ? this.makeEvenRange(that) : this.makeOddRange(that);
            } else {
                return null;
            }
            boolean bl = alphaNumericThis = !thisRange.getFrom().isPureNumeric() || !thisRange.getTo().isPureNumeric();
            if (alphaNumericThis) {
                return null;
            }
            if (thisRange.m_from.compareTo((Object)thatRange.m_from) <= 0 && thisRange.m_to.compareTo((Object)thatRange.m_to) >= 0) {
                return new Range(thatRange.m_from, thatRange.m_to, thatRange.m_oddEvenBoth);
            }
            if (thatRange.m_from.compareTo((Object)thisRange.m_from) <= 0 && thatRange.m_to.compareTo((Object)thisRange.m_to) >= 0) {
                return new Range(thisRange.m_from, thisRange.m_to, thisRange.m_oddEvenBoth);
            }
            if (thisRange.m_from.compareTo((Object)thatRange.m_from) >= 0 && thisRange.m_from.compareTo((Object)thatRange.m_to) <= 0) {
                return new Range(thisRange.m_from, thatRange.m_to, thisRange.m_oddEvenBoth);
            }
            if (thisRange.m_to.compareTo((Object)thatRange.m_from) >= 0 && thisRange.m_to.compareTo((Object)thatRange.m_to) <= 0) {
                return new Range(thatRange.m_from, thisRange.m_to, thisRange.m_oddEvenBoth);
            }
            return null;
        }

        private Range makeEvenRange(Range that) {
            boolean bToEven;
            boolean bFromEven = that.m_from.isRangeOddEvenBoth() == 2;
            boolean bl = bToEven = that.m_to.isRangeOddEvenBoth() == 2;
            if (bFromEven && bToEven) {
                return new Range(that.m_from, that.m_to, 2);
            }
            if (!bFromEven && !bToEven) {
                return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), new ParsedNumber(that.m_to.getAddressNumber() - 1L), 2);
            }
            if (bFromEven) {
                return new Range(that.m_from, new ParsedNumber(that.m_to.getAddressNumber() - 1L), 2);
            }
            return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), that.m_to, 2);
        }

        private Range makeOddRange(Range that) {
            boolean bToOdd;
            boolean bFromOdd = that.m_from.isRangeOddEvenBoth() == 1;
            boolean bl = bToOdd = that.m_to.isRangeOddEvenBoth() == 1;
            if (bFromOdd && bToOdd) {
                return new Range(that.m_from, that.m_to, 1);
            }
            if (!bFromOdd && !bToOdd) {
                return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), new ParsedNumber(that.m_to.getAddressNumber() - 1L), 1);
            }
            if (bFromOdd) {
                return new Range(that.m_from, new ParsedNumber(that.m_to.getAddressNumber() - 1L), 1);
            }
            return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), that.m_to, 1);
        }
    }
}

