/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IBuildingElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IGovernmentElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ILVRElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ISuiteElements;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeLogger;
import com.mapinfo.mapmarker.CAN.dp.merge.ParitySequenceDivider;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class RangeMerger
implements IRangeMerger {
    private IMergeRecorder m_recorder;

    public RangeMerger(IMergeRecorder recorder) {
        this.m_recorder = recorder;
    }

    @Override
    public Collection merge(RangeDataSourceRecord range, Collection postalRecords) {
        if (!range.hasFrom() && !range.hasTo()) {
            return null;
        }
        Range rng = new Range(new ParsedNumber(range.getFrom()), new ParsedNumber(range.getTo()), this.getOddEven(range));
        Iterator iterator = postalRecords.iterator();
        LinkedList<Overlap> overlaps = new LinkedList<Overlap>();
        boolean bFoundLeftOver = false;
        while (iterator.hasNext()) {
            ICombinedRecord record = (ICombinedRecord)iterator.next();
            Collection<ICombinedRecord> availables = this.m_recorder.getAvailable(record);
            if (availables == null) continue;
            bFoundLeftOver = true;
            Iterator<ICombinedRecord> availablesIterator = availables.iterator();
            while (availablesIterator.hasNext()) {
                IStreetElements availableElents = availablesIterator.next().getStreetElements();
                Range postalRange = new Range(new ParsedNumber(availableElents.getStreetAddressFromNumber()), new ParsedNumber(availableElents.getStreetAddressToNumber()), this.getOddEvenBoth(availableElents));
                Range overlap = rng.getOverlap(postalRange);
                if (overlap == null) continue;
                overlaps.add(new Overlap(record, overlap));
            }
        }
        if (!bFoundLeftOver) {
            MergeLogger.getLogger().logNoLeftOvers(SourceRecordDataIDProvider.getProvider().getCurrentID(), range.isLeft());
        }
        if (overlaps.isEmpty()) {
            MergeLogger.getLogger().logNoMerge(SourceRecordDataIDProvider.getProvider().getCurrentID(), range.isLeft());
            return null;
        }
        return this.applyOverlaps(range, overlaps);
    }

    private int getOddEvenBoth(IStreetElements elements) {
        switch (elements.getStreetAddressSequenceCode()) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
        }
        return 0;
    }

    private int getOddEven(RangeDataSourceRecord range) {
        if ("0".equals(range.getStatus())) {
            return 2;
        }
        if ("1".equals(range.getStatus())) {
            return 1;
        }
        if (range.getFrom().equals(range.getTo())) {
            return Integer.parseInt(range.getFrom()) % 2 == 0 ? 2 : 1;
        }
        return 0;
    }

    private Collection applyOverlaps(RangeDataSourceRecord range, Collection overlaps) {
        LinkedList<RangeDataSourceRecord> outputRanges = new LinkedList<RangeDataSourceRecord>();
        ParitySequenceDivider originalRangeSequence = new ParitySequenceDivider(Integer.parseInt(range.getFrom()), Integer.parseInt(range.getTo()), this.getOddEven(range));
        for (Overlap overlap : overlaps) {
            originalRangeSequence.removeRange((int)overlap.getOverlap().getFrom().getAddressNumber(), (int)overlap.getOverlap().getTo().getAddressNumber(), overlap.getOverlap().getOddEvenBoth());
        }
        Collection<ParitySequenceDivider.IntegerSegment> leftOvers = originalRangeSequence.getRemainingRanges();
        if (leftOvers != null) {
            for (ParitySequenceDivider.IntegerSegment segment : leftOvers) {
                outputRanges.add(new RangeDataSourceRecord(String.valueOf(segment.getStart()), String.valueOf(segment.getEnd()), this.convertStatus(segment.getOddEvenBoth()), range.isLeft()));
            }
        }
        for (Overlap overlap : overlaps) {
            outputRanges.add(this.makeOverlapRange(overlap, range.isLeft()));
            this.recordMerge(overlap);
        }
        return outputRanges;
    }

    private void recordMerge(Overlap overlap) {
        this.m_recorder.record((int)overlap.getOverlap().getFrom().getAddressNumber(), (int)overlap.getOverlap().getTo().getAddressNumber(), (byte)overlap.getOverlap().getOddEvenBoth(), overlap.getRecord());
    }

    private RangeDataSourceRecord makeOverlapRange(Overlap overlap, boolean bLeft) {
        UnitDataSourceRecord unit = this.getUnit(overlap.getRecord());
        RangeDataSourceRecord outputRecord = new RangeDataSourceRecord(overlap.getOverlap().getFrom().getCombinedAddressNumber(), overlap.getOverlap().getTo().getCombinedAddressNumber(), this.convertStatus(overlap.getOverlap().getOddEvenBoth()), bLeft, this.getLDU(overlap.getRecord().getStandardElements()), null, unit != null ? this.getPlaceName(overlap.getRecord()) : null, overlap.getRecord().getStandardElements().getProvinceCode(), overlap.getRecord().getStandardElements().getMunicipalityName(), unit);
        return outputRecord;
    }

    private String convertStatus(int oddEvenBoth) {
        switch (oddEvenBoth) {
            case 1: {
                return "1";
            }
            case 2: {
                return "0";
            }
        }
        return "2";
    }

    private String getPlaceName(ICombinedRecord record) {
        IBuildingElements building = record.getBuildingElements();
        if (building != null && building.getBuildingName() != null) {
            return building.getBuildingName();
        }
        ILVRElements LVR = record.getLVRElements();
        if (LVR != null && LVR.getLVRName() != null) {
            return LVR.getLVRName();
        }
        IGovernmentElements government = record.getGovernmentElements();
        if (government != null && government.getDepartmentName() != null) {
            return government.getDepartmentName();
        }
        return null;
    }

    private String getLDU(IStandardElements elements) {
        return elements.getPostalCode().substring(3);
    }

    private UnitDataSourceRecord getUnit(ICombinedRecord record) {
        ISuiteElements suite = record.getSuiteElements();
        if (suite == null) {
            return null;
        }
        String lowUnit = suite.getSuiteFromNumber();
        String highUnit = suite.getSuiteToNumber();
        if (lowUnit != null && highUnit != null) {
            return new UnitDataSourceRecord(lowUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        return null;
    }

    private static class Overlap {
        private ICombinedRecord m_record;
        private Range m_range;

        public Overlap(ICombinedRecord record, Range range) {
            this.m_record = record;
            this.m_range = range;
        }

        public ICombinedRecord getRecord() {
            return this.m_record;
        }

        public Range getOverlap() {
            return this.m_range;
        }
    }

    private static class Range {
        private ParsedNumber m_from;
        private ParsedNumber m_to;
        private int m_oddEvenBoth;

        public Range(ParsedNumber from, ParsedNumber to, int oddEvenBoth) {
            this.m_from = from;
            this.m_to = to;
            this.m_oddEvenBoth = oddEvenBoth;
        }

        public ParsedNumber getFrom() {
            return this.m_from;
        }

        public ParsedNumber getTo() {
            return this.m_to;
        }

        public int getOddEvenBoth() {
            return this.m_oddEvenBoth;
        }

        public Range getOverlap(Range that) {
            Range thatRange;
            Range thisRange;
            if (this.m_oddEvenBoth == that.m_oddEvenBoth) {
                thisRange = this;
                thatRange = that;
            } else if (this.m_oddEvenBoth == 0) {
                thatRange = that;
                thisRange = that.m_oddEvenBoth == 2 ? this.makeEvenRange(this) : this.makeOddRange(this);
            } else if (that.m_oddEvenBoth == 0) {
                thisRange = this;
                thatRange = this.m_oddEvenBoth == 2 ? this.makeEvenRange(that) : this.makeOddRange(that);
            } else {
                return null;
            }
            if (thisRange.m_from.compareTo((Object)thatRange.m_from) <= 0 && thisRange.m_to.compareTo((Object)thatRange.m_to) >= 0) {
                return new Range(thatRange.m_from, thatRange.m_to, thatRange.m_oddEvenBoth);
            }
            if (thatRange.m_from.compareTo((Object)thisRange.m_from) <= 0 && thatRange.m_to.compareTo((Object)thisRange.m_to) >= 0) {
                return new Range(thisRange.m_from, thisRange.m_to, thisRange.m_oddEvenBoth);
            }
            if (thisRange.m_from.compareTo((Object)thatRange.m_from) >= 0 && thisRange.m_from.compareTo((Object)thatRange.m_to) <= 0) {
                return new Range(thisRange.m_from, thatRange.m_to, thisRange.m_oddEvenBoth);
            }
            if (thisRange.m_to.compareTo((Object)thatRange.m_from) >= 0 && thisRange.m_to.compareTo((Object)thatRange.m_to) <= 0) {
                return new Range(thatRange.m_from, thisRange.m_to, thisRange.m_oddEvenBoth);
            }
            return null;
        }

        private Range makeEvenRange(Range that) {
            boolean bToEven;
            boolean bFromEven = that.m_from.isRangeOddEvenBoth() == 2;
            boolean bl = bToEven = that.m_to.isRangeOddEvenBoth() == 2;
            if (bFromEven && bToEven) {
                return new Range(that.m_from, that.m_to, 2);
            }
            if (!bFromEven && !bToEven) {
                return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), new ParsedNumber(that.m_to.getAddressNumber() - 1L), 2);
            }
            if (bFromEven) {
                return new Range(that.m_from, new ParsedNumber(that.m_to.getAddressNumber() - 1L), 2);
            }
            return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), that.m_to, 2);
        }

        private Range makeOddRange(Range that) {
            boolean bToOdd;
            boolean bFromOdd = that.m_from.isRangeOddEvenBoth() == 1;
            boolean bl = bToOdd = that.m_to.isRangeOddEvenBoth() == 1;
            if (bFromOdd && bToOdd) {
                return new Range(that.m_from, that.m_to, 1);
            }
            if (!bFromOdd && !bToOdd) {
                return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), new ParsedNumber(that.m_to.getAddressNumber() - 1L), 1);
            }
            if (bFromOdd) {
                return new Range(that.m_from, new ParsedNumber(that.m_to.getAddressNumber() - 1L), 1);
            }
            return new Range(new ParsedNumber(that.m_from.getAddressNumber() + 1L), that.m_to, 1);
        }
    }
}

