/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class SegmentDataSourceRecord
implements ICAN_SegmentDataSourceRecord,
IDataItem {
    private static final int LEFT_DA = 1;
    private static final int LEFT_CMA = 2;
    private static final int LEFT_CSD = 4;
    private static final int LEFT_CT = 8;
    private static final int RIGHT_DA = 16;
    private static final int RIGHT_CMA = 32;
    private static final int RIGHT_CSD = 64;
    private static final int RIGHT_CT = 128;
    private static final int LEFTCITY = 256;
    private static final int RIGHTCITY = 512;
    private static final int RANGES = 1024;
    private static final int LEFT_CSD_NAME = 2048;
    private static final int RIGHT_CSD_NAME = 4096;
    private static final int SEGMENT_ID = 8192;
    private static final int LEFT_CD = 16384;
    private static final int RIGHT_CD = 32768;
    private String m_leftDA;
    private String m_leftCMA;
    private String m_leftCSD;
    private String m_leftCT;
    private String m_leftCD;
    private String m_rightDA;
    private String m_rightCMA;
    private String m_rightCSD;
    private String m_rightCT;
    private String m_rightCD;
    private String m_FSA;
    private String m_province;
    private String m_leftCSDName;
    private String m_rightCSDName;
    private String m_leftAreaName3;
    private String m_rightAreaName3;
    private String m_segmentID;
    private ArrayList m_points;
    private ArrayList m_ranges;

    SegmentDataSourceRecord() {
    }

    public SegmentDataSourceRecord(SegmentDataSourceRecord record) {
        this(record, true);
    }

    public SegmentDataSourceRecord(SegmentDataSourceRecord record, boolean bKeepRanges) {
        this.m_leftDA = record.m_leftDA;
        this.m_leftCMA = record.m_leftCMA;
        this.m_leftCSD = record.m_leftCSD;
        this.m_leftCT = record.m_leftCT;
        this.m_leftCD = record.m_leftCD;
        this.m_rightDA = record.m_rightDA;
        this.m_rightCMA = record.m_rightCMA;
        this.m_rightCSD = record.m_rightCSD;
        this.m_rightCT = record.m_rightCT;
        this.m_rightCD = record.m_rightCD;
        this.m_FSA = record.m_FSA;
        this.m_province = record.m_province;
        this.m_leftCSDName = record.m_leftCSDName;
        this.m_rightCSDName = record.m_rightCSDName;
        this.m_leftAreaName3 = record.m_leftAreaName3;
        this.m_rightAreaName3 = record.m_rightAreaName3;
        this.m_segmentID = record.m_segmentID;
        if (record.m_points != null) {
            this.m_points = new ArrayList(record.m_points);
        }
        if (bKeepRanges && record.m_ranges != null) {
            this.m_ranges = new ArrayList(record.m_ranges.size());
            Iterator iterator = record.m_ranges.iterator();
            while (iterator.hasNext()) {
                this.m_ranges.add(new RangeDataSourceRecord((RangeDataSourceRecord)iterator.next()));
            }
        }
    }

    public SegmentDataSourceRecord(String province, String FSA, String municipality) {
        this.m_province = province;
        this.m_FSA = FSA;
        this.m_leftAreaName3 = municipality;
        this.m_rightAreaName3 = municipality;
    }

    public SegmentDataSourceRecord(ICAN_SegmentDataSourceRecord record, boolean bLeft, boolean bRight) throws DataSourceException {
        if (record.hasId()) {
            this.setID(record.getId());
        }
        if (record.getPoints() != null) {
            this.m_points = new ArrayList(record.getPoints());
        }
        if (bLeft && bRight) {
            ArrayList ranges;
            if (record.hasLeftDA() && this.stringExists(record.getLeftDA())) {
                this.m_leftDA = record.getLeftDA().trim();
            }
            if (record.hasLeftCMA() && this.stringExists(record.getLeftCMA())) {
                this.m_leftCMA = record.getLeftCMA().trim();
            }
            if (record.hasLeftCSD() && this.stringExists(record.getLeftCSD())) {
                this.m_leftCSD = record.getLeftCSD().trim();
            }
            if (record.hasLeftCT() && this.stringExists(record.getLeftCT())) {
                this.m_leftCT = record.getLeftCT().trim();
            }
            if (record.hasLeftCD() && this.stringExists(record.getLeftCD())) {
                this.m_leftCD = record.getLeftCD().trim();
            }
            if (record.hasRightDA() && this.stringExists(record.getRightDA())) {
                this.m_rightDA = record.getRightDA().trim();
            }
            if (record.hasRightCMA() && this.stringExists(record.getRightCMA())) {
                this.m_rightCMA = record.getRightCMA().trim();
            }
            if (record.hasRightCSD() && this.stringExists(record.getRightCSD())) {
                this.m_rightCSD = record.getRightCSD().trim();
            }
            if (record.hasRightCT() && this.stringExists(record.getRightCT())) {
                this.m_rightCT = record.getRightCT().trim();
            }
            if (record.hasRightCD() && this.stringExists(record.getRightCD())) {
                this.m_rightCD = record.getRightCD().trim();
            }
            if (record.hasLeftPostCode1() && this.stringExists(record.getLeftPostCode1())) {
                this.m_FSA = record.getLeftPostCode1().trim();
            } else if (record.hasRightPostCode1() && this.stringExists(record.getRightPostCode1())) {
                this.m_FSA = record.getRightPostCode1().trim();
            } else {
                throw new IllegalStateException("No left/right FSA.");
            }
            if (record.hasLeftAreaName1() && this.stringExists(record.getLeftAreaName1())) {
                this.m_province = record.getLeftAreaName1().trim();
            } else if (record.hasRightAreaName1() && this.stringExists(record.getRightAreaName1())) {
                this.m_province = record.getRightAreaName1().trim();
            } else {
                throw new IllegalStateException("No left/right province.");
            }
            if (record.hasLeftAreaName2() && this.stringExists(record.getLeftAreaName2())) {
                this.m_leftCSDName = record.getLeftAreaName2().trim().toUpperCase();
            }
            if (record.hasRightAreaName2() && this.stringExists(record.getRightAreaName2())) {
                this.m_rightCSDName = record.getRightAreaName2().trim().toUpperCase();
            }
            if (record.hasLeftAreaName3() && this.stringExists(record.getLeftAreaName3())) {
                this.m_leftAreaName3 = record.getLeftAreaName3().trim().toUpperCase();
            }
            if (record.hasRightAreaName3() && this.stringExists(record.getRightAreaName3())) {
                this.m_rightAreaName3 = record.getRightAreaName3().trim().toUpperCase();
            }
            if ((ranges = record.getRanges()) != null) {
                this.m_ranges = new ArrayList(ranges.size());
                for (IRangeDataSourceRecord range : ranges) {
                    if (!this.isValidRange(range)) continue;
                    this.m_ranges.add(new RangeDataSourceRecord(range));
                }
                if (this.m_ranges.isEmpty()) {
                    this.m_ranges = null;
                }
            }
        } else if (bLeft) {
            ArrayList ranges;
            if (record.hasLeftDA() && this.stringExists(record.getLeftDA())) {
                this.m_leftDA = record.getLeftDA().trim();
            }
            if (record.hasLeftCMA() && this.stringExists(record.getLeftCMA())) {
                this.m_leftCMA = record.getLeftCMA().trim();
            }
            if (record.hasLeftCSD() && this.stringExists(record.getLeftCSD())) {
                this.m_leftCSD = record.getLeftCSD().trim();
            }
            if (record.hasLeftCT() && this.stringExists(record.getLeftCT())) {
                this.m_leftCT = record.getLeftCT().trim();
            }
            if (record.hasLeftCD() && this.stringExists(record.getLeftCD())) {
                this.m_leftCD = record.getLeftCD().trim();
            }
            if (!record.hasLeftPostCode1() || !this.stringExists(record.getLeftPostCode1())) {
                throw new IllegalStateException("No left FSA.");
            }
            this.m_FSA = record.getLeftPostCode1().trim();
            if (!record.hasLeftAreaName1() || !this.stringExists(record.getLeftAreaName1())) {
                throw new IllegalStateException("No left province.");
            }
            this.m_province = record.getLeftAreaName1().trim();
            if (record.hasLeftAreaName2() && this.stringExists(record.getLeftAreaName2())) {
                this.m_leftCSDName = record.getLeftAreaName2().trim().toUpperCase();
            }
            if (record.hasLeftAreaName3() && this.stringExists(record.getLeftAreaName3())) {
                this.m_leftAreaName3 = record.getLeftAreaName3().trim().toUpperCase();
            }
            if ((ranges = record.getRanges()) != null) {
                this.m_ranges = new ArrayList();
                for (IRangeDataSourceRecord range : ranges) {
                    if (!range.isLeft() || !this.isValidRange(range)) continue;
                    this.m_ranges.add(new RangeDataSourceRecord(range));
                }
                if (this.m_ranges.isEmpty()) {
                    this.m_ranges = null;
                }
            }
        } else if (bRight) {
            ArrayList ranges;
            if (record.hasRightDA() && this.stringExists(record.getRightDA())) {
                this.m_rightDA = record.getRightDA().trim();
            }
            if (record.hasRightCMA() && this.stringExists(record.getRightCMA())) {
                this.m_rightCMA = record.getRightCMA().trim();
            }
            if (record.hasRightCSD() && this.stringExists(record.getRightCSD())) {
                this.m_rightCSD = record.getRightCSD().trim();
            }
            if (record.hasRightCT() && this.stringExists(record.getRightCT())) {
                this.m_rightCT = record.getRightCT().trim();
            }
            if (record.hasRightCD() && this.stringExists(record.getRightCD())) {
                this.m_rightCD = record.getRightCD().trim();
            }
            if (!record.hasRightPostCode1() || !this.stringExists(record.getRightPostCode1())) {
                throw new IllegalStateException("No right FSA.");
            }
            this.m_FSA = record.getRightPostCode1().trim();
            if (!record.hasRightAreaName1() || !this.stringExists(record.getRightAreaName1())) {
                throw new IllegalStateException("No right province.");
            }
            this.m_province = record.getRightAreaName1().trim();
            if (record.hasRightAreaName2() && this.stringExists(record.getRightAreaName2())) {
                this.m_rightCSDName = record.getRightAreaName2().trim().toUpperCase();
            }
            if (record.hasRightAreaName3() && this.stringExists(record.getRightAreaName3())) {
                this.m_rightAreaName3 = record.getRightAreaName3().trim().toUpperCase();
            }
            if ((ranges = record.getRanges()) != null) {
                this.m_ranges = new ArrayList();
                for (IRangeDataSourceRecord range : ranges) {
                    if (range.isLeft() || !this.isValidRange(range)) continue;
                    this.m_ranges.add(new RangeDataSourceRecord(range));
                }
                if (this.m_ranges.isEmpty()) {
                    this.m_ranges = null;
                }
            }
        } else {
            throw new IllegalStateException("Creating segment with no side data.");
        }
    }

    private boolean isValidRange(IRangeDataSourceRecord range) throws DataSourceException {
        if (!range.hasFrom() || !range.hasTo()) {
            return false;
        }
        if (!this.stringExists(range.getFrom()) || !this.stringExists(range.getTo())) {
            return false;
        }
        return !"0".equals(range.getFrom()) || !"0".equals(range.getTo());
    }

    @Override
    public boolean hasLeftDA() {
        return this.m_leftDA != null;
    }

    @Override
    public String getLeftDA() {
        return this.m_leftDA;
    }

    @Override
    public boolean hasLeftCMA() {
        return this.m_leftCMA != null;
    }

    @Override
    public String getLeftCMA() {
        return this.m_leftCMA;
    }

    @Override
    public boolean hasLeftCSD() {
        return this.m_leftCSD != null;
    }

    @Override
    public String getLeftCSD() {
        return this.m_leftCSD;
    }

    @Override
    public boolean hasLeftCT() {
        return this.m_leftCT != null;
    }

    @Override
    public String getLeftCT() {
        return this.m_leftCT;
    }

    @Override
    public boolean hasRightDA() {
        return this.m_rightDA != null;
    }

    @Override
    public String getRightDA() {
        return this.m_rightDA;
    }

    @Override
    public boolean hasRightCMA() {
        return this.m_rightCMA != null;
    }

    @Override
    public String getRightCMA() {
        return this.m_rightCMA;
    }

    @Override
    public boolean hasRightCSD() {
        return this.m_rightCSD != null;
    }

    @Override
    public String getRightCSD() {
        return this.m_rightCSD;
    }

    @Override
    public boolean hasRightCT() {
        return this.m_rightCT != null;
    }

    @Override
    public String getRightCT() {
        return this.m_rightCT;
    }

    @Override
    public boolean hasLeftCD() {
        return this.m_leftCD != null;
    }

    @Override
    public String getLeftCD() {
        return this.m_leftCD;
    }

    @Override
    public boolean hasRightCD() {
        return this.m_rightCD != null;
    }

    @Override
    public String getRightCD() {
        return this.m_rightCD;
    }

    public boolean hasLeftPostCode1() {
        return true;
    }

    public String getLeftPostCode1() {
        return this.m_FSA;
    }

    public boolean hasRightPostCode1() {
        return true;
    }

    public String getRightPostCode1() {
        return this.m_FSA;
    }

    public boolean hasLeftPostCode2() {
        return false;
    }

    public String getLeftPostCode2() {
        return null;
    }

    public boolean hasRightPostCode2() {
        return false;
    }

    public String getRightPostCode2() {
        return null;
    }

    public boolean hasLeftAreaName1() {
        return true;
    }

    public String getLeftAreaName1() {
        return this.m_province;
    }

    public boolean hasLeftAreaName2() {
        return this.m_leftCSDName != null;
    }

    public String getLeftAreaName2() {
        return this.m_leftCSDName;
    }

    public boolean hasLeftAreaName3() {
        return this.m_leftAreaName3 != null;
    }

    public String getLeftAreaName3() {
        return this.m_leftAreaName3;
    }

    public boolean hasLeftAreaName4() {
        return false;
    }

    public String getLeftAreaName4() {
        return null;
    }

    public boolean hasRightAreaName1() {
        return true;
    }

    public String getRightAreaName1() {
        return this.m_province;
    }

    public boolean hasRightAreaName2() {
        return this.m_rightCSDName != null;
    }

    public String getRightAreaName2() {
        return this.m_rightCSDName;
    }

    public boolean hasRightAreaName3() {
        return this.m_rightAreaName3 != null;
    }

    public String getRightAreaName3() {
        return this.m_rightAreaName3;
    }

    public boolean hasRightAreaName4() {
        return false;
    }

    public String getRightAreaName4() {
        return null;
    }

    public boolean hasId() {
        return this.m_segmentID != null;
    }

    public String getId() {
        return this.m_segmentID;
    }

    private void setID(String id) {
        if (!StringUtilities.isEmpty((String)id)) {
            int decimalIndex = id.indexOf(46);
            if (decimalIndex > 0 && id.indexOf(69, decimalIndex) > decimalIndex) {
                double tempID = Double.parseDouble(id);
                this.m_segmentID = String.valueOf((long)tempID);
            } else {
                this.m_segmentID = id;
            }
        }
    }

    public ArrayList getPoints() {
        return this.m_points;
    }

    public void addRange(RangeDataSourceRecord range) {
        if (this.m_ranges == null) {
            this.m_ranges = new ArrayList();
        }
        this.m_ranges.add(range);
    }

    public ArrayList getRanges() {
        return this.m_ranges;
    }

    public void write(DataOutput out) throws IOException {
        int code = 0;
        code |= this.m_leftDA != null ? 1 : 0;
        code |= this.m_leftCMA != null ? 2 : 0;
        code |= this.m_leftCSD != null ? 4 : 0;
        code |= this.m_leftCT != null ? 8 : 0;
        code |= this.m_rightDA != null ? 16 : 0;
        code |= this.m_rightCMA != null ? 32 : 0;
        code |= this.m_rightCSD != null ? 64 : 0;
        code |= this.m_rightCT != null ? 128 : 0;
        code |= this.m_leftAreaName3 != null ? 256 : 0;
        code |= this.m_rightAreaName3 != null ? 512 : 0;
        code |= this.m_ranges != null ? 1024 : 0;
        code |= this.m_leftCSDName != null ? 2048 : 0;
        code |= this.m_rightCSDName != null ? 4096 : 0;
        code |= this.m_segmentID != null ? 8192 : 0;
        code |= this.m_leftCD != null ? 16384 : 0;
        out.writeShort(code |= this.m_rightCD != null ? 32768 : 0);
        if ((code & 1) != 0) {
            out.writeUTF(this.m_leftDA);
        }
        if ((code & 2) != 0) {
            out.writeUTF(this.m_leftCMA);
        }
        if ((code & 4) != 0) {
            out.writeUTF(this.m_leftCSD);
        }
        if ((code & 8) != 0) {
            out.writeUTF(this.m_leftCT);
        }
        if ((code & 0x10) != 0) {
            out.writeUTF(this.m_rightDA);
        }
        if ((code & 0x20) != 0) {
            out.writeUTF(this.m_rightCMA);
        }
        if ((code & 0x40) != 0) {
            out.writeUTF(this.m_rightCSD);
        }
        if ((code & 0x80) != 0) {
            out.writeUTF(this.m_rightCT);
        }
        if ((code & 0x4000) != 0) {
            out.writeUTF(this.m_leftCD);
        }
        if ((code & 0x8000) != 0) {
            out.writeUTF(this.m_rightCD);
        }
        if ((code & 0x800) != 0) {
            out.writeUTF(this.m_leftCSDName);
        }
        if ((code & 0x1000) != 0) {
            out.writeUTF(this.m_rightCSDName);
        }
        if ((code & 0x100) != 0) {
            out.writeUTF(this.m_leftAreaName3);
        }
        if ((code & 0x200) != 0) {
            out.writeUTF(this.m_rightAreaName3);
        }
        if ((code & 0x2000) != 0) {
            out.writeUTF(this.m_segmentID);
        }
        out.writeUTF(this.m_FSA);
        out.writeUTF(this.m_province);
        out.writeShort(this.m_points != null ? this.m_points.size() : 0);
        if (this.m_points != null) {
            for (DirectPosition point : this.m_points) {
                out.writeDouble(point.getX());
                out.writeDouble(point.getY());
            }
        }
        if ((code & 0x400) != 0) {
            out.writeShort(this.m_ranges.size());
            for (RangeDataSourceRecord range : this.m_ranges) {
                range.write(out);
            }
        }
    }

    public void read(DataInput in) throws IOException {
        int code = in.readUnsignedShort();
        if ((code & 1) != 0) {
            this.m_leftDA = in.readUTF();
        }
        if ((code & 2) != 0) {
            this.m_leftCMA = in.readUTF();
        }
        if ((code & 4) != 0) {
            this.m_leftCSD = in.readUTF();
        }
        if ((code & 8) != 0) {
            this.m_leftCT = in.readUTF();
        }
        if ((code & 0x10) != 0) {
            this.m_rightDA = in.readUTF();
        }
        if ((code & 0x20) != 0) {
            this.m_rightCMA = in.readUTF();
        }
        if ((code & 0x40) != 0) {
            this.m_rightCSD = in.readUTF();
        }
        if ((code & 0x80) != 0) {
            this.m_rightCT = in.readUTF();
        }
        if ((code & 0x4000) != 0) {
            this.m_leftCD = in.readUTF();
        }
        if ((code & 0x8000) != 0) {
            this.m_rightCD = in.readUTF();
        }
        if ((code & 0x800) != 0) {
            this.m_leftCSDName = in.readUTF();
        }
        if ((code & 0x1000) != 0) {
            this.m_rightCSDName = in.readUTF();
        }
        if ((code & 0x100) != 0) {
            this.m_leftAreaName3 = in.readUTF();
        }
        if ((code & 0x200) != 0) {
            this.m_rightAreaName3 = in.readUTF();
        }
        if ((code & 0x2000) != 0) {
            this.m_segmentID = in.readUTF();
        }
        this.m_FSA = in.readUTF();
        this.m_province = in.readUTF();
        int pointCount = in.readUnsignedShort();
        if (pointCount > 0) {
            this.m_points = new ArrayList(pointCount);
            for (int i = 0; i < pointCount; ++i) {
                this.m_points.add(new DirectPosition(in.readDouble(), in.readDouble()));
            }
        }
        if ((code & 0x400) != 0) {
            int rangeCount = in.readUnsignedShort();
            this.m_ranges = new ArrayList(rangeCount);
            for (int i = 0; i < rangeCount; ++i) {
                RangeDataSourceRecord range = new RangeDataSourceRecord();
                range.read(in);
                this.m_ranges.add(range);
            }
        }
    }

    public void reverse() {
        String temp = this.m_leftDA;
        this.m_leftDA = this.m_rightDA;
        this.m_rightDA = temp;
        temp = this.m_leftCMA;
        this.m_leftCMA = this.m_rightCMA;
        this.m_rightCMA = temp;
        temp = this.m_leftCSD;
        this.m_leftCSD = this.m_rightCSD;
        this.m_rightCSD = temp;
        temp = this.m_leftCT;
        this.m_leftCT = this.m_rightCT;
        this.m_rightCT = temp;
        temp = this.m_leftCD;
        this.m_leftCD = this.m_rightCD;
        this.m_rightCD = temp;
        temp = this.m_leftCSDName;
        this.m_leftCSDName = this.m_rightCSDName;
        this.m_rightCSDName = temp;
        temp = this.m_leftAreaName3;
        this.m_leftAreaName3 = this.m_rightAreaName3;
        this.m_rightAreaName3 = temp;
        if (this.m_points != null) {
            Collections.reverse(this.m_points);
        }
        if (this.m_ranges != null) {
            Iterator iterator = this.m_ranges.iterator();
            while (iterator.hasNext()) {
                ((RangeDataSourceRecord)iterator.next()).reverse();
            }
        }
    }

    private boolean stringExists(String str) {
        return str != null && str.trim().length() > 0;
    }
}

