/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.IStreetNameReplacementProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetReplacementRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class StreetNameReplacementProvider
implements IStreetNameReplacementProvider {
    private Map m_entries;

    public StreetNameReplacementProvider(String replacementFile) throws IOException {
        if (replacementFile == null) {
            this.m_entries = new TreeMap();
        } else {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(replacementFile));
            this.m_entries = new TreeMap();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StreetReplacementRecord record = null;
                String street = null;
                StringWithTokens tokens = new StringWithTokens(line.toUpperCase(), ";");
                if (tokens.size() < 2 || tokens.size() > 4) {
                    DataCreationLogger.getLogger().logError("incorrect token count in street replacement file: " + tokens.size() + " contents: " + line);
                    continue;
                }
                if (tokens.size() == 2) {
                    street = tokens.getToken(0);
                    record = new StreetReplacementRecord(tokens.getToken(1), true, null);
                } else if (tokens.size() == 3) {
                    street = tokens.getToken(0);
                    record = new StreetReplacementRecord(tokens.getToken(1), "A".equals(tokens.getToken(2)), null);
                } else if (tokens.size() == 4) {
                    street = tokens.getToken(0);
                    record = new StreetReplacementRecord(tokens.getToken(1), "A".equals(tokens.getToken(2)), tokens.getToken(3));
                }
                Collection previous = (Collection)this.m_entries.get(street);
                if (previous != null) {
                    previous.add(record);
                    continue;
                }
                LinkedList<StreetReplacementRecord> c = new LinkedList<StreetReplacementRecord>();
                c.add(record);
                this.m_entries.put(street, c);
            }
        }
    }

    @Override
    public Collection getReplacementStreets(String streetName, String FSA) {
        Collection c = (Collection)this.m_entries.get(streetName.toUpperCase());
        if (c == null) {
            return null;
        }
        LinkedList returnC = new LinkedList();
        returnC.addAll(c);
        Iterator iterator = returnC.iterator();
        while (iterator.hasNext()) {
            StreetReplacementRecord record = (StreetReplacementRecord)iterator.next();
            if (record.applysToFSA(FSA)) continue;
            iterator.remove();
        }
        if (returnC.isEmpty()) {
            return null;
        }
        return returnC;
    }
}

