/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text;

import com.mapinfo.mapmarker.CAN.dp.merge.ICAN_UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UnitDataSourceRecord
implements ICAN_UnitDataSourceRecord,
IDataItem {
    private static final int LOW = 1;
    private static final int HIGH = 2;
    private static final int PLACENAME = 4;
    private static final int LDU = 8;
    private static final int PBKEY = 16;
    private String m_low;
    private String m_high;
    private String m_placeName;
    private String pbkey;
    private String m_LDU;

    UnitDataSourceRecord() {
    }

    UnitDataSourceRecord(IUnitDataSourceRecord unit) throws DataSourceException {
        if (unit.hasLowUnit()) {
            this.m_low = unit.getLowUnit();
        }
        if (unit.hasHighUnit()) {
            this.m_high = unit.getHighUnit();
        }
        if (unit.hasPlaceName()) {
            this.m_placeName = unit.getPlaceName();
        }
        if (unit instanceof UnitDataSourceRecord) {
            this.pbkey = ((UnitDataSourceRecord)unit).getPbkey();
        }
    }

    public UnitDataSourceRecord(String lowUnit, String highUnit, String placeName, String LDU, String pbkey) {
        this.m_low = lowUnit;
        this.m_high = highUnit;
        this.m_placeName = placeName;
        this.m_LDU = LDU;
        this.pbkey = pbkey;
    }

    public void setLowUnit(String low) {
        this.m_low = low;
    }

    public boolean hasLowUnit() {
        return this.m_low != null;
    }

    public String getLowUnit() {
        return this.m_low;
    }

    public void setHighUnit(String high) {
        this.m_high = high;
    }

    public boolean hasHighUnit() {
        return this.m_high != null;
    }

    public String getHighUnit() {
        return this.m_high;
    }

    public boolean hasUnitType() {
        return false;
    }

    public String getUnitType() {
        return null;
    }

    public boolean hasPlaceName() {
        return this.m_placeName != null;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    @Override
    public boolean hasLDU() {
        return this.m_LDU != null;
    }

    @Override
    public String getLDU() {
        return this.m_LDU;
    }

    @Override
    public String getPbkey() {
        return this.pbkey;
    }

    @Override
    public boolean hasPbkey() {
        return this.pbkey != null && !this.pbkey.isEmpty();
    }

    public void setPbkey(String pbkey) {
        pbkey = this.pbkey;
    }

    public void blankLDU() {
        this.m_LDU = null;
    }

    public void write(DataOutput out) throws IOException {
        int code = 0;
        code |= this.m_low != null ? 1 : 0;
        code |= this.m_high != null ? 2 : 0;
        code |= this.m_placeName != null ? 4 : 0;
        code |= this.m_LDU != null ? 8 : 0;
        if ((code |= this.pbkey != null ? 16 : 0) == 0) {
            DataCreationLogger.getLogger().logError("WARNING: unit has no fields populated.");
        }
        out.writeByte(code);
        if ((code & 1) != 0) {
            out.writeUTF(this.m_low);
        }
        if ((code & 2) != 0) {
            out.writeUTF(this.m_high);
        }
        if ((code & 4) != 0) {
            out.writeUTF(this.m_placeName);
        }
        if ((code & 8) != 0) {
            out.writeUTF(this.m_LDU);
        }
        if ((code & 0x10) != 0) {
            out.writeUTF(this.pbkey);
        }
    }

    public void read(DataInput in) throws IOException {
        byte code = in.readByte();
        if ((code & 1) != 0) {
            this.m_low = in.readUTF();
        }
        if ((code & 2) != 0) {
            this.m_high = in.readUTF();
        }
        if ((code & 4) != 0) {
            this.m_placeName = in.readUTF();
        }
        if ((code & 8) != 0) {
            this.m_LDU = in.readUTF();
        }
        if ((code & 0x10) != 0) {
            this.pbkey = in.readUTF();
        }
    }
}

