/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractCloseMatchOutputer
implements ICloseMatchOutputer {
    private RandomAccessDataStream m_stream;
    private int m_recordCount;
    private int m_closeMatchCount;
    private int m_noMatchCount;
    private int m_unMergedCount;
    private Map m_rulesApplied = new TreeMap();

    protected AbstractCloseMatchOutputer() {
    }

    @Override
    public void open(String outputPath, String province) throws IOException {
        this.m_stream = new RandomAccessDataStream(new File(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"tdr")));
        this.m_recordCount = this.m_stream.readInt();
        DataCreationLogger.getLogger().logStatus("Initial record count: " + this.m_recordCount);
        this.m_stream.seek(this.m_stream.length());
    }

    @Override
    public void close() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.seek(0L);
            this.m_stream.writeInt(this.m_recordCount);
            this.m_stream.close();
            DataCreationLogger.getLogger().logStatus("Total output records: " + this.m_recordCount);
            DataCreationLogger.getLogger().logStatus("Total closeMatch output: " + this.m_closeMatchCount);
            DataCreationLogger.getLogger().logStatus("Total noMatched output: " + this.m_noMatchCount);
            DataCreationLogger.getLogger().logStatus("Total unMerged output: " + this.m_unMergedCount);
            DataCreationLogger.getLogger().logStatus("\n\nRules applied:\n");
            Set rulesSet = this.m_rulesApplied.entrySet();
            for (Map.Entry entry : rulesSet) {
                DataCreationLogger.getLogger().logStatus("\trule # " + entry.getKey() + "\tcount: " + entry.getValue());
            }
        }
    }

    @Override
    public void output(ICloseMatchOutput output, int ruleNumber) throws DataSourceException {
        this.incrementRuleCount(ruleNumber);
        this.m_closeMatchCount += output.getCloseMatches().size();
        this.m_noMatchCount += output.getNoMatches().size();
        try {
            this.output(output.getCloseMatches());
            this.output(output.getNoMatches());
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }

    protected Collection makeUnMatchedRecords(SingleSACMergeInputRecord record) {
        LinkedList<StreetDataSourceRecord> output = new LinkedList<StreetDataSourceRecord>();
        for (SegmentDataSourceRecord segment : record.getSegments()) {
            Iterator namesIterator = record.getStreetNames().iterator();
            while (namesIterator.hasNext()) {
                StreetDataSourceRecord street = new StreetDataSourceRecord((String)namesIterator.next(), record.getSAC(), segment);
                output.add(street);
            }
        }
        this.m_unMergedCount += output.size();
        return output;
    }

    protected int getUnMergedCount() {
        return this.m_unMergedCount;
    }

    protected void output(Collection streetRecords) throws IOException {
        this.m_recordCount += streetRecords.size();
        this.output(streetRecords, (DataOutput)this.m_stream);
    }

    protected void output(Collection streetRecords, DataOutput stream) throws IOException {
        for (StreetDataSourceRecord street : streetRecords) {
            street.write(stream);
        }
    }

    private void incrementRuleCount(int ruleNumber) {
        Integer rule = new Integer(ruleNumber);
        IntHolder count = (IntHolder)this.m_rulesApplied.get(rule);
        if (count == null) {
            this.m_rulesApplied.put(rule, new IntHolder(1));
        } else {
            count.incrementValue();
        }
    }

    private static class IntHolder {
        private int m_value;

        public IntHolder(int value) {
            this.m_value = value;
        }

        public int getValue() {
            return this.m_value;
        }

        public void incrementValue() {
            ++this.m_value;
        }

        public String toString() {
            return String.valueOf(this.m_value);
        }
    }
}

