/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchHelper;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchInputSource;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchOutput;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.ICloseMatchRule;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.CloseMatchInputSource;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.CloseMatchMergeSource;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public abstract class AbstractCloseMatchProcessor {
    protected String m_province;
    protected String m_outputPath;
    protected String m_CANPostPath;
    protected String m_combinedPath;
    private PrintStream[] m_closeMatchLogs;
    private ICloseMatchInputSource m_source;
    private AccentsLookup m_accentsLookup;
    private ICloseMatchMergeSource m_mergeSource;
    private IMergeRecorder m_recorder;

    protected AbstractCloseMatchProcessor(String province, String outputPath, String inputSource, String CANPostPath, String combinedPath) throws DataSourceException {
        this.m_province = province;
        this.m_outputPath = outputPath;
        this.m_CANPostPath = CANPostPath;
        this.m_combinedPath = combinedPath;
        this.setUpLoggers();
        this.m_closeMatchLogs = new PrintStream[this.getRules().length];
        this.m_source = new CloseMatchInputSource();
        ((CloseMatchInputSource)this.m_source).open(inputSource);
        this.m_accentsLookup = TextAccentsLoader.loadLookup(CANPostPath);
        this.m_mergeSource = new CloseMatchMergeSource(this.m_accentsLookup, this.getPostalRecordFilter(), this.getAllowRuralFSAs());
        ((CloseMatchMergeSource)this.m_mergeSource).open(combinedPath, province);
        this.m_recorder = new MergeRecorder();
        try {
            ((MergeRecorder)this.m_recorder).open(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"idx"));
        }
        catch (IndexAccessException IAEx) {
            throw new DataSourceException(10, (Throwable)IAEx);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
    }

    protected boolean getAllowRuralFSAs() {
        return true;
    }

    protected abstract IPostalRecordFilter getPostalRecordFilter() throws DataSourceException;

    protected AccentsLookup getAccentsLookup() {
        return this.m_accentsLookup;
    }

    protected ICloseMatchMergeSource getMergeSource() {
        return this.m_mergeSource;
    }

    protected IMergeRecorder getRecorder() {
        return this.m_recorder;
    }

    protected abstract ICloseMatchRule[] getRules();

    protected abstract String getLogBase();

    protected abstract ICloseMatchHelper getHelper() throws DataSourceException;

    protected abstract ICloseMatchOutputer getOutputer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() throws DataSourceException {
        ICloseMatchOutputer outputer = this.getOutputer();
        try {
            outputer.open(this.m_outputPath, this.m_province);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        ICloseMatchRule[] rules = this.getRules();
        ICloseMatchHelper helper = this.getHelper();
        try {
            SingleSACMergeInputRecord record;
            while ((record = this.m_source.getNextCloseMatchRecord()) != null) {
                boolean bFoundMerge = false;
                for (int i = 0; i < rules.length; ++i) {
                    ICloseMatchOutput output = rules[i].apply(record, helper);
                    if (output == null) continue;
                    bFoundMerge = true;
                    this.logCloseMatches(i, record, output);
                    outputer.output(output, i);
                    break;
                }
                if (bFoundMerge) continue;
                outputer.output(record);
            }
        }
        finally {
            try {
                outputer.close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                throw new DataSourceException("Unabel to close close match outputer", (Throwable)IOEx);
            }
            try {
                ((MergeRecorder)this.m_recorder).close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                throw new DataSourceException("Unable to close the merge recorder", (Throwable)IOEx);
            }
            if (this.m_closeMatchLogs != null) {
                for (int i = 0; i < this.m_closeMatchLogs.length; ++i) {
                    if (this.m_closeMatchLogs[i] == null) continue;
                    this.m_closeMatchLogs[i].close();
                }
            }
        }
    }

    private void setUpLoggers() {
        String base = StringUtilities.appendToPath((String)this.m_outputPath, (String)(this.m_province + this.getLogBase()), null);
        DataCreationLogger.getLogger().setStatusLog(base + ".log", false);
        DataCreationLogger.getLogger().setErrorLog(base + ".err", false);
        DataCreationLogger.getLogger().setInternalErrorLog(base + ".irr", false);
    }

    private void logCloseMatches(int rule, SingleSACMergeInputRecord input, ICloseMatchOutput output) {
        if (this.m_closeMatchLogs[rule] == null) {
            this.m_closeMatchLogs[rule] = this.getLogStream(rule, this.m_outputPath, this.m_province);
        }
        PrintStream stream = this.m_closeMatchLogs[rule];
        stream.println("inputNames:");
        Iterator names = input.getStreetNames().iterator();
        while (names.hasNext()) {
            stream.println("\t" + names.next());
        }
        stream.println("outputNames:");
        for (StreetDataSourceRecord record : output.getCloseMatches()) {
            stream.println("\t" + record.getMainAddress());
        }
        stream.println("\n");
    }

    private PrintStream getLogStream(int rule, String outputPath, String province) {
        try {
            PrintStream ps = new PrintStream((OutputStream)new NIOOutputStream(new File(StringUtilities.appendToPath((String)outputPath, (String)(province + this.getLogBase() + '_' + rule), (String)"log"))));
            ps.println(this.getRules()[rule].getClass().getName());
            ps.println();
            return ps;
        }
        catch (IOException IOEx) {
            return null;
        }
    }
}

