/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchInputSource;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public class CloseMatchInputSource
implements ICloseMatchInputSource {
    private DataInputStream m_stream;
    private int m_recordNumber;

    public void open(String closeMatchInputFile) throws DataSourceException {
        int blockCount;
        try {
            this.m_stream = new DataInputStream(new BufferedInputStream(new FileInputStream(closeMatchInputFile)));
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        try {
            blockCount = this.m_stream.readInt();
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
        DataCreationLogger.getLogger().logStatus("Opened closematch source: " + closeMatchInputFile);
        DataCreationLogger.getLogger().logStatus("\t" + blockCount + " blocks.");
    }

    @Override
    public SingleSACMergeInputRecord getNextCloseMatchRecord() throws DataSourceException {
        ++this.m_recordNumber;
        try {
            int recordCount = this.m_stream.readUnsignedByte();
            String ID = this.m_stream.readUTF();
            SourceRecordDataIDProvider.getProvider().setCurrentID(ID);
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            LinkedList segments = new LinkedList();
            int SAC = -1;
            String FSA = null;
            for (int i = 0; i < recordCount; ++i) {
                StreetDataSourceRecord street = new StreetDataSourceRecord();
                street.read(this.m_stream);
                names.add(street.getMainAddress());
                SegmentDataSourceRecord segment = (SegmentDataSourceRecord)street.getSegment();
                this.addSegment(segments, segment);
                if (i != 0) continue;
                SAC = street.getLeftSAC();
                FSA = street.getSegment().getLeftPostCode1();
            }
            return new SingleSACMergeInputRecord(SAC, FSA, names, segments);
        }
        catch (EOFException EOF) {
            return null;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }

    private boolean test(SegmentDataSourceRecord segment1, SegmentDataSourceRecord segment2) {
        Iterator points1 = segment1.getPoints().iterator();
        Iterator points2 = segment2.getPoints().iterator();
        while (points1.hasNext() && points2.hasNext()) {
            if (points1.next().equals(points2.next())) continue;
            return false;
        }
        return !points1.hasNext() && !points2.hasNext();
    }

    private void addSegment(Collection segments, SegmentDataSourceRecord segment) {
        if (segments.isEmpty()) {
            segments.add(segment);
        } else {
            Iterator iterator = segments.iterator();
            while (iterator.hasNext()) {
                if (!this.test((SegmentDataSourceRecord)iterator.next(), segment)) continue;
                return;
            }
            segments.add(segment);
        }
    }
}

