/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeAccessIndex;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeKey;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.MergeSoundexKey;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.SoundexMergeAccessIndex;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.close.UnsupportedCloseMatchModeException;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.text.CombinedRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CloseMatchMergeSource
implements ICloseMatchMergeSource {
    private SeekableDataInputStream m_dataStream;
    private MapMarkerMultiLevelReadOnlyIndexFile[] m_indexes;
    private static final Set m_frenchEnglishTypes;
    private static final Set unTranslatableDirs;
    private static final Map m_dirTranslations;
    private static final double SOUNDEX_MAINADDRESS_THRESHOLD = 0.75;
    private static final double SCORE_NO_ARTICLES_THRESHOLD = 0.85;
    private static final int SUPPORTED_SEARCH_MODES = 6;
    private StreetNameBuilder m_streetNameBuilder;
    private boolean[] m_modesSupported;
    private int m_currentMode = 0;
    private int m_currentMod;
    private boolean m_bUniqueOutputStreets;
    private IPostalRecordFilter m_filter;
    private boolean m_bPreFilterRecords;
    private boolean m_bAllowRuralFSAs;

    public CloseMatchMergeSource(AccentsLookup accents, IPostalRecordFilter filter) {
        this(accents, filter, true);
    }

    public CloseMatchMergeSource(AccentsLookup accents, IPostalRecordFilter filter, boolean bAllowRuralFSAs) {
        this.m_streetNameBuilder = new StreetNameBuilder(accents);
        this.m_filter = filter;
        this.m_bAllowRuralFSAs = bAllowRuralFSAs;
    }

    public void open(String path, String province) throws DataSourceException {
        String dataPath = StringUtilities.appendToPath((String)path, (String)province, (String)"tdr");
        try {
            this.m_dataStream = new SeekableDataInputStream(new File(dataPath));
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, "Unable to open merge data file: " + dataPath);
        }
        this.openIndexes(path, province);
        for (int i = 0; i < this.m_modesSupported.length; ++i) {
            DataCreationLogger.getLogger().logStatus("Mode " + i + " available? " + this.m_modesSupported[i]);
        }
    }

    private void openIndexes(String path, String province) throws DataSourceException {
        this.m_indexes = new MapMarkerMultiLevelReadOnlyIndexFile[6];
        this.m_modesSupported = new boolean[6];
        this.m_indexes[0] = new CollatorMergeAccessIndex();
        try {
            this.m_indexes[0].open(StringUtilities.appendToPath((String)path, (String)province, (String)"mdx"));
            this.m_modesSupported[0] = true;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        this.m_indexes[1] = new CollatorMergeAccessIndex();
        try {
            this.m_indexes[1].open(StringUtilities.appendToPath((String)path, (String)province, (String)"nax"));
            this.m_modesSupported[1] = true;
        }
        catch (FileNotFoundException FNFEx) {
            this.m_modesSupported[1] = false;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        this.m_indexes[2] = new SoundexMergeAccessIndex();
        try {
            this.m_indexes[2].open(StringUtilities.appendToPath((String)path, (String)province, (String)"sdx"));
            this.m_modesSupported[2] = true;
        }
        catch (FileNotFoundException FNFEx) {
            this.m_modesSupported[2] = false;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        this.m_indexes[3] = new CollatorMergeAccessIndex();
        try {
            this.m_indexes[3].open(StringUtilities.appendToPath((String)path, (String)province, (String)"ndx"));
            this.m_modesSupported[3] = true;
        }
        catch (FileNotFoundException FNFEx) {
            this.m_modesSupported[3] = false;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
        this.m_indexes[4] = this.m_indexes[2];
        this.m_modesSupported[4] = this.m_modesSupported[2];
        this.m_indexes[5] = new CollatorMergeAccessIndex();
        try {
            this.m_indexes[5].open(StringUtilities.appendToPath((String)path, (String)province, (String)"ntx"));
            this.m_modesSupported[5] = true;
        }
        catch (FileNotFoundException FNFEx) {
            this.m_modesSupported[5] = false;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
    }

    @Override
    public void setMode(int searchMode, int modHash, boolean bPreFilterRecords) throws UnsupportedCloseMatchModeException {
        if (!this.m_modesSupported[searchMode]) {
            throw new UnsupportedCloseMatchModeException();
        }
        this.m_currentMode = searchMode;
        this.m_currentMod = modHash;
        this.m_bUniqueOutputStreets = false;
        this.m_bPreFilterRecords = bPreFilterRecords;
        if (this.m_bPreFilterRecords && this.m_filter == null) {
            throw new UnsupportedCloseMatchModeException();
        }
    }

    @Override
    public void setMode(int searchMode, int modHash) throws UnsupportedCloseMatchModeException {
        this.setMode(searchMode, modHash, false);
    }

    @Override
    public Collection getMergeData(String province, String FSA, String streetName, SegmentDataSourceRecord segment) throws DataSourceException {
        if (!this.m_bAllowRuralFSAs && FSA != null && FSA.length() == 3 && FSA.charAt(1) == '0') {
            return null;
        }
        Collection data = this.getData(province, FSA, streetName);
        switch (this.m_currentMode) {
            case 2: {
                data = this.filter(data, streetName);
            }
        }
        if (this.m_bPreFilterRecords && data != null) {
            Collection leftPasses = this.m_filter.filter(data, segment, true);
            Collection rightPasses = this.m_filter.filter(data, segment, false);
            data = this.combineFilteredOutput(leftPasses, rightPasses);
        }
        if (this.m_bUniqueOutputStreets) {
            data = this.testForUniqueStreets(data, province, FSA, streetName);
        }
        return data;
    }

    private Collection getData(String province, String FSA, String streetName) throws DataSourceException {
        MapMarkerIndexMultiValue value;
        MapMarkerIndexKey key = this.makeMergeKey(province, FSA, streetName);
        try {
            value = this.search(key);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, "Unable to search for key.", (Throwable)IOEx);
        }
        if (value == null) {
            return null;
        }
        LinkedList<CombinedRecord> data = new LinkedList<CombinedRecord>();
        for (short i = 0; i < value.getValueCount(); i = (short)(i + 1)) {
            long offset = value.getOffsetAt(i);
            try {
                this.m_dataStream.seek(offset);
                CombinedRecord record = new CombinedRecord();
                record.read((DataInput)this.m_dataStream);
                data.add(record);
                continue;
            }
            catch (IOException IOEx) {
                throw new DataSourceException(13, "Unable to access data stream.", (Throwable)IOEx);
            }
        }
        return data;
    }

    private Collection filter(Collection records, String streetName) {
        if (records == null || records.isEmpty()) {
            return null;
        }
        CAN_ParsedAddress parsedInput = MergeUtilities.parse(streetName);
        if (parsedInput == null) {
            DataCreationLogger.getLogger().logInternalError("\tUnable to parse input: " + streetName);
            return null;
        }
        LinkedList<ICombinedRecord> output = new LinkedList<ICombinedRecord>();
        for (ICombinedRecord record : records) {
            String canPostName = this.m_streetNameBuilder.makeStreetString(record.getStreetElements(), true, false, false, false, "QC".equals(record.getStandardElements().getProvinceCode()));
            CAN_ParsedAddress parsedRecord = MergeUtilities.parse(canPostName);
            if (parsedRecord == null) {
                DataCreationLogger.getLogger().logInternalError("\tUnable to parse CANPost: " + canPostName);
                continue;
            }
            if (!this.passes(parsedInput, parsedRecord)) continue;
            output.add(record);
        }
        if (output.isEmpty()) {
            return null;
        }
        return output;
    }

    private boolean passes(CAN_ParsedAddress input, CAN_ParsedAddress record) {
        if (!this.testDirectionals(input, record)) {
            return false;
        }
        if (!this.testTypes(input, record)) {
            return false;
        }
        return this.testMainAddresses(input, record);
    }

    boolean testDirectionals(CAN_ParsedAddress input, CAN_ParsedAddress record) {
        if (input.getPreDirectional() == null && input.getPostDirectional() == null && record.getPreDirectional() == null && record.getPostDirectional() == null) {
            return true;
        }
        if (input.getPreDirectional() != null && input.getPostDirectional() != null && (record.getPreDirectional() == null && record.getPostDirectional() != null || record.getPreDirectional() != null && record.getPostDirectional() == null)) {
            return false;
        }
        if (record.getPreDirectional() != null && record.getPostDirectional() != null && (input.getPreDirectional() == null && input.getPostDirectional() != null || input.getPreDirectional() != null && input.getPostDirectional() == null)) {
            return false;
        }
        if (record.getPreDirectional() != null && record.getPostDirectional() != null && input.getPreDirectional() != null && input.getPostDirectional() != null) {
            return this.testDirectionals(input.getPreDirectional(), record.getPreDirectional()) && this.testDirectionals(input.getPostDirectional(), record.getPostDirectional());
        }
        if (input.getPreDirectional() != null) {
            if (record.getPreDirectional() == null && record.getPostDirectional() == null) {
                return false;
            }
            if (this.testDirectionals(input.getPreDirectional(), record.getPreDirectional()) || this.testDirectionals(input.getPreDirectional(), record.getPostDirectional())) {
                return true;
            }
        } else if (input.getPostDirectional() != null) {
            if (record.getPreDirectional() == null && record.getPostDirectional() == null) {
                return false;
            }
            if (this.testDirectionals(input.getPostDirectional(), record.getPreDirectional()) || this.testDirectionals(input.getPostDirectional(), record.getPostDirectional())) {
                return true;
            }
        }
        return false;
    }

    private boolean testDirectionals(String dir1, String dir2) {
        if (dir1 == null) {
            return dir2 == null;
        }
        if (dir2 == null) {
            return false;
        }
        if (dir1.equals(dir2)) {
            return true;
        }
        String translatedDir1 = this.translateDir(dir1);
        String translatedDir2 = this.translateDir(dir2);
        return translatedDir1.equals(translatedDir2);
    }

    private String translateDir(String dir) {
        if (unTranslatableDirs.contains(dir)) {
            return dir;
        }
        String translated = (String)m_dirTranslations.get(dir);
        if (translated != null) {
            return translated;
        }
        return dir;
    }

    private boolean testTypes(CAN_ParsedAddress input, CAN_ParsedAddress record) {
        if (input.getPreThoroughfareType() == null && input.getPostThoroughfareType() == null && record.getPreThoroughfareType() == null && record.getPostThoroughfareType() == null) {
            return true;
        }
        if (input.getPreThoroughfareType() != null) {
            if (record.getPreThoroughfareType() == null && record.getPostThoroughfareType() == null) {
                return false;
            }
            if (input.getPreThoroughfareType().equals(record.getPreThoroughfareType()) || input.getPreThoroughfareType().equals(record.getPostThoroughfareType())) {
                return true;
            }
        } else if (input.getPostThoroughfareType() != null) {
            if (record.getPreThoroughfareType() == null && record.getPostThoroughfareType() == null) {
                return false;
            }
            if (input.getPostThoroughfareType().equals(record.getPreThoroughfareType()) || input.getPostThoroughfareType().equals(record.getPostThoroughfareType())) {
                return true;
            }
        }
        return false;
    }

    private double getThreshold() {
        if (this.applyMod(8)) {
            return 0.85;
        }
        return 0.75;
    }

    private boolean testMainAddresses(CAN_ParsedAddress input, CAN_ParsedAddress record) {
        String inputMainAddress = this.prepareForScoring(input.getMainAddress());
        String recordMainAddress = this.prepareForScoring(record.getMainAddress());
        if (this.hasNumbers(input) || this.hasNumbers(record)) {
            return inputMainAddress.equals(recordMainAddress);
        }
        return MergeUtilities.score(inputMainAddress, recordMainAddress) > this.getThreshold();
    }

    private boolean hasNumbers(CAN_ParsedAddress parsed) {
        if (parsed.isNumberedRoad() || parsed.isNumericStreetName()) {
            return true;
        }
        char[] chars = parsed.getMainAddress().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            return true;
        }
        return false;
    }

    private String prepareForScoring(String str) {
        if (this.applyMod(8)) {
            return MergeUtilities.stripArticles(str);
        }
        if (this.applyMod(512)) {
            str = StringUtilities.stripString((String)str, (String)"'");
        }
        StringWithTokens tokens = new StringWithTokens(str, "' -.");
        return tokens.toString();
    }

    private Collection combineFilteredOutput(Collection leftPasses, Collection rightPasses) {
        if (leftPasses == null) {
            return rightPasses;
        }
        if (rightPasses == null) {
            return leftPasses;
        }
        LinkedList<ICombinedRecord> combined = new LinkedList<ICombinedRecord>();
        combined.addAll(leftPasses);
        for (ICombinedRecord record : rightPasses) {
            if (combined.contains(record)) continue;
            combined.add(record);
        }
        return combined;
    }

    private Collection testForUniqueStreets(Collection records, String province, String FSA, String streetName) {
        if (records == null || records.isEmpty()) {
            return null;
        }
        if (records.size() == 1) {
            return records;
        }
        HashSet<String> names = new HashSet<String>();
        for (ICombinedRecord record : records) {
            String canPostName = this.m_streetNameBuilder.makeStreetString(record.getStreetElements(), true, false, false, false, "QC".equals(record.getStandardElements().getProvinceCode()));
            names.add(canPostName);
        }
        if (names.size() == 1) {
            return records;
        }
        DataCreationLogger.getLogger().logInternalError("Unable to make unique street name, looking for: " + province + '\t' + FSA + '\t' + streetName);
        Iterator namesIterator = names.iterator();
        while (namesIterator.hasNext()) {
            DataCreationLogger.getLogger().logInternalError('\t' + (String)namesIterator.next());
        }
        DataCreationLogger.getLogger().logInternalError("");
        return null;
    }

    private MapMarkerIndexKey makeMergeKey(String province, String FSA, String streetName) {
        String keyStreet = this.makeStreetString(streetName);
        if (keyStreet == null || keyStreet.trim().length() == 0) {
            return null;
        }
        switch (this.m_currentMode) {
            case 0: 
            case 1: 
            case 3: 
            case 5: {
                return new CollatorMergeKey(province, FSA, keyStreet);
            }
            case 2: 
            case 4: {
                return new MergeSoundexKey(province, FSA, keyStreet);
            }
        }
        return null;
    }

    private MapMarkerIndexMultiValue search(MapMarkerIndexKey key) throws IOException {
        if (key == null) {
            return null;
        }
        return (MapMarkerIndexMultiValue)this.m_indexes[this.m_currentMode].search(key);
    }

    private String makeStreetString(String streetName) {
        CAN_ParsedAddress output;
        boolean bModApplied = false;
        if (this.applyMod(16)) {
            streetName = MergeUtilities.stripArticles(streetName.toUpperCase());
            bModApplied = true;
        }
        if ((output = MergeUtilities.parse(streetName)) == null) {
            return null;
        }
        boolean bl = bModApplied = this.applyMods(output) || bModApplied;
        if (!bModApplied) {
            return null;
        }
        if (this.m_currentMod - 16 == 0 && output.hasFrenchOrdinal() && output.getPostThoroughfareType() == null) {
            output.setPostThoroughfareType(output.getPreThoroughfareType());
            output.setPreThoroughfareType(null);
        }
        if (this.m_currentMode == 2 || this.m_currentMode == 4) {
            output.setPreDirectional(null);
            output.setPreThoroughfareType(null);
            output.setPostThoroughfareType(null);
            output.setPostDirectional(null);
        }
        if (this.m_currentMode == 3 && (output.getPreDirectional() != null || output.getPostDirectional() != null)) {
            return null;
        }
        if (this.m_currentMode == 5) {
            output.setPreThoroughfareType(null);
            output.setPostThoroughfareType(null);
        }
        return MergeUtilities.makePostParseString((Address)output, true, this.m_currentMode == 2 || this.m_currentMode == 4 || this.m_currentMode == 1 || this.m_currentMode == 5);
    }

    private boolean applyMods(CAN_ParsedAddress parsed) {
        if (this.m_currentMod == 0) {
            return true;
        }
        boolean bModApplied = false;
        if (!(!this.applyMod(1) || parsed.isNumberedRoad() || parsed.isNumericStreetName() || parsed.hasEnglishOrdinal() || parsed.hasFrenchOrdinal() || parsed.getMainAddress().endsWith("S"))) {
            parsed.setMainAddress(parsed.getMainAddress() + "S");
            bModApplied = true;
        }
        if (this.applyMod(4) && parsed.hasFrenchOrdinal() && parsed.getPostThoroughfareType() != null) {
            String mainAddress = MergeUtilities.stripFrenchOrdinal(parsed.getMainAddress());
            parsed.setMainAddress(mainAddress);
            parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
            parsed.setPostThoroughfareType(null);
            parsed.setHasFrenchOrdinal(false);
            parsed.setNumberedRoad(true);
            parsed.setNumericStreetName(false);
            bModApplied = true;
        }
        if (this.applyMod(2) && parsed.getPreThoroughfareType() == null && parsed.getPostThoroughfareType() != null && m_frenchEnglishTypes.contains(parsed.getPostThoroughfareType())) {
            parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
            parsed.setPostThoroughfareType(null);
            bModApplied = true;
        }
        if (this.applyMod(64) && "RANG".equals(parsed.getPreThoroughfareType()) && parsed.isNumberedRoad()) {
            parsed.setMainAddress(parsed.getMainAddress() + "E");
            parsed.setPostThoroughfareType(parsed.getPreThoroughfareType());
            parsed.setPreThoroughfareType(null);
            parsed.setHasFrenchOrdinal(true);
            parsed.setNumberedRoad(false);
            parsed.setNumericStreetName(true);
            bModApplied = true;
        }
        if (this.applyMod(32) && m_frenchEnglishTypes.contains(parsed.getPreThoroughfareType())) {
            parsed.setPostThoroughfareType(parsed.getPreThoroughfareType());
            parsed.setPreThoroughfareType(null);
            bModApplied = true;
        }
        if (this.applyMod(128) && parsed.hasEnglishOrdinal()) {
            parsed.setMainAddress(MergeUtilities.stripEnglishOrdinal(parsed.getMainAddress()));
            parsed.setHasEnglishOrdinal(false);
            parsed.setNumberedRoad(true);
            parsed.setNumericStreetName(false);
            bModApplied = true;
        }
        if (this.applyMod(256) && parsed.getPostThoroughfareType() != null && parsed.getPreThoroughfareType() == null) {
            parsed.setPreThoroughfareType(parsed.getPostThoroughfareType());
            parsed.setPostThoroughfareType(null);
            bModApplied = true;
        }
        if (this.applyMod(1024) && (parsed.getPreDirectional() != null || parsed.getPostDirectional() != null)) {
            String tmp = parsed.getPreDirectional();
            parsed.setPreDirectional(parsed.getPostDirectional());
            parsed.setPostDirectional(tmp);
            bModApplied = true;
        }
        if (this.applyMod(512) && parsed.getMainAddress().indexOf(39) != -1) {
            bModApplied = true;
        }
        if (this.applyMod(8)) {
            bModApplied = true;
        }
        if (this.applyMod(2048) && parsed.getMainAddress().length() > 1 && parsed.getMainAddress().endsWith("S")) {
            parsed.setMainAddress(parsed.getMainAddress().substring(0, parsed.getMainAddress().length() - 1));
            bModApplied = true;
        }
        if (this.applyMod(4096) && parsed.getPostThoroughfareType() != null) {
            parsed.setPostThoroughfareType(null);
            bModApplied = true;
        }
        if (this.applyMod(8192)) {
            boolean bl = bModApplied = MergeUtilities.expandNumbers(parsed, false) || bModApplied;
        }
        if (this.applyMod(16384)) {
            boolean bl = bModApplied = MergeUtilities.expandNumbers(parsed, true) || bModApplied;
        }
        if (this.applyMod(32768) && (parsed.getPreDirectional() != null || parsed.getPostDirectional() != null)) {
            parsed.setPreDirectional(null);
            parsed.setPostDirectional(null);
            bModApplied = true;
        }
        return bModApplied;
    }

    private boolean applyMod(int mod) {
        return (this.m_currentMod & mod) != 0;
    }

    static {
        Cloneable temp = new HashSet<String>();
        ((HashSet)temp).add("AVE");
        ((HashSet)temp).add("BD");
        ((HashSet)temp).add("PL");
        ((HashSet)temp).add("ST");
        ((HashSet)temp).add("CTR");
        m_frenchEnglishTypes = Collections.unmodifiableSet(temp);
        temp = new HashSet();
        ((HashSet)temp).add("N");
        ((HashSet)temp).add("NE");
        ((HashSet)temp).add("E");
        ((HashSet)temp).add("SE");
        ((HashSet)temp).add("S");
        ((HashSet)temp).add("SW");
        ((HashSet)temp).add("W");
        ((HashSet)temp).add("NW");
        unTranslatableDirs = Collections.unmodifiableSet(temp);
        temp = new HashMap();
        ((HashMap)temp).put("O", "W");
        ((HashMap)temp).put("NO", "NW");
        ((HashMap)temp).put("SO", "SW");
        m_dirTranslations = Collections.unmodifiableMap(temp);
    }
}

