/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.AbstractCloseMatchOutputer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

public class CloseMatchOutputer
extends AbstractCloseMatchOutputer {
    private PrintStream m_unMergedStream;
    private PrintStream m_unMergedLog;

    @Override
    public void open(String outputPath, String province) throws IOException {
        super.open(outputPath, province);
        this.m_unMergedStream = new PrintStream((OutputStream)new NIOOutputStream(new File(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"ucd"))));
        this.m_unMergedLog = new PrintStream((OutputStream)new NIOOutputStream(new File(StringUtilities.appendToPath((String)outputPath, (String)province, (String)"ucl"))));
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.m_unMergedStream != null) {
            this.m_unMergedStream.close();
        }
        if (this.m_unMergedLog != null) {
            this.m_unMergedLog.close();
        }
    }

    @Override
    public void output(SingleSACMergeInputRecord output) throws DataSourceException {
        this.m_unMergedStream.print("FSA: ");
        this.m_unMergedStream.println(output.getFSA());
        Iterator names = output.getStreetNames().iterator();
        while (names.hasNext()) {
            this.m_unMergedStream.print('\t');
            this.m_unMergedStream.println(names.next());
        }
        this.m_unMergedStream.println();
        this.m_unMergedLog.println(SourceRecordDataIDProvider.getProvider().getCurrentID());
        Collection streets = this.makeUnMatchedRecords(output);
        try {
            this.output(streets);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }
}

