/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.AbstractCloseMatchOutputer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class InitialCloseMatchOutputer
extends AbstractCloseMatchOutputer {
    private String m_outputExtension;
    private RandomAccessDataStream m_unMergedStream;

    public InitialCloseMatchOutputer(String outputExtension) {
        this.m_outputExtension = outputExtension;
    }

    @Override
    public void open(String outputPath, String province) throws IOException {
        super.open(outputPath, province);
        this.m_unMergedStream = new RandomAccessDataStream(new File(StringUtilities.appendToPath((String)outputPath, (String)province, (String)this.m_outputExtension)));
        this.m_unMergedStream.writeInt(0);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.m_unMergedStream != null) {
            this.m_unMergedStream.seek(0L);
            this.m_unMergedStream.writeInt(this.getUnMergedCount());
            this.m_unMergedStream.close();
            this.m_unMergedStream = null;
        }
    }

    @Override
    public void output(SingleSACMergeInputRecord output) throws DataSourceException {
        this.writeUnMergedRecords(this.makeUnMatchedRecords(output));
    }

    private void writeUnMergedRecords(Collection records) throws DataSourceException {
        int count = records.size();
        try {
            this.m_unMergedStream.writeByte(count);
            this.m_unMergedStream.writeUTF(SourceRecordDataIDProvider.getProvider().getCurrentID());
            this.output(records, (DataOutput)this.m_unMergedStream);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }
}

