/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.merge.text.close;

import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.StrictPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.close.CloseMatchHelper;
import com.mapinfo.mapmarker.CAN.dp.merge.close.CloseMatchMerger;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchHelper;
import com.mapinfo.mapmarker.CAN.dp.merge.close.ICloseMatchOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.DropDirsRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.DropPostTypeAndExpandEnglishNumbersRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.DropPostTypeAndExpandFrenchNumbersRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.DropPostTypeRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.ICloseMatchRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.IgnoreTypesAddSRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.IgnoreTypesDropSRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.IgnoreTypesRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.SearchNoDirsExpandEnglishNumbersRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.SearchNoDirsExpandFrenchNumbersRule;
import com.mapinfo.mapmarker.CAN.dp.merge.close.rules.SearchNoDirsRule;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.AbstractCloseMatchProcessor;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.InitialCloseMatchOutputer;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.MunicipalityLookupLoader;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;

public class SecondaryCloseMatchProcessor
extends AbstractCloseMatchProcessor {
    private static final ICloseMatchRule[] m_rules = new ICloseMatchRule[]{new DropPostTypeRule(), new DropPostTypeAndExpandEnglishNumbersRule(), new DropPostTypeAndExpandFrenchNumbersRule(), new SearchNoDirsRule(), new SearchNoDirsExpandEnglishNumbersRule(), new SearchNoDirsExpandFrenchNumbersRule(), new IgnoreTypesRule(), new IgnoreTypesDropSRule(), new IgnoreTypesAddSRule(), new DropDirsRule()};

    private SecondaryCloseMatchProcessor(String province, String outputPath, String inputSource, String CANPostPath, String combinedPath) throws DataSourceException {
        super(province, outputPath, inputSource, CANPostPath, combinedPath);
    }

    @Override
    protected ICloseMatchOutputer getOutputer() {
        return new InitialCloseMatchOutputer("uc2");
    }

    @Override
    protected ICloseMatchRule[] getRules() {
        return m_rules;
    }

    @Override
    protected String getLogBase() {
        return "_cm2";
    }

    @Override
    protected ICloseMatchHelper getHelper() throws DataSourceException {
        IPostalRecordFilter postalFilter = this.getPostalRecordFilter();
        RangeMergeHandler mergeHandler = new RangeMergeHandler(this.getRecorder(), this.getAccentsLookup(), postalFilter);
        CloseMatchMerger merger = new CloseMatchMerger(this.m_province, this.getMergeSource(), mergeHandler, postalFilter);
        return new CloseMatchHelper(this.getMergeSource(), merger, mergeHandler);
    }

    @Override
    protected IPostalRecordFilter getPostalRecordFilter() throws DataSourceException {
        return new StrictPostalRecordFilter(this.m_province, this.getAccentsLookup(), MunicipalityLookupLoader.loadLookup(this.m_CANPostPath));
    }

    public static void main(String[] args) {
        try {
            SecondaryCloseMatchProcessor processor = new SecondaryCloseMatchProcessor(args[0], args[2], args[1], args[4], args[3]);
            processor.process();
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
        }
        catch (Throwable t) {
            DataCreationLogger.getLogger().logStackTrace(t);
            System.exit(1);
        }
    }
}

