/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.parcel;

import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IOutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import java.util.Collection;
import java.util.Collections;

public class ParcelOutputSegmentBuilder
implements IOutputSegmentBuilder {
    @Override
    public Collection<SegmentDataSourceRecord> buildOutputSegments(ICAN_SegmentDataSourceRecord segment) throws DataSourceException {
        SegmentDataSourceRecord outputSegment = new SegmentDataSourceRecord(segment, true, true);
        if (outputSegment.getRanges() == null) {
            return null;
        }
        this.fixUnits(outputSegment);
        return Collections.singletonList(outputSegment);
    }

    private void fixUnits(SegmentDataSourceRecord segment) {
        for (RangeDataSourceRecord range : segment.getRanges()) {
            if (range.getUnits() == null) continue;
            for (UnitDataSourceRecord unit : range.getUnits()) {
                String lowUnit = unit.getLowUnit();
                int dashPos = lowUnit.indexOf(45);
                if (dashPos <= 0 || dashPos == lowUnit.length() - 1) continue;
                String low = lowUnit.substring(0, dashPos).trim();
                String high = lowUnit.substring(dashPos + 1).trim();
                unit.setLowUnit(low);
                unit.setHighUnit(high);
            }
        }
    }
}

