/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.parcel.merge;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.merge.AbstractMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputRecordOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.IPostalRecordFilter;
import com.mapinfo.mapmarker.CAN.dp.merge.IRangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.merge.text.AbstractMergeProcessor;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergedDataSource;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeMergeHandler;
import com.mapinfo.mapmarker.CAN.dp.parcel.merge.ParcelMergeHandler;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import java.io.IOException;

public class ParcelMergeProcessor
extends AbstractMergeProcessor {
    private IDataSource m_dataSource = new MergedDataSource();
    private AbstractMergeHandler m_mergeHandler;

    private ParcelMergeProcessor(String province, String srcPath, String CANPostPath, String outputPath, String canPostSourcePath) throws DataSourceException, IOException, IndexAccessException {
        super(province, CANPostPath, outputPath, canPostSourcePath);
        String[] args = new String[]{srcPath};
        this.m_dataSource.open(args);
        this.m_mergeHandler = new ParcelMergeHandler(this.getDataSource(), this.getMerger(), (IMergeOutputRecordOutputer)this.getOutputer());
    }

    @Override
    protected AbstractMergeHandler getMergeHandler() {
        return this.m_mergeHandler;
    }

    @Override
    protected IDataSource getDataSource() {
        return this.m_dataSource;
    }

    @Override
    protected IRangeMergeHandler buildRangeMergeHandler(MergeRecorder recorder, AccentsLookup accentsLookup, IPostalRecordFilter postalFilter) {
        return new RangeMergeHandler(recorder, accentsLookup, false, true, postalFilter);
    }

    public static void main(String[] args) {
        String province = args[0];
        String inputSrcFile = args[1];
        String CANPostPath = args[2];
        String outputPath = args[3];
        String accentFile = args[4];
        try {
            ParcelMergeProcessor processor = new ParcelMergeProcessor(province, inputSrcFile, CANPostPath, outputPath, accentFile);
            processor.process();
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            System.exit(1);
        }
        catch (Throwable T) {
            DataCreationLogger.getLogger().logStackTrace(T);
            System.exit(1);
        }
        System.exit(0);
    }
}

