/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.postgresql;

import com.mapinfo.mapmarker.CAN.dp.CAN_PostInfoDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.INamedFieldDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.MMJPostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.StringFrequencyTable;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.postgresql.PostgreSQLDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.postgresql.PostgreSQLPostInfoDataHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class CAN_PostgreSQLPostInfoDataHandler
extends PostgreSQLPostInfoDataHandler {
    private ITempDataRecordHandler m_extraTempHandler = new InMemoryTempDataRecordHandler(true);

    public CAN_PostgreSQLPostInfoDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        super(dataSourceAccess, dataConvertor, intermediateHandler, tempHandler);
    }

    public void open(Properties dataProperties) throws DataSourceException {
        super.open(dataProperties);
        this.m_extraTempHandler.open();
    }

    public void close() throws DataSourceException {
        super.close();
        if (this.m_extraTempHandler != null) {
            this.m_extraTempHandler.close();
            this.m_extraTempHandler = null;
        }
    }

    protected IDataSourceRecord makeDataSourceRecord(IDataSourceRecordObjects objects) {
        return new CAN_PostInfoDataSourceRecordImpl((INamedFieldDataSourceRecord)new PostgreSQLDataSourceRecord((JDBCDataSourceRecordObjects)objects));
    }

    protected void addDataRecord(TempDataRecord record) throws DataSourceException {
        super.addDataRecord(record);
        if (record == null) {
            System.out.println("no record");
        } else {
            if (record.getRecordKey() == null) {
                System.out.println("no key");
            }
            if (record.getDataRecordIDs() == null) {
                System.out.println("No IDs");
            } else if (record.getDataRecordIDs().get(0) == null) {
                System.out.println("no ID");
            }
        }
        this.m_extraTempHandler.addTempDataRecord(new TempDataRecord(record.getRecordKey(), (IDataRecordID)record.getDataRecordIDs().get(0)));
    }

    public FrequentDataFileStrings getFrequentDataFileStrings(int maxFrequentStrings) throws DataCreationException {
        FrequentDataFileStrings frequentStrings = new FrequentDataFileStrings(new int[]{0});
        StringFrequencyTable areaName3Table = new StringFrequencyTable();
        try {
            while (this.m_extraTempHandler.hasNextTempDataRecord()) {
                TempDataRecord tempRecord = this.m_extraTempHandler.getNextTempDataRecord();
                Collection records = this.getRecords(tempRecord);
                if (records == null) continue;
                Iterator it = records.iterator();
                MMJPostInfoRecord record = (MMJPostInfoRecord)it.next();
                areaName3Table.addString(record.getRecord().getAreaName3());
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException((Throwable)DSEx);
        }
        frequentStrings.addTypeStrings(0, areaName3Table.getMostFrequentStrings(maxFrequentStrings));
        return frequentStrings;
    }

    private Collection getRecords(TempDataRecord record) throws DataSourceException {
        LinkedList<Object> records = new LinkedList<Object>();
        Iterator IDsIterator = record.getDataRecordIDs().iterator();
        while (IDsIterator.hasNext()) {
            Object o = this.getIntermediateDataHandler().getIntermediateData((IDataRecordID)IDsIterator.next());
            this.replaceDataFromTempDataRecord(o, record);
            records.add(o);
        }
        return records;
    }
}

