/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AbstractDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AddressDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextLookupDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class DataSource
implements IDataSource {
    public static final int ADDRESS_LOOKUP_DATA = 1;
    public static final int TEXT_LOOKUP_DATA = 2;
    private SeekableDataInputStream m_stream;
    private int m_type;
    private boolean m_bWithID;

    public DataSource(int type, boolean bWithID) {
        this.m_type = type;
        this.m_bWithID = bWithID;
    }

    public void open(String[] args) throws DataSourceException {
        if (args == null || args.length != 1) {
            throw new DataSourceException(11, "dataSource args are incorrect.");
        }
        String fileSpec = args[0];
        if (fileSpec == null) {
            throw new DataSourceException(11, "dataSource args are incorrect.");
        }
        File f = new File(fileSpec);
        if (!f.exists() || !f.canRead()) {
            throw new DataSourceException(11, "dataSource fileSpec incorrect.");
        }
        try {
            this.m_stream = new SeekableDataInputStream(f);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
    }

    public void close() throws DataSourceException {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (IOException IOEx) {
                throw new DataSourceException(12);
            }
            finally {
                this.m_stream = null;
            }
        }
    }

    public int getRecordCount() throws DataSourceException {
        int recordLength;
        switch (this.m_type) {
            case 1: {
                recordLength = this.m_bWithID ? 190 : 182;
                break;
            }
            case 2: {
                recordLength = this.m_bWithID ? 252 : 244;
                break;
            }
            default: {
                throw new DataSourceException(-1, "Illegal data source type: " + this.m_type);
            }
        }
        return (int)(this.m_stream.length() / (long)recordLength);
    }

    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        AbstractDataSourceRecordObjects objects;
        switch (this.m_type) {
            case 1: {
                objects = new AddressDataSourceRecordObjects(this.m_bWithID);
                break;
            }
            case 2: {
                objects = new TextLookupDataSourceRecordObjects(this.m_bWithID);
                break;
            }
            default: {
                throw new DataSourceException(-1, "Illegal data source type: " + this.m_type);
            }
        }
        try {
            objects.read((DataInput)this.m_stream);
        }
        catch (EOFException EOFEx) {
            return null;
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13);
        }
        return objects;
    }
}

