/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.MunicipalityLookup;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.MunicipalityCrossReferenceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;

public class MunicipalityLookupLoader {
    private MunicipalityLookupLoader() {
    }

    public static MunicipalityLookup loadLookup(String path) throws DataSourceException {
        MunicipalityLookup lookup = new MunicipalityLookup();
        FilterInputStream stream = null;
        try {
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(StringUtilities.appendToPath((String)path, (String)"canada.mcr"))));
            boolean bCont = true;
            while (bCont) {
                try {
                    MunicipalityCrossReferenceRecord record = new MunicipalityCrossReferenceRecord();
                    record.read((DataInput)((Object)stream));
                    lookup.add(record);
                }
                catch (EOFException EOFEx) {
                    bCont = false;
                }
            }
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataSourceException(10, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException IOEx) {
                    DataCreationLogger.getLogger().logInternalError("Unable to close municipality file.");
                    DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                }
            }
        }
        return lookup;
    }
}

