/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.binary.AbstractStreetCrossReferenceProcessor;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.StreetCrossReferenceDataSource;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;

public class StreetCrossReferenceProcessor
extends AbstractStreetCrossReferenceProcessor {
    private StreetCrossReferenceProcessor(String outputPath, IDataSource source, StreetNameBuilder streetBuilder) {
        super(outputPath, source, streetBuilder);
    }

    public static void main(String[] args) {
        AccentsLookup accents;
        String outputPath = args[0];
        String canPostPath = args[1];
        String[] sourceArgs = new String[]{canPostPath};
        StreetCrossReferenceDataSource source = new StreetCrossReferenceDataSource();
        try {
            source.open(sourceArgs);
        }
        catch (DataSourceException DSEx) {
            System.err.println("Unable to open data source.");
            DSEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            accents = TextAccentsLoader.loadLookup(canPostPath);
        }
        catch (DataSourceException DSEx) {
            StreetCrossReferenceProcessor.killSource(source);
            System.err.println("Unable to load accents file.");
            DSEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        StreetCrossReferenceProcessor processor = new StreetCrossReferenceProcessor(outputPath, source, new StreetNameBuilder(accents));
        try {
            processor.process();
        }
        catch (DataCreationException DCEx) {
            StreetCrossReferenceProcessor.killSource(source);
            System.err.println("Unable to create street cross reference file.");
            DCEx.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        StreetCrossReferenceProcessor.killSource(source);
        System.out.println("Street cross reference files created.");
    }

    private static void killSource(IDataSource source) {
        try {
            source.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

