/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.MunicipalityLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.binary.AbstractMunicipalityProcessor;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.AddressDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.DataSource;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.MunicipalityLookupLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextLookupDataSourceRecordObjects;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.elements.StandardElements;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class TextMunicipalityProcessor
extends AbstractMunicipalityProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        MunicipalityLookup municipalityLookup;
        AccentsLookup accentsLookup;
        if (args.length != 2) {
            System.err.println("Usage: <CAN Post path> <output path>");
            System.exit(1);
            return;
        }
        String CANPostPath = args[0];
        String outputPath = args[1];
        TextMunicipalityProcessor.setUpLoggers(outputPath);
        DataSource addressSource = new DataSource(1, false);
        DataSource textSource = new DataSource(2, false);
        try {
            String[] addressArgs = new String[]{StringUtilities.appendToPath((String)CANPostPath, (String)"canada.add")};
            addressSource.open(addressArgs);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logError("Unable to load address lookup file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
            return;
        }
        try {
            String[] textArgs = new String[]{StringUtilities.appendToPath((String)CANPostPath, (String)"canada.dcr")};
            textSource.open(textArgs);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logError("Unable to load text lookup file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
            return;
        }
        try {
            accentsLookup = TextAccentsLoader.loadLookup(CANPostPath);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logError("Unable to load accent lookup file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
            return;
        }
        try {
            municipalityLookup = MunicipalityLookupLoader.loadLookup(CANPostPath);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logError("Unable to load municipality cross reference file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
            System.exit(1);
            return;
        }
        TextMunicipalityProcessor processor = new TextMunicipalityProcessor(outputPath, addressSource, textSource, accentsLookup, municipalityLookup);
        try {
            processor.process();
            DataCreationLogger.getLogger().logStatus("Finished processing municipality file");
        }
        catch (DataCreationException DCEx) {
            DataCreationLogger.getLogger().logError("Unable to process municipality file");
            DataCreationLogger.getLogger().logStackTrace((Throwable)DCEx);
        }
        finally {
            try {
                addressSource.close();
            }
            catch (DataSourceException dataSourceException) {}
            try {
                textSource.close();
            }
            catch (DataSourceException dataSourceException) {}
        }
    }

    private static void setUpLoggers(String outputPath) {
        String baseName = StringUtilities.appendToPath((String)outputPath, (String)"municip");
        DataCreationLogger.getLogger().setStatusLog(baseName + ".log", false);
        DataCreationLogger.getLogger().setErrorLog(baseName + ".err", false);
        DataCreationLogger.getLogger().setInternalErrorLog(baseName + ".irr", false);
    }

    private TextMunicipalityProcessor(String outputPath, IDataSource addressLookupSource, IDataSource textLookupSource, AccentsLookup accentsLookup, MunicipalityLookup municipalityLookup) {
        super(outputPath, addressLookupSource, textLookupSource, accentsLookup, municipalityLookup);
    }

    @Override
    protected IStandardElements getStandardElements(IDataSourceRecordObjects objects) {
        if (objects instanceof TextLookupDataSourceRecordObjects) {
            return new StandardElements((TextLookupDataSourceRecordObjects)objects);
        }
        if (objects instanceof AddressDataSourceRecordObjects) {
            return new StandardElements((AddressDataSourceRecordObjects)objects);
        }
        throw new IllegalArgumentException("bad data source record objects: " + objects.getClass().getName());
    }
}

