/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost;

import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.CANPostStreet;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.CANPost.IUnMatchedStreetRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.StreetNameBuilder;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IBuildingElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IGovernmentElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ILVRElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStandardElements;
import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.ISuiteElements;
import com.mapinfo.mapmarker.CAN.dp.binary.Post2SACLookup;
import com.mapinfo.mapmarker.CAN.dp.merge.FSAProvinceChecker;
import com.mapinfo.mapmarker.CAN.dp.merge.text.RangeDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.UnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class UnMatchedStreetRecordBuilder
implements IUnMatchedStreetRecordBuilder {
    private static final boolean m_bEmptyRangeUnitRangeLDUs = false;
    private static final String ODD = "1";
    private static final String EVEN = "0";
    private static final String BOTH = "2";
    private AccentsLookup m_accents;
    private Post2SACLookup m_post2SACLookup;
    private StreetNameBuilder m_streetNameBuilder;

    public UnMatchedStreetRecordBuilder(AccentsLookup accents, Post2SACLookup post2SACLookup) {
        this.m_accents = accents;
        this.m_post2SACLookup = post2SACLookup;
        this.m_streetNameBuilder = new StreetNameBuilder(accents);
    }

    @Override
    public IStreetDataSourceRecord buildStreet(ICombinedRecord record, Collection subRecords) {
        StreetDataSourceRecord street = this.buildStreet(record);
        if (street != null) {
            SegmentDataSourceRecord segment = (SegmentDataSourceRecord)street.getSegment();
            Collection ranges = this.buildRanges(subRecords);
            for (RangeDataSourceRecord range : ranges) {
                if (StringUtilities.isEmpty((String)range.getFrom()) && StringUtilities.isEmpty((String)range.getTo())) {
                    DataCreationLogger.getLogger().logError("Unable to build range with house numbers for record ID: " + record.getUniqueIDElement().getUniqueID());
                    DataCreationLogger.getLogger().logError("\tcombined record had postal code of: " + record.getStandardElements().getPostalCode());
                    return null;
                }
                segment.addRange(range);
            }
        }
        return street;
    }

    private StreetDataSourceRecord buildStreet(ICombinedRecord record) {
        IStandardElements standardElements = record.getStandardElements();
        CANPostStreet street = this.m_streetNameBuilder.makeStreet(record);
        if (street == null) {
            DataCreationLogger.getLogger().logError("Unable to create street for record: " + record.getUniqueIDElement().getUniqueID());
            return null;
        }
        String FSA = this.getFSA(standardElements);
        if (!FSAProvinceChecker.check(FSA, standardElements.getProvinceCode())) {
            DataCreationLogger.getLogger().logInternalError("BAD CANPost record, FSA " + FSA + " does not belong to province");
            return null;
        }
        int SAC = this.getSAC(FSA);
        if (SAC == -1) {
            DataCreationLogger.getLogger().logError("Unable to get SAC for FSA: " + FSA);
            return null;
        }
        SegmentDataSourceRecord segment = new SegmentDataSourceRecord(standardElements.getProvinceCode(), FSA, this.getMunicipalityName(standardElements));
        return new StreetDataSourceRecord(street.getStreetName(), SAC, segment, street.getOriginalName(), street.getDeliveryInstallationInfo());
    }

    private String getFSA(IStandardElements elements) {
        return elements.getPostalCode().substring(0, 3);
    }

    private String getMunicipalityName(IStandardElements elements) {
        if (elements.getMunicipalityNameAccentIndicator()) {
            return this.m_accents.get(elements.getMunicipalityName());
        }
        return elements.getMunicipalityName();
    }

    private int getSAC(String FSA) {
        return this.m_post2SACLookup.getSAC(FSA);
    }

    private Collection buildRanges(Collection subRecords) {
        LinkedList<RangeDataSourceRecord> ranges = new LinkedList<RangeDataSourceRecord>();
        Iterator iterator = subRecords.iterator();
        while (iterator.hasNext()) {
            RangeDataSourceRecord range = this.makeRange((ICombinedRecord)iterator.next());
            if (range == null) continue;
            ranges.add(range);
        }
        return ranges;
    }

    private RangeDataSourceRecord makeRange(ICombinedRecord record) {
        switch (record.getStandardElements().getRecordTypeCode()) {
            case '1': 
            case '2': 
            case 'A': 
            case 'B': 
            case 'C': {
                UnitDataSourceRecord unit = this.getUnit(record);
                return new RangeDataSourceRecord(record.getStreetElements().getStreetAddressFromNumber(), record.getStreetElements().getStreetAddressToNumber(), this.convertStatus(record.getStreetElements().getStreetAddressSequenceCode()), true, this.getLDU(record.getStandardElements()), null, unit == null ? this.getPlaceName(record) : null, record.getStandardElements().getProvinceCode(), this.getMunicipalityName(record.getStandardElements()), unit, record.getRouteServiceElements());
            }
            case '3': 
            case 'D': 
            case 'E': {
                return new RangeDataSourceRecord(record.getLockBoxElements().getLockBoxBagFromNumber(), record.getLockBoxElements().getLockBoxBagToNumber(), BOTH, true, this.getLDU(record.getStandardElements()), null, this.getPlaceName(record), record.getStandardElements().getProvinceCode(), this.getMunicipalityName(record.getStandardElements()), null);
            }
        }
        return new RangeDataSourceRecord(EVEN, EVEN, EVEN, true, this.getLDU(record.getStandardElements()), null, null, record.getStandardElements().getProvinceCode(), this.getMunicipalityName(record.getStandardElements()), null);
    }

    private String convertStatus(char sequenceCode) {
        switch (sequenceCode) {
            case '1': {
                return ODD;
            }
            case '2': {
                return EVEN;
            }
        }
        return BOTH;
    }

    private String getPlaceName(ICombinedRecord record) {
        IBuildingElements building = record.getBuildingElements();
        if (building != null && building.getBuildingName() != null) {
            return building.getBuildingName();
        }
        ILVRElements LVR = record.getLVRElements();
        if (LVR != null && LVR.getLVRName() != null) {
            return LVR.getLVRName();
        }
        IGovernmentElements government = record.getGovernmentElements();
        if (government != null && government.getDepartmentName() != null) {
            return government.getDepartmentName();
        }
        return null;
    }

    private String getLDU(IStandardElements elements) {
        return elements.getPostalCode().substring(3);
    }

    private UnitDataSourceRecord getUnit(ICombinedRecord record) {
        ISuiteElements suite = record.getSuiteElements();
        if (suite == null) {
            return null;
        }
        String lowUnit = suite.getSuiteFromNumber();
        String highUnit = suite.getSuiteToNumber();
        if (lowUnit != null && highUnit != null) {
            return new UnitDataSourceRecord(lowUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        if (highUnit != null) {
            DataCreationLogger.getLogger().logInternalError("High unit only -- " + highUnit);
            return new UnitDataSourceRecord(highUnit, highUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        if (lowUnit != null) {
            DataCreationLogger.getLogger().logInternalError("Low unit only -- " + lowUnit);
            return new UnitDataSourceRecord(lowUnit, lowUnit, this.getPlaceName(record), this.getLDU(record.getStandardElements()), null);
        }
        return null;
    }
}

