/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeAccessIndex;
import com.mapinfo.mapmarker.CAN.dp.CANPost.index.CollatorMergeKey;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeSource;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.text.CombinedRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class MergeSource
implements IMergeSource {
    private SeekableDataInputStream m_dataStream;
    private MapMarkerMultiLevelReadOnlyIndexFile m_index;
    private static final boolean m_bUseCollator = true;
    private static final boolean m_bCleanMainAddress = true;

    public void open(String path, String province) throws DataSourceException {
        String dataPath = StringUtilities.appendToPath((String)path, (String)province, (String)"tdr");
        String indexPath = StringUtilities.appendToPath((String)path, (String)province, (String)"mdx");
        try {
            this.m_dataStream = new SeekableDataInputStream(new File(dataPath));
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, "Unable to open merge data file: " + dataPath);
        }
        this.m_index = MergeSource.getIndex();
        try {
            this.m_index.open(indexPath);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, "Unable to open merge index file.");
        }
    }

    private static MapMarkerMultiLevelReadOnlyIndexFile getIndex() {
        return new CollatorMergeAccessIndex();
    }

    public void close() throws DataSourceException {
        if (this.m_dataStream != null) {
            try {
                this.m_dataStream.close();
            }
            catch (IOException IOEx) {
                throw new DataSourceException(12, "Unable to close data stream.");
            }
            finally {
                this.m_dataStream = null;
            }
        }
        if (this.m_index != null) {
            try {
                this.m_index.close();
            }
            catch (IOException IOEx) {
                throw new DataSourceException(12, "Unable to close index.");
            }
            finally {
                this.m_index = null;
            }
        }
    }

    @Override
    public Collection getMergeData(String province, String FSA, String streetName) throws DataSourceException {
        MapMarkerIndexMultiValue value;
        MapMarkerIndexKey key = this.makeMergeKey(province, FSA, streetName);
        if (key == null) {
            return null;
        }
        try {
            value = (MapMarkerIndexMultiValue)this.m_index.search(key);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, "Unable to search for key.", (Throwable)IOEx);
        }
        if (value == null) {
            return null;
        }
        LinkedList<CombinedRecord> data = new LinkedList<CombinedRecord>();
        for (short i = 0; i < value.getValueCount(); i = (short)(i + 1)) {
            long offset = value.getOffsetAt(i);
            try {
                this.m_dataStream.seek(offset);
                CombinedRecord record = new CombinedRecord();
                record.read((DataInput)this.m_dataStream);
                data.add(record);
                continue;
            }
            catch (IOException IOEx) {
                throw new DataSourceException(13, "Unable to access data stream.", (Throwable)IOEx);
            }
        }
        return data;
    }

    private MapMarkerIndexKey makeMergeKey(String province, String FSA, String streetName) {
        String streetString = this.makeStreetString(streetName);
        if (streetString == null) {
            return null;
        }
        return new CollatorMergeKey(province, FSA, streetString);
    }

    private String makeStreetString(String streetName) {
        CAN_ParsedAddress parsed = MergeUtilities.parse(streetName);
        if (parsed == null) {
            return null;
        }
        return MergeUtilities.makePostParseString((Address)parsed, true);
    }
}

