/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.CANPost.combined.elements;

import com.mapinfo.mapmarker.CAN.dp.CANPost.elements.IStreetElements;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.Utilities;
import com.mapinfo.mapmarker.CAN.dp.text.CAN_AbstractTextRecord;

public class StreetElements
implements IStreetElements {
    private static final int STREET_NAME_START = 89;
    private static final int STREET_NAME_LEN = 30;
    private static final int STREET_TYPE_START = 119;
    private static final int STREET_TYPE_LEN = 6;
    private static final int STREET_DIR_START = 125;
    private static final int STREET_DIR_LEN = 2;
    private static final int STREET_ADDR_SEQ_POS = 127;
    private static final int STREET_ADDR_TO_START = 128;
    private static final int STREET_ADDR_TO_LEN = 6;
    private static final int STREET_ADDR_TO_SUF_POS = 135;
    private static final int STREET_ADDR_FROM_START = 136;
    private static final int STREET_ADDR_FROM_LEN = 6;
    private static final int STREET_ADDR_FROM_SUF_POS = 142;
    private static final int STREET_NAME_ACCENT_POS = 143;
    private CAN_AbstractTextRecord m_record;

    public StreetElements(CAN_AbstractTextRecord record) {
        this.m_record = record;
    }

    public StreetElements(IStreetElements elements, String low, String high, int oddEven) {
    }

    public StreetElements(CAN_AbstractTextRecord record, IStreetElements elements) {
        this(record);
        this.m_record.setFieldWithLeadingSpace(elements.getStreetName(), 89, 30);
        this.m_record.setFieldWithLeadingSpace(elements.getStreetTypeCode(), 119, 6);
        this.m_record.setFieldWithLeadingSpace(elements.getStreetDirectionCode(), 125, 2);
        this.m_record.setChar(elements.getStreetAddressSequenceCode(), 127);
        this.m_record.setFieldWithLeadingSpace(elements.getStreetAddressToNumber(), 128, 6);
        this.m_record.setChar(elements.getStreetAddressNumberSuffixToCode(), 135);
        this.m_record.setFieldWithLeadingSpace(elements.getStreetAddressFromNumber(), 136, 6);
        this.m_record.setChar(elements.getStreetAddressNumberSuffixFromCode(), 142);
        this.m_record.setChar(elements.getStreetNameAccentIndicator() ? (char)'1' : '0', 143);
    }

    @Override
    public String getStreetName() {
        return this.m_record.getField(89, 30);
    }

    @Override
    public String getStreetTypeCode() {
        return this.m_record.getField(119, 6);
    }

    @Override
    public String getStreetDirectionCode() {
        return this.m_record.getField(125, 2);
    }

    @Override
    public char getStreetAddressSequenceCode() {
        return this.m_record.getChar(127);
    }

    @Override
    public String getStreetAddressToNumber() {
        return this.m_record.getField(128, 6);
    }

    @Override
    public char getStreetAddressNumberSuffixToCode() {
        return this.m_record.getChar(135);
    }

    @Override
    public String getStreetAddressFromNumber() {
        return this.m_record.getField(136, 6);
    }

    @Override
    public char getStreetAddressNumberSuffixFromCode() {
        return this.m_record.getChar(142);
    }

    @Override
    public boolean getStreetNameAccentIndicator() {
        return this.m_record.getChar(143) == '1';
    }

    @Override
    public String getStreetAddressNumberSuffix(char code) {
        return Utilities.getStreetAddressNumberSuffix(code);
    }
}

