/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text;

import com.mapinfo.mapmarker.CAN.dp.CANPost.IUnMatchedOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class UnMatchedOutputer
implements IUnMatchedOutputer {
    private RandomAccessDataStream m_stream;
    private int m_recordCount;

    public void open(String fileSpec) throws IOException {
        File f = new File(fileSpec);
        if (f.exists()) {
            this.m_stream = new RandomAccessDataStream(f);
            this.m_recordCount = this.m_stream.readInt();
        } else {
            this.m_stream = new RandomAccessDataStream(f);
            this.m_stream.writeInt(0);
        }
        this.m_stream.seek(this.m_stream.length());
    }

    public void close() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.seek(0L);
            this.m_stream.writeInt(this.m_recordCount);
            this.m_stream.close();
            this.m_stream = null;
        }
    }

    @Override
    public void output(IStreetDataSourceRecord street) throws DataSourceException {
        ++this.m_recordCount;
        try {
            ((StreetDataSourceRecord)street).write((DataOutput)this.m_stream);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(13, (Throwable)IOEx);
        }
    }
}

