/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.ud;

import com.google.common.primitives.Ints;
import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_Constraints;
import com.mapinfo.mapmarker.CAN.CAN_EnglishSoundex;
import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.CAN.dp.CAN_DataConstructionParser;
import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.ICAN_SegmentDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_Geo2SacRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GeoBase;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJStreetRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_UDPostInfoFetcher;
import com.mapinfo.mapmarker.CAN.dp.ud.ICAN_UDRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class CAN_UDStreetDataSourceRecordConvertor
extends UDStreetDataSourceRecordConvertor {
    private IUDNonStreetDataHandler m_geoinfoHandler;
    private CAN_UDPostInfoFetcher m_postInfoFetcher;
    private static final Soundex soundex = new CAN_EnglishSoundex();

    public CAN_UDStreetDataSourceRecordConvertor(Properties dataProperties, IUDNonStreetDataHandler post2sacHandler, IUDNonStreetDataHandler geo2sacHandler, IUDNonStreetDataHandler geoinfoHandler, CAN_UDPostInfoFetcher postInfoFetcher) throws DataCreationException {
        super(new CAN_EnglishSoundex(), dataProperties, new CollationKeyGenerator(Locale.CANADA), new CAN_DataConstructionParser(), new CAN_Constraints(), post2sacHandler, geo2sacHandler);
        this.m_geoinfoHandler = geoinfoHandler;
        this.m_postInfoFetcher = postInfoFetcher;
    }

    @Override
    protected MMJGeo2SacRecord makeGeo2SacDataRecordType(int sac, IGeoBase base) {
        return new CAN_Geo2SacRecord(sac, (CAN_GeoBase)base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new CAN_Geo2SacRecord();
    }

    protected IGeoBase makeGeoBase(String areaName1, String areaName3) {
        MiSoundexKey soundex;
        if (this.stringExists(areaName1) && this.stringExists(areaName3) && (soundex = (MiSoundexKey)this.m_soundex.getSoundex(areaName3)) != null) {
            return new CAN_GeoBase(new CAN_GeoSoundexKey(areaName1, soundex));
        }
        return null;
    }

    private IGeoBase[] makeGeoBaseList(ISegmentDataSourceRecord input, boolean bLeft) throws DataSourceException {
        String areaName1 = null;
        String areaName3 = null;
        if (bLeft) {
            areaName1 = StringUtilities.isEmpty((String)input.getLeftAreaName1()) ? "" : input.getLeftAreaName1();
            areaName3 = StringUtilities.isEmpty((String)input.getLeftAreaName3()) ? "" : input.getLeftAreaName3();
        } else {
            areaName1 = StringUtilities.isEmpty((String)input.getRightAreaName1()) ? "" : input.getRightAreaName1();
            areaName3 = StringUtilities.isEmpty((String)input.getRightAreaName3()) ? "" : input.getRightAreaName3();
        }
        ISoundexKey areaName3SndxKey = soundex.getSoundex(areaName3);
        if (areaName3SndxKey == null) {
            DataCreationLogger.getLogger().logInternalError("Unable to make soundex for: " + areaName3);
            return null;
        }
        CAN_GeoSoundexKey sndxKey = new CAN_GeoSoundexKey(areaName1, (MiSoundexKey)areaName3SndxKey);
        CAN_GeoSoundexKey sndxKeyNoAN1 = new CAN_GeoSoundexKey(null, (MiSoundexKey)areaName3SndxKey);
        IGeoBase[] bases = new IGeoBase[]{new CAN_GeoBase(sndxKey), new CAN_GeoBase(sndxKeyNoAN1)};
        return bases;
    }

    protected int[] getSacsFromGeo2Sac(IStreetDataSourceRecord input, boolean left) throws DataSourceException {
        IGeoBase[] baseArray = this.makeGeoBaseList(input.getSegment(), left);
        if (baseArray == null || baseArray.length == 0) {
            return new int[]{this.NO_SAC};
        }
        int[] sac = null;
        HashSet<Integer> geoBasesSet = new HashSet<Integer>();
        for (IGeoBase iGeoBase : baseArray) {
            for (int value : sac = this.getGeo2Sac(iGeoBase)) {
                geoBasesSet.add(value);
            }
        }
        if (geoBasesSet.isEmpty()) {
            return new int[]{this.NO_SAC};
        }
        return Ints.toArray(geoBasesSet);
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        Address parsed = this.parseStreet(inputStreetAddress);
        if (parsed != null) {
            if (!"100".equals(parsed.getAddressNumber()) || parsed.getMainAddress() == null || parsed.getUnitValue() != null || parsed.getUnitType() != null) {
                DataCreationLogger.getLogger().logInternalError("CAN_UDStreetDataSourceRecordConvertor::getParsedStreet(): retry parsing with Apt 1 for: " + inputStreetAddress.getMainAddress());
                AddressImpl withAptInput = new AddressImpl(inputStreetAddress);
                withAptInput.setMainAddress(withAptInput.getMainAddress() + " APT 1");
                parsed = this.parseStreet((Address)withAptInput);
                if (!("100".equals(parsed.getAddressNumber()) && parsed.getMainAddress() != null && "1".equals(parsed.getUnitValue()) && "APT".equals(parsed.getUnitType()))) {
                    DataCreationLogger.getLogger().logInternalError("CAN_UDStreetDataSourceRecordConvertor::getParsedStreet(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
                    return null;
                }
                parsed.setUnitType(null);
                parsed.setUnitValue(null);
            }
        } else {
            DataCreationLogger.getLogger().logInternalError("CAN_UDStreetDataSourceRecordConvertor::getParsedStreet(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        return parsed;
    }

    protected MMJStreetRecord makeStreetRecordType() {
        return new CAN_MMJStreetRecord();
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new CAN_MMJSegmentRecord();
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new CAN_MMJRangeRecord();
    }

    private void addGeoInfoRecord(String province, String city) {
        if (this.stringExists(province) && this.stringExists(city)) {
            MiStringIndexKey key = new MiStringIndexKey(province + city);
            GeoInfoRecord geoinfo = new GeoInfoRecord();
            geoinfo.setAreaName1(province);
            geoinfo.setAreaName3(city);
            this.m_geoinfoHandler.addRecord(new MMJGeoInfoRecord(geoinfo, (MapMarkerIndexKey)key));
        }
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        CAN_MMJSegmentRecord segment = (CAN_MMJSegmentRecord)super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        ICAN_SegmentDataSourceRecord canSegmentSource = (ICAN_SegmentDataSourceRecord)input;
        if (convertLeft) {
            if (canSegmentSource.hasLeftCMA()) {
                segment.setLeftCMA(canSegmentSource.getLeftCMA());
            }
            if (canSegmentSource.hasLeftCSD()) {
                segment.setLeftCSD(canSegmentSource.getLeftCSD());
            }
            if (canSegmentSource.hasLeftCT()) {
                segment.setLeftCT(canSegmentSource.getLeftCT());
            }
            if (canSegmentSource.hasLeftDA()) {
                segment.setLeftDA(canSegmentSource.getLeftDA());
            }
            if (canSegmentSource.hasLeftCD()) {
                segment.setLeftCD(canSegmentSource.getLeftCD());
            }
        }
        if (convertRight) {
            if (canSegmentSource.hasRightCMA()) {
                segment.setRightCMA(canSegmentSource.getRightCMA());
            }
            if (canSegmentSource.hasRightCSD()) {
                segment.setRightCSD(canSegmentSource.getRightCSD());
            }
            if (canSegmentSource.hasRightCT()) {
                segment.setRightCT(canSegmentSource.getRightCT());
            }
            if (canSegmentSource.hasRightDA()) {
                segment.setRightDA(canSegmentSource.getRightDA());
            }
            if (canSegmentSource.hasRightCD()) {
                segment.setRightCD(canSegmentSource.getRightCD());
            }
        }
        if (segment != null) {
            PostInfoRecord record;
            if (convertLeft) {
                if ((segment.getLeftAreaName1() == null || segment.getLeftAreaName3() == null) && (record = this.m_postInfoFetcher.getRecordForFSA(segment.getLeftPostalCode1())) != null) {
                    segment.setLeftAreaName1(record.getAreaName1());
                    segment.setLeftAreaName3(record.getAreaName3());
                    this.addRecordToSet(this.makeGeo2SacDataRecordType(sac, this.makeGeoBase(record.getAreaName1(), record.getAreaName3())));
                }
                this.addGeoInfoRecord(segment.getLeftAreaName1(), segment.getLeftAreaName3());
            }
            if (convertRight) {
                if ((segment.getRightAreaName1() == null || segment.getRightAreaName3() == null) && (record = this.m_postInfoFetcher.getRecordForFSA(segment.getRightPostalCode1())) != null) {
                    segment.setRightAreaName1(record.getAreaName1());
                    segment.setRightAreaName3(record.getAreaName3());
                    this.addRecordToSet(this.makeGeo2SacDataRecordType(sac, this.makeGeoBase(record.getAreaName1(), record.getAreaName3())));
                }
                this.addGeoInfoRecord(segment.getRightAreaName1(), segment.getRightAreaName3());
            }
        }
        return segment;
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord rangeSource, int sac) throws DataSourceException {
        CAN_MMJRangeRecord range = (CAN_MMJRangeRecord)super.convertRangeRecord(rangeSource, sac);
        if (range == null) {
            return null;
        }
        ICAN_UDRangeDataSourceRecord canRangeSource = (ICAN_UDRangeDataSourceRecord)rangeSource;
        if (canRangeSource.hasLDU()) {
            range.setLDU(canRangeSource.getLDU());
        }
        return range;
    }

    protected int getOddEven(IRangeDataSourceRecord rangeSource) throws DataSourceException {
        int oddEven = 0;
        if (rangeSource.hasStatus() && rangeSource.getStatus() != null) {
            String status = rangeSource.getStatus();
            switch (Character.toUpperCase(status.charAt(0))) {
                case 'O': {
                    oddEven = 1;
                    break;
                }
                case 'E': {
                    oddEven = 2;
                }
            }
        }
        if (rangeSource.hasFrom() && rangeSource.hasTo()) {
            String from = rangeSource.getFrom();
            String to = rangeSource.getTo();
            if (from != null && to != null) {
                if (oddEven != 0) {
                    if (this.verifyOddEven(oddEven, from, to)) {
                        return oddEven;
                    }
                    oddEven = 0;
                }
                if (from.equals(to)) {
                    ParsedNumber parsed = new ParsedNumber(from);
                    return parsed.isRangeOddEvenBoth();
                }
            }
        }
        return oddEven;
    }

    private boolean verifyOddEven(int oddEven, String from, String to) {
        ParsedNumber parsedFrom = new ParsedNumber(from);
        ParsedNumber parsedTo = new ParsedNumber(to);
        return oddEven == parsedFrom.isRangeOddEvenBoth() && oddEven == parsedTo.isRangeOddEvenBoth();
    }

    protected MMJStreetRecord createAlternateStreetRecord(MMJStreetRecord standardRecord, IStreetDataSourceRecord input, Address parsed) throws DataCreationException, DataSourceException {
        HashMap fields;
        Object obj;
        MMJStreetRecord record = super.createAlternateStreetRecord(standardRecord, input, parsed);
        Address addr = record.getAddress();
        if (addr.hasAdditionalFields() && (obj = (fields = addr.getAdditionalFields()).get("CAN_REAL_MAIN_ADDRESS")) != null) {
            addr.setMainAddress((String)obj);
            fields.remove("CAN_REAL_MAIN_ADDRESS");
            record.setBrowseKeys(null);
        }
        return record;
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        ArrayList<Address> list = new ArrayList<Address>();
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address addr = this.getParsedStreet(input, preParsed);
        if (addr != null) {
            list.add(addr);
            this.addCleansedAddress(addr, list);
            if (input.hasAlternateMainAddress()) {
                preParsed.setMainAddress(this.makeMainAddressString(input.getAlternateMainAddress(), "100"));
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    list.add(addr);
                    this.addCleansedAddress(addr, list);
                }
            }
        }
        return list;
    }

    private void addCleansedAddress(Address pa, List list) {
        Address cleansedAddr = AddressUtils.cleanseAddress(pa);
        if (cleansedAddr != null) {
            list.add(cleansedAddr);
        }
    }
}

